/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.dashboard;

import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.SpanTag;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class SheetParagraph {
    private String identifier;
    private String title;
    private String style;
    private Set<String> classes = new HashSet<String>();
    private final SpanTag content = TagCreator.span();

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSecureIdentifier() {
        if (this.identifier == null) {
            this.identifier = "unser-identifier-" + new Random().nextInt(999999);
        }
        return this.identifier.toLowerCase().replace("&", " ").replaceAll(" +", " ").replace(" ", "-");
    }

    public String getParagraphClassIdentifier() {
        return "data-sheet-" + this.getSecureIdentifier();
    }

    public SheetParagraph with(DomContent ... tag) {
        for (DomContent addTag : tag) {
            this.content.with(addTag);
        }
        return this;
    }

    public SheetParagraph with(String content) {
        this.content.with((DomContent)TagCreator.text((String)content));
        return this;
    }

    public SheetParagraph withClasses(String ... classes) {
        Collections.addAll(this.classes, classes);
        return this;
    }

    public SheetParagraph withStyle(String style) {
        this.style = style;
        return this;
    }

    public SpanTag getEditableContent() {
        return this.content;
    }

    public DivTag getContent() {
        DivTag contentBuilder = TagCreator.div();
        if (this.classes.size() != 0) {
            contentBuilder.withClasses(this.classes.toArray(new String[0]));
        }
        if (this.style != null) {
            contentBuilder.withStyle(this.style);
        }
        contentBuilder.withClass(this.getParagraphClassIdentifier());
        if (this.title != null) {
            contentBuilder.with((DomContent)TagCreator.h2((String)this.title));
        }
        contentBuilder.with((DomContent)this.content);
        return contentBuilder;
    }
}

