/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.dashboard.elements;

import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.TableTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableBuilder {
    private final String tableClass;
    private final List<Map<String, DomContent>> content = new ArrayList<Map<String, DomContent>>();

    public TableBuilder() {
        this.tableClass = null;
    }

    public TableBuilder(String tableClass) {
        this.tableClass = tableClass;
    }

    public List<Map<String, DomContent>> getRows() {
        return this.content;
    }

    private List<String> getHeaders(List<String> order) {
        ArrayList<String> headers = new ArrayList<String>();
        for (Map<String, DomContent> row : this.content) {
            for (String header : row.keySet()) {
                if (headers.contains(header)) continue;
                headers.add(header);
            }
        }
        ArrayList<String> orderedHeaders = new ArrayList<String>();
        for (String header : order) {
            if (!headers.contains(header)) continue;
            orderedHeaders.add(header);
        }
        for (String header : headers) {
            if (orderedHeaders.contains(header)) continue;
            orderedHeaders.add(header);
        }
        return orderedHeaders;
    }

    public void removeColumn(String column) {
        for (Map<String, DomContent> row : this.content) {
            row.remove(column);
        }
    }

    public TableTag generate() {
        return this.generate(Collections.emptyList());
    }

    public TableTag generate(List<String> order) {
        List<String> headers = this.getHeaders(order);
        TableTag table = TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.each(headers, header -> TagCreator.th((String)header))})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(this.content, row -> TagCreator.tr((DomContent[])new DomContent[]{TagCreator.each((Collection)headers, header -> TagCreator.td((DomContent[])new DomContent[]{(DomContent)row.getOrDefault(header, TagCreator.text((String)""))}))}))})});
        if (this.tableClass != null) {
            table.withClass(this.tableClass);
        }
        return table;
    }

    public Map<String, DomContent> createRow() {
        LinkedHashMap<String, DomContent> row = new LinkedHashMap<String, DomContent>();
        this.content.add(row);
        return row;
    }
}

