/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.diffmerge;

import com.google.common.collect.Maps;
import com.metaeffekt.artifact.analysis.diffmerge.DiffResult;
import com.metaeffekt.artifact.analysis.diffmerge.InventoryMerger;
import com.metaeffekt.artifact.analysis.diffmerge.VulnerabilityStatusDiff;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

public class VulnerabilityDiffer {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityDiffer.class);
    private static final String NA = "n/a";
    private final Inventory inventory1;
    private final Inventory inventory2;

    private VulnerabilityDiffer(Inventory inventory1, Inventory inventory2) {
        this.inventory1 = inventory1;
        this.inventory2 = inventory2;
    }

    public static VulnerabilityDiffer fromInventories(Inventory inventory1, Inventory inventory2) {
        return new VulnerabilityDiffer(inventory1, inventory2);
    }

    public static VulnerabilityDiffer fromFiles(Collection<File> inventories1, Collection<File> inventories2, CentralSecurityPolicyConfiguration securityPolicyConfiguration) throws IOException {
        Map<Inventory, String> parsed1 = VulnerabilityDiffer.readInventoriesIntoContext(inventories1);
        Map<Inventory, String> parsed2 = VulnerabilityDiffer.readInventoriesIntoContext(inventories2);
        Inventory merged1 = VulnerabilityDiffer.mergeInventories(parsed1, securityPolicyConfiguration);
        Inventory merged2 = VulnerabilityDiffer.mergeInventories(parsed2, securityPolicyConfiguration);
        return new VulnerabilityDiffer(merged1, merged2);
    }

    public static VulnerabilityDiffer fromMultipleInventories(Collection<Inventory> inventories1, Collection<Inventory> inventories2, CentralSecurityPolicyConfiguration securityPolicyConfiguration) {
        HashMap inventoryContextMap1 = Maps.newHashMap();
        for (Inventory inventory : inventories1) {
            inventoryContextMap1.put(inventory, "inventory-" + inventoryContextMap1.size());
        }
        HashMap inventoryContextMap2 = Maps.newHashMap();
        for (Inventory inventory : inventories2) {
            inventoryContextMap2.put(inventory, "inventory-" + inventoryContextMap2.size());
        }
        Inventory inventory = VulnerabilityDiffer.mergeInventories(inventoryContextMap1, securityPolicyConfiguration);
        Inventory mergedInventory2 = VulnerabilityDiffer.mergeInventories(inventoryContextMap2, securityPolicyConfiguration);
        return new VulnerabilityDiffer(inventory, mergedInventory2);
    }

    public static VulnerabilityDiffer empty() {
        return new VulnerabilityDiffer(null, null);
    }

    public DiffResult createDiffFromMergedInventories() {
        Inventory containedIn1MissingIn2 = this.findAndMergeDiffVulnerabilities(this.inventory1, this.inventory2);
        Inventory containedIn2MissingIn1 = this.findAndMergeDiffVulnerabilities(this.inventory2, this.inventory1);
        return this.createResult(containedIn1MissingIn2, containedIn2MissingIn1);
    }

    private Inventory findAndMergeDiffVulnerabilities(Inventory before, Inventory after) {
        Inventory mergedInventory = new Inventory();
        HashSet<String> vulnerabilitySuperset = new HashSet<String>();
        this.appendVulnerabilityIdentifiers(before, vulnerabilitySuperset);
        this.appendVulnerabilityIdentifiers(after, vulnerabilitySuperset);
        for (String vulnerability : vulnerabilitySuperset) {
            VulnerabilityMetaData foundBeforeVmd = VulnerabilityDiffer.findVulnerability(before, vulnerability);
            VulnerabilityMetaData foundAfterVmd = VulnerabilityDiffer.findVulnerability(after, vulnerability);
            VulnerabilityMetaData combinedVmd = new VulnerabilityMetaData();
            combinedVmd.set(VulnerabilityMetaData.Attribute.NAME, vulnerability);
            if (this.appendStatusDifference(foundBeforeVmd, foundAfterVmd, combinedVmd)) continue;
            try {
                this.appendCvssScores(foundBeforeVmd, foundAfterVmd, combinedVmd);
                this.appendMatchingCpes(foundBeforeVmd, foundAfterVmd, combinedVmd);
            }
            catch (Exception e) {
                LOG.error("Error while processing vulnerability: {}", (Object)vulnerability, (Object)e);
            }
            mergedInventory.getVulnerabilityMetaData().add(combinedVmd);
        }
        return mergedInventory;
    }

    private boolean appendStatusDifference(VulnerabilityMetaData beforeVmd, VulnerabilityMetaData afterVmd, VulnerabilityMetaData combinedVmd) {
        String afterStatus;
        boolean hasBefore = beforeVmd != null;
        boolean hasAfter = afterVmd != null;
        String beforeStatus = hasBefore ? beforeVmd.get(VulnerabilityMetaData.Attribute.STATUS) : null;
        String string = afterStatus = hasAfter ? afterVmd.get(VulnerabilityMetaData.Attribute.STATUS) : null;
        if (beforeStatus == null && hasBefore) {
            combinedVmd.set(VulnerabilityMetaData.Attribute.STATUS, "in review");
        } else {
            combinedVmd.set(VulnerabilityMetaData.Attribute.STATUS, beforeStatus);
        }
        if (afterStatus == null && hasAfter) {
            combinedVmd.set(InventoryAttribute.VULNERABILITY_DIFF_NEW_STATUS.getKey(), "in review");
        } else {
            combinedVmd.set(InventoryAttribute.VULNERABILITY_DIFF_NEW_STATUS.getKey(), afterStatus);
        }
        if (!hasBefore && !hasAfter) {
            throw new IllegalStateException("Vulnerability must be contained in at least one reference inventory: " + combinedVmd.get(VulnerabilityMetaData.Attribute.NAME));
        }
        if (hasBefore && !hasAfter) {
            if (beforeStatus == null) {
                combinedVmd.set(InventoryAttribute.VULNERABILITY_DIFF_STATUS_CHANGE.getKey(), VulnerabilityStatusDiff.REMOVED.getKey());
            } else {
                combinedVmd.set(InventoryAttribute.VULNERABILITY_DIFF_STATUS_CHANGE.getKey(), VulnerabilityStatusDiff.REMOVED_EXPECTED_VOID.getKey());
            }
            combinedVmd.set(InventoryAttribute.VULNERABILITY_DIFF_NEW_STATUS.getKey(), NA);
        } else if (!hasBefore) {
            combinedVmd.set(InventoryAttribute.VULNERABILITY_DIFF_STATUS_CHANGE.getKey(), VulnerabilityStatusDiff.NEW.getKey());
            combinedVmd.set(VulnerabilityMetaData.Attribute.STATUS, NA);
        } else {
            VulnerabilityStatusDiff statusChange = VulnerabilityStatusDiff.deriveStatusChangeIdentifier(beforeStatus, afterStatus);
            combinedVmd.set(InventoryAttribute.VULNERABILITY_DIFF_STATUS_CHANGE.getKey(), statusChange.getKey());
            if (statusChange.equals((Object)VulnerabilityStatusDiff.NO_CHANGE)) {
                return true;
            }
        }
        return false;
    }

    private void appendCvssScores(VulnerabilityMetaData beforeVmd, VulnerabilityMetaData afterVmd, VulnerabilityMetaData combinedVmd) {
        Vulnerability beforeVulnerability = Vulnerability.fromVulnerabilityMetaData(beforeVmd);
        Vulnerability afterVulnerability = Vulnerability.fromVulnerabilityMetaData(afterVmd);
        if (beforeVulnerability == null && afterVulnerability == null) {
            LOG.warn("Vulnerability {} is not defined in either before or after inventories", (Object)combinedVmd.get(VulnerabilityMetaData.Attribute.NAME));
            return;
        }
        Vulnerability combinedVulnerability = Vulnerability.fromVulnerabilityMetaData(combinedVmd);
        if (beforeVulnerability != null) {
            combinedVulnerability.getCvssVectors().addAllCvssVectors(beforeVulnerability.getCvssVectors());
        }
        if (afterVulnerability != null) {
            combinedVulnerability.getCvssVectors().addAllCvssVectors(afterVulnerability.getCvssVectors());
        }
        combinedVmd.getAttributes().clear();
        combinedVulnerability.appendToBaseModel(combinedVmd);
    }

    private void appendMatchingCpes(VulnerabilityMetaData beforeVmd, VulnerabilityMetaData afterVmd, VulnerabilityMetaData combinedVmd) {
        List<Cpe> beforeCpe = CommonEnumerationUtil.parseEffectiveCpe(beforeVmd);
        List<Cpe> afterCpe = CommonEnumerationUtil.parseEffectiveCpe(afterVmd);
        List<Cpe> merged = CommonEnumerationUtil.distinctAndSortedWithWildcards(beforeCpe, afterCpe);
        combinedVmd.set(VulnerabilityMetaData.Attribute.PRODUCT_URIS.getKey(), CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(merged));
    }

    private void appendVulnerabilityIdentifiers(Inventory inventory, Collection<String> identifiers) {
        inventory.getVulnerabilityMetaData().stream().map(v -> v.get(VulnerabilityMetaData.Attribute.NAME)).forEach(identifiers::add);
    }

    public static VulnerabilityMetaData findVulnerability(Inventory inventory, String name) {
        return inventory.getVulnerabilityMetaData().stream().filter(v -> v.get(VulnerabilityMetaData.Attribute.NAME).equals(name)).findFirst().orElse(null);
    }

    private DiffResult createResult(Inventory containedIn1MissingIn2, Inventory containedIn2MissingIn1) {
        return new DiffResult(this.inventory1, this.inventory2, containedIn1MissingIn2, containedIn2MissingIn1);
    }

    private static Map<Inventory, String> readInventoriesIntoContext(Collection<File> inventoryFiles) throws IOException {
        HashMap inventoryContextMap = Maps.newHashMap();
        for (File inventoryFile : inventoryFiles) {
            if (inventoryFile == null || !inventoryFile.exists()) {
                throw new FileNotFoundException("Inventory file does not exist: " + inventoryFile);
            }
            Inventory inventory = new InventoryReader().readInventory(inventoryFile);
            inventoryContextMap.put(inventory, inventoryFile.getName().replace(".xls", ""));
        }
        return inventoryContextMap;
    }

    private static Inventory mergeInventories(Map<Inventory, String> inventories, CentralSecurityPolicyConfiguration securityPolicyConfiguration) {
        Inventory mergedInventory1 = new Inventory();
        InventoryMerger merger1 = new InventoryMerger(mergedInventory1, securityPolicyConfiguration);
        for (Map.Entry<Inventory, String> inventoryEntry : inventories.entrySet()) {
            Inventory inventory = inventoryEntry.getKey();
            String context = inventoryEntry.getValue();
            merger1.addReferenceInventory(inventory, context);
        }
        merger1.includeVulnerabilities();
        merger1.includeAdvisories();
        return mergedInventory1;
    }
}

