/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.diffmerge;

import java.util.Arrays;

public enum VulnerabilityStatusDiff {
    NO_CHANGE("no change"),
    DOWN_RATED("downrated"),
    UP_RATED("uprated"),
    INTRODUCED("introduced"),
    RE_INTRODUCED("reintroduced"),
    INVALID("invalid"),
    RESOLVED("resolved"),
    VOIDED("resolved"),
    REMOVED("removed"),
    REMOVED_EXPECTED_VOID("removed (expected void)"),
    NEW("new");

    public final String key;
    public static final VulnerabilityStatusDiff[][] STATUS_MAPPINGS;

    private VulnerabilityStatusDiff(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static VulnerabilityStatusDiff findByKey(String key) {
        return Arrays.stream(VulnerabilityStatusDiff.values()).filter(diff -> diff.key.equals(key)).findFirst().orElse(INVALID);
    }

    public static VulnerabilityStatusDiff deriveStatusChangeIdentifier(String before, String after) {
        int beforeIndex = VulnerabilityStatusDiff.deriveStatusIndex(before);
        int afterIndex = VulnerabilityStatusDiff.deriveStatusIndex(after);
        if (beforeIndex == -1 || afterIndex == -1 || beforeIndex >= STATUS_MAPPINGS.length || afterIndex >= STATUS_MAPPINGS.length) {
            return INVALID;
        }
        return STATUS_MAPPINGS[beforeIndex][afterIndex];
    }

    private static int deriveStatusIndex(String status) {
        if (status == null) {
            return 4;
        }
        switch (status) {
            case "applicable": {
                return 0;
            }
            case "not applicable": {
                return 1;
            }
            case "insignificant": {
                return 2;
            }
            case "void": {
                return 3;
            }
        }
        return 4;
    }

    static {
        STATUS_MAPPINGS = new VulnerabilityStatusDiff[][]{{NO_CHANGE, DOWN_RATED, DOWN_RATED, RESOLVED, INVALID}, {UP_RATED, NO_CHANGE, DOWN_RATED, RESOLVED, INVALID}, {UP_RATED, UP_RATED, NO_CHANGE, RESOLVED, INVALID}, {RE_INTRODUCED, RE_INTRODUCED, RE_INTRODUCED, NO_CHANGE, INVALID}, {INTRODUCED, INTRODUCED, INTRODUCED, INTRODUCED, NO_CHANGE}};
    }
}

