/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.metascan;

import com.metaeffekt.artifact.analysis.metascan.AbstractScanSupport;
import com.metaeffekt.artifact.analysis.metascan.ReportController;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.preprocess.filter.TextSieve;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.PropertyUtils;
import com.metaeffekt.artifact.analysis.utils.StringStats;
import com.metaeffekt.artifact.terms.model.FileSegment;
import com.metaeffekt.artifact.terms.model.FileSegmentation;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.ScanResultPart;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MetaScanSupport
extends AbstractScanSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MetaScanSupport.class);
    public static final String FOLDER_INCOMPLETE_MATCH = "incomplete-match";
    public static final String FOLDER_INCOMPLETE_MATCH_FILES = "incomplete-match-files";
    public static final String FOLDER_INDICATED_EXCEPTION = "indicated-exception";
    public static final String FOLDER_INDICATED_EXCEPTIONS_FILES = "indicated-exception-files";
    public static final String FOLDER_LICENSING_OPTION = "licensing-option";
    public static final String FOLDER_LICENSING_OPTION_FILES = "licensing-option-files";
    public static final String FOLDER_UNSPECIFIC_LICENSE = "unspecific-license";
    public static final String FOLDER_UNSPECIFIC_LICENSES_FILES = "unspecific-license-files";
    public static final String FOLDER_INSUFFICIENT_SEGMENTATION = "insufficient-segmentation";
    public static final String FOLDER_INSUFFICIENT_SEGMENTATION_FILES = "insufficient-segmentation-files";
    public static final String FOLDER_INSUFFICIENT_LICENSE_DETAILS = "insufficient-license-details";
    private transient TextSieve textSieve;

    public MetaScanSupport(NormalizationMetaData normalizationMetaData, PropertyProvider propertyProvider) {
        super(normalizationMetaData, propertyProvider);
        try {
            if (normalizationMetaData.getWordlist() == null || normalizationMetaData.getWordlist().isEmpty()) {
                normalizationMetaData.generateAndSetWordlist();
            }
        }
        catch (Exception e) {
            LOG.warn("Failure while generating wordlist: [{}]", (Object)e.getMessage(), (Object)e);
        }
        if (normalizationMetaData.getWordlist() != null && !normalizationMetaData.getWordlist().isEmpty()) {
            this.textSieve = TextSieve.builder().wordlist(normalizationMetaData.getWordlist()).build();
        }
    }

    public boolean execute(Artifact artifact, File unpackedDir) throws IOException {
        return this.execute(artifact, unpackedDir, "no context");
    }

    public boolean execute(Artifact artifact, File unpackedDir, String context) throws IOException {
        Properties p;
        long overwriteResultsOlderThan;
        long resultFileTimestamp;
        File targetFolder = MetaScanSupport.deriveAnalysisFolder(unpackedDir);
        File intermediateFolder = MetaScanSupport.deriveIntermediateFolder(unpackedDir);
        File scratchFolder = MetaScanSupport.deriveScratchFolder(unpackedDir);
        String filename = artifact.getId().replace("/", "_");
        File resultPropertiesFile = new File(targetFolder, filename + "_license.properties");
        File resultJsonFile = new File(targetFolder, filename + "_metascan.json");
        File logFile = new File(targetFolder, filename + "_license-scan.txt");
        File segmentFile = new File(targetFolder, filename + "_license-scan-segments.txt");
        File segmentDebugFile = new File(targetFolder, filename + "_license-scan-segments_debug.txt");
        boolean metaScanEnabled = this.getPropertyProvider().isProperty("analyze.scan.license.enabled", "true", "false");
        HashSet<String> derivedLicenses = new HashSet<String>();
        String artifactScanConfiguration = artifact.get("Scan Configuration");
        boolean artifactScanOverwrite = false;
        if (artifactScanConfiguration != null) {
            artifactScanOverwrite = artifactScanConfiguration.contains("analyze.scan.license.overwrite=true");
        }
        boolean outdatedResult = (resultFileTimestamp = resultPropertiesFile.lastModified()) < (overwriteResultsOlderThan = Long.parseLong(this.getPropertyProvider().getProperty("analyze.scan.license.overwrite.timestamp", "0")));
        boolean overwrite = outdatedResult || artifactScanOverwrite || this.getPropertyProvider().isProperty("analyze.scan.license.overwrite", "true", "false");
        boolean overwriteOnUnknown = this.getPropertyProvider().isProperty("analyze.scan.license.overwrite.unknown", "true", "false");
        boolean overwriteOnIncompleteMatch = this.getPropertyProvider().isProperty("analyze.scan.license.overwrite.incomplete", "true", "false");
        if (!overwrite && resultPropertiesFile.exists() && (overwriteOnUnknown || overwriteOnIncompleteMatch)) {
            p = PropertyUtils.loadProperties(resultPropertiesFile);
            String oldIncompleteMatch = p.getProperty("incomplete.match");
            if (overwriteOnIncompleteMatch && "true".equalsIgnoreCase(oldIncompleteMatch)) {
                LOG.info("{} Rescanning due to incomplete match.", (Object)context);
                overwrite = true;
            }
            String oldDerivedLicenses = p.getProperty("derived.licenses");
            List licenses = InventoryUtils.tokenizeLicense((String)oldDerivedLicenses, (boolean)false, (boolean)false);
            boolean detectedUnknown = false;
            for (String license : licenses) {
                String updatedCanonicalName;
                TermsMetaData termsMetaData = InventoryUtils.getNormalizationMetaData().getTermsMetaData(license);
                if (termsMetaData != null || !(updatedCanonicalName = InventoryUtils.getNormalizationMetaData().getUpdatedCanonicalName(license)).equalsIgnoreCase(license)) continue;
                LOG.info("{} Rescanning due to unknown license [{}].", (Object)context, (Object)license);
                detectedUnknown = true;
                break;
            }
            if (overwriteOnUnknown && detectedUnknown) {
                overwrite = true;
            }
        }
        if (resultJsonFile.exists()) {
            try {
                new JSONArray(FileUtils.readFileToString((File)resultJsonFile, (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                overwrite = true;
                LOG.info("{} Rescanning due to incomplete result file [{}].", (Object)context, (Object)resultJsonFile.getAbsolutePath());
            }
        }
        if (!overwrite && resultPropertiesFile.exists() && intermediateFolder.exists()) {
            p = PropertyUtils.loadProperties(resultPropertiesFile);
            this.applyToArtifact(artifact, p);
            return false;
        }
        if (!metaScanEnabled) {
            return false;
        }
        FileUtils.deleteQuietly((File)resultPropertiesFile);
        FileUtils.deleteQuietly((File)resultJsonFile);
        File incompleteMatchesFolder = new File(targetFolder, filename + "-" + FOLDER_INCOMPLETE_MATCH);
        File incompleteMatchesFileFolder = new File(targetFolder, filename + "-" + FOLDER_INCOMPLETE_MATCH_FILES);
        File indicatedExceptionsFolder = new File(targetFolder, filename + "-" + FOLDER_INDICATED_EXCEPTION);
        File indicatedExceptionsFileFolder = new File(targetFolder, filename + "-" + FOLDER_INDICATED_EXCEPTIONS_FILES);
        File licenseOptionFolder = new File(targetFolder, filename + "-" + FOLDER_LICENSING_OPTION);
        File licenseOptionFileFolder = new File(targetFolder, filename + "-" + FOLDER_LICENSING_OPTION_FILES);
        File unspecificLicenseFolder = new File(targetFolder, filename + "-" + FOLDER_UNSPECIFIC_LICENSE);
        File unspecificLicenseFileFolder = new File(targetFolder, filename + "-" + FOLDER_UNSPECIFIC_LICENSES_FILES);
        File unsufficientSegmentationFolder = new File(targetFolder, filename + "-" + FOLDER_INSUFFICIENT_SEGMENTATION);
        File unsufficientSegmentationFileFolder = new File(targetFolder, filename + "-" + FOLDER_INSUFFICIENT_SEGMENTATION_FILES);
        File insufficientLicenseDetailsFolder = new File(targetFolder, filename + "-" + FOLDER_INSUFFICIENT_LICENSE_DETAILS);
        File reportFolder = new File(targetFolder, filename + "-reports");
        if (incompleteMatchesFolder.exists()) {
            FileUtils.deleteDir(incompleteMatchesFolder);
        }
        if (incompleteMatchesFileFolder.exists()) {
            FileUtils.deleteDir(incompleteMatchesFileFolder);
        }
        if (licenseOptionFolder.exists()) {
            FileUtils.deleteDir(licenseOptionFolder);
        }
        if (licenseOptionFileFolder.exists()) {
            FileUtils.deleteDir(licenseOptionFileFolder);
        }
        if (unspecificLicenseFolder.exists()) {
            FileUtils.deleteDir(unspecificLicenseFolder);
        }
        if (unspecificLicenseFileFolder.exists()) {
            FileUtils.deleteDir(unspecificLicenseFileFolder);
        }
        if (indicatedExceptionsFolder.exists()) {
            FileUtils.deleteDir(indicatedExceptionsFolder);
        }
        if (indicatedExceptionsFileFolder.exists()) {
            FileUtils.deleteDir(indicatedExceptionsFileFolder);
        }
        if (unsufficientSegmentationFolder.exists()) {
            FileUtils.deleteDir(unsufficientSegmentationFolder);
        }
        if (unsufficientSegmentationFileFolder.exists()) {
            FileUtils.deleteDir(unsufficientSegmentationFileFolder);
        }
        if (insufficientLicenseDetailsFolder.exists()) {
            FileUtils.deleteDir(insufficientLicenseDetailsFolder);
        }
        if (reportFolder.exists()) {
            FileUtils.deleteDir(reportFolder);
        }
        if (intermediateFolder.exists()) {
            FileUtils.cleanDirectory((File)intermediateFolder);
        }
        String[] scanIncludes = this.getPropertyProvider().getProperty("analyze.metascan.license.includes", "**/*").split(",");
        String[] scanExcludes = this.getPropertyProvider().getProperty("analyze.metascan.license.excludes", "**/.git/**/*").split(",");
        boolean debugSegments = this.getPropertyProvider().isProperty("analyze.metascan.license.debug.enabled", "true", "false");
        boolean enableReport = this.getPropertyProvider().isProperty("analyze.metascan.report.enable", "true", "false");
        boolean forceReport = this.getPropertyProvider().isProperty("analyze.metascan.report.force", "true", "false");
        boolean useTextSieve = this.getPropertyProvider().isProperty("analyze.sieve.enabled", "true", "false");
        NormalizationMetaData normalizationMetaData = this.getNormalizationMetaData();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(unpackedDir);
        scanner.setIncludes(scanIncludes);
        scanner.setExcludes(scanExcludes);
        scanner.scan();
        String[] filesToScan = scanner.getIncludedFiles();
        this.init(logFile, unpackedDir.getName());
        this.init(segmentFile, unpackedDir.getName());
        if (debugSegments) {
            this.init(segmentDebugFile, unpackedDir.getName());
        }
        boolean[] resultJsonFileSemaphore = new boolean[]{true};
        FileUtils.forceMkDirQuietly(intermediateFolder);
        FileUtils.write((File)resultJsonFile, (CharSequence)"[", (Charset)StandardCharsets.UTF_8);
        int size = filesToScan.length;
        int i = 0;
        for (String fileToScan : filesToScan) {
            ++i;
            HashSet<String> derivedLicensesForFile = new HashSet<String>();
            File file = new File(unpackedDir, fileToScan);
            if (FileUtils.isSymlink((File)file) || FileUtils.matches(file.getAbsolutePath(), scanExcludes)) continue;
            LOG.info("{} ({}/{}) Analyzing file [{}]...", new Object[]{context, i, size, file.getAbsolutePath()});
            String relativeFilePath = this.extractRelativePath(unpackedDir, file);
            try {
                Object fileContent;
                String detectedEncoding = FileUtils.detectEncoding(file);
                if (useTextSieve && this.textSieve != null) {
                    try {
                        Charset detectedCharset = Charset.forName(detectedEncoding);
                        fileContent = this.textSieve.loadFiltered(file, detectedCharset, scratchFolder).toString();
                    }
                    catch (Exception e) {
                        LOG.warn("Could not use TextSieve due to exception: [{}]", (Object)e.getMessage(), (Object)e);
                        fileContent = FileUtils.readFileToString((File)file, (String)FileUtils.detectEncoding(file));
                    }
                } else {
                    fileContent = FileUtils.readFileToString((File)file, (String)FileUtils.detectEncoding(file));
                }
                FileSegmentation fileSegmentation = new FileSegmentation((String)fileContent, normalizationMetaData);
                if (debugSegments) {
                    this.log(segmentDebugFile, fileSegmentation.getMarkedSegmentsString());
                }
                this.log(segmentFile, String.format("%n>>>> [%s] analysis START:", relativeFilePath));
                for (int j = 0; j < fileSegmentation.getSegmentCount(); ++j) {
                    boolean hasLicensingOption;
                    boolean hasSegmentationIssue;
                    boolean hasUnspecificLicenses;
                    boolean hasIndicatedExceptions;
                    StringBuilder resultSummary = new StringBuilder();
                    FileSegment fileSegment = fileSegmentation.getFileSegment(j);
                    String segmentContent = fileSegment.getContent();
                    String id = relativeFilePath + "/" + j;
                    this.log(segmentFile, String.format("%n>>> Segment %d [%s] analysis:%n", j, relativeFilePath));
                    StringStats licenseTextStats = fileSegment.getNormalizedContent();
                    ScanResultPart normalizedLicensesSRP = normalizationMetaData.doAnalyze(licenseTextStats);
                    List<String> matchedLicenses = normalizedLicensesSRP.getMatchedTerms();
                    for (String license : matchedLicenses) {
                        if (!StringUtils.hasText((String)license) || "[]".equals(license)) continue;
                        String message = String.format(">  Matched license [%s] in file [%s/%s]", license, relativeFilePath, j);
                        this.log(segmentFile, message);
                        resultSummary.append(message).append("\n");
                    }
                    normalizedLicensesSRP.process(normalizationMetaData, true, true);
                    fileSegment.setNormalizedSRP(normalizedLicensesSRP);
                    List<String> matchedTerms = normalizedLicensesSRP.getMatchedTerms();
                    try {
                        if (this.segmentHasVariableLicense(matchedTerms)) {
                            fileSegment.setLicenseVariables(this.getVariablesPerLicenseInSegment(matchedTerms, licenseTextStats));
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Variable extraction failed: {}. Execution continued.", (Object)e.getMessage(), (Object)e);
                    }
                    if (matchedTerms.isEmpty()) {
                        String message = String.format("> No terms resolved in file [%s/%s]", relativeFilePath, j);
                        this.log(segmentFile, message);
                        resultSummary.append(message).append("\n");
                    } else {
                        for (String license : new LinkedHashSet<String>(matchedTerms)) {
                            String message = String.format("> Resolved terms [%s] in file [%s/%s]", license, relativeFilePath, j);
                            this.log(segmentFile, message);
                            resultSummary.append(message).append("\n");
                            derivedLicensesForFile.add(license);
                        }
                    }
                    HashSet<String> aggregatedPartialMatches = new HashSet<String>();
                    HashSet<String> aggregatedExcludeMatches = new HashSet<String>();
                    for (String matchedLicense : matchedLicenses) {
                        TermsMetaData lmd = normalizationMetaData.getTermsMetaData(matchedLicense);
                        List<String> partialMatches = lmd.getPartialMatches();
                        List<String> excludeMatches = lmd.getExcludedMatches();
                        if (partialMatches != null) {
                            aggregatedPartialMatches.addAll(partialMatches);
                        }
                        if (excludeMatches == null) continue;
                        aggregatedExcludeMatches.addAll(excludeMatches);
                    }
                    List<String> retainedPartialMatches = normalizedLicensesSRP.getPartialMatchedTerms();
                    retainedPartialMatches.removeAll(aggregatedPartialMatches);
                    retainedPartialMatches.removeAll(aggregatedExcludeMatches);
                    retainedPartialMatches.removeAll(matchedTerms);
                    InventoryUtils.removeMarkers(retainedPartialMatches, normalizationMetaData);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" Aggregates PMs: {}", aggregatedPartialMatches);
                        LOG.debug(" Excluded PMs: {}", aggregatedExcludeMatches);
                        LOG.debug(" Matched PMs: {}", normalizedLicensesSRP.getPartialMatchedTerms());
                        LOG.debug(" Retained PMs: {}", retainedPartialMatches);
                    }
                    boolean hasIncompleteMatches = !retainedPartialMatches.isEmpty();
                    String fileCopyName = FileUtils.computeChecksum((File)file) + "-" + file.getName();
                    if (hasIncompleteMatches) {
                        String message = String.format("> Incomplete license identification in file [%s/%s]: individual matches indicate one of %s", relativeFilePath, j, retainedPartialMatches);
                        this.log(logFile, message);
                        LOG.info("{} ({}/{}) {}", new Object[]{context, i, size, message});
                        this.log(segmentFile, message);
                        resultSummary.append(message).append("\n");
                        derivedLicensesForFile.add("Incomplete Match");
                        if (enableReport) {
                            this.createHtmlReport("Incomplete Match " + relativeFilePath, normalizedLicensesSRP, incompleteMatchesFolder, licenseTextStats, id, retainedPartialMatches, FOLDER_INCOMPLETE_MATCH, filename);
                        }
                        FileUtils.copyFile((File)file, (File)new File(incompleteMatchesFileFolder, fileCopyName));
                    }
                    if (hasIndicatedExceptions = this.isIndicatedExceptionWithoutReference(normalizedLicensesSRP.getMatches())) {
                        String message = String.format("> Indicated exception without reference detected in file [%s/%s].", relativeFilePath, j);
                        this.log(logFile, message);
                        LOG.info("{} ({}/{}) {}", new Object[]{context, i, size, message});
                        this.log(segmentFile, message);
                        resultSummary.append(message).append("\n");
                        derivedLicensesForFile.add("Indicated Exception");
                        if (enableReport) {
                            this.createHtmlReport("Indicated Exception " + relativeFilePath, normalizedLicensesSRP, indicatedExceptionsFolder, licenseTextStats, id, retainedPartialMatches, "indicated-exceptions", filename);
                        }
                        FileUtils.copyFile((File)file, (File)new File(indicatedExceptionsFileFolder, fileCopyName));
                    }
                    if (hasUnspecificLicenses = this.containsUnspecificLicenses(normalizedLicensesSRP.getMatches())) {
                        String message = String.format("> Unspecific license detected in file [%s/%s].", relativeFilePath, j);
                        this.log(logFile, message);
                        LOG.info("{} ({}/{}) {}", new Object[]{context, i, size, message});
                        this.log(segmentFile, message);
                        resultSummary.append(message).append("\n");
                        if (enableReport && ReportController.getInstance().createReportFor(normalizedLicensesSRP, licenseTextStats)) {
                            this.createHtmlReport("Unspecific License " + relativeFilePath, normalizedLicensesSRP, unspecificLicenseFolder, licenseTextStats, id, retainedPartialMatches, "unspecific-licenses", filename);
                        }
                        FileUtils.copyFile((File)file, (File)new File(unspecificLicenseFileFolder, fileCopyName));
                    }
                    if (hasSegmentationIssue = this.hasSegmentationIssue(normalizedLicensesSRP.getTextMatchedTerms(), matchedTerms)) {
                        String message = String.format("> Segmentation Issue detected in file [%s/%s].", relativeFilePath, j);
                        this.log(logFile, message);
                        LOG.info("{} ({}/{}) {}", new Object[]{context, i, size, message});
                        this.log(segmentFile, message);
                        resultSummary.append(message).append("\n");
                        if (enableReport) {
                            this.createHtmlReport("Segmentation Issue " + relativeFilePath, normalizedLicensesSRP, unsufficientSegmentationFolder, licenseTextStats, id, retainedPartialMatches, "segmentation-issue", filename);
                        }
                        FileUtils.copyFile((File)file, (File)new File(unsufficientSegmentationFileFolder, fileCopyName));
                    }
                    boolean bl = hasLicensingOption = matchedTerms.contains("Licensing Option") || matchedTerms.contains("License Option Marker");
                    if (hasLicensingOption) {
                        String message = String.format("> License options detected in file [%s/%s].", relativeFilePath, j);
                        this.log(logFile, message);
                        LOG.info("{} ({}/{}) {}", new Object[]{context, i, size, message});
                        this.log(segmentFile, message);
                        resultSummary.append(message).append("\n");
                        if (enableReport) {
                            this.createHtmlReport("Licensing Option " + relativeFilePath, normalizedLicensesSRP, licenseOptionFolder, licenseTextStats, id, retainedPartialMatches, FOLDER_LICENSING_OPTION, filename);
                        }
                        FileUtils.copyFile((File)file, (File)new File(licenseOptionFileFolder, fileCopyName));
                    }
                    if (forceReport) {
                        this.createHtmlReport("Scan Report " + relativeFilePath, normalizedLicensesSRP, reportFolder, licenseTextStats, id, retainedPartialMatches, "scan-report", filename);
                    }
                    this.log(segmentFile, String.format("%n>>> Segment %d [%s] content START: >>>%n%n%s%n%n<<< Segment %d [%s] content END <<<%n", j, relativeFilePath, segmentContent, j, relativeFilePath));
                    this.log(segmentFile, resultSummary);
                    derivedLicenses.addAll(derivedLicensesForFile);
                }
                this.writeIntermediateFileStructure(unpackedDir, file, fileSegmentation, intermediateFolder, resultJsonFile, resultJsonFileSemaphore);
            }
            catch (Exception e) {
                LOG.error("EM1: " + e.getMessage(), (Throwable)e);
            }
            HashSet<String> insufficientLicenseDetails = new HashSet<String>();
            for (String license : derivedLicenses) {
                TermsMetaData tmd = normalizationMetaData.getTermsMetaData(license);
                if (tmd == null || tmd.isException() || tmd.isExpression() || tmd.isMarker() || tmd.isUnspecific() || tmd.allowLaterVersions() || tmd.getRequiresLicenseText() != null && tmd.getRequiresCopyright() != null) continue;
                insufficientLicenseDetails.add(license);
            }
            if (!insufficientLicenseDetails.isEmpty()) {
                FileUtils.forceMkdir((File)insufficientLicenseDetailsFolder);
                File output = new File(insufficientLicenseDetailsFolder + "/insufficientLicenseDetails.txt");
                FileWriter writer = new FileWriter(output);
                for (String s : insufficientLicenseDetails) {
                    writer.write(s + System.lineSeparator());
                }
                writer.close();
            }
            Set<String> removableLicenses = InventoryUtils.collectCoveredRemovableLicenses(derivedLicensesForFile);
            derivedLicensesForFile.removeAll(removableLicenses);
            if (derivedLicensesForFile.size() > 0) {
                this.log(segmentFile, String.format("<<<< Resolved license set for [%s]:%n %s%n", fileToScan, derivedLicensesForFile));
                this.log(logFile, String.format("<<<< Resolved license set for [%s]:%n %s", fileToScan, derivedLicensesForFile));
            }
            if (removableLicenses.size() > 0) {
                this.log(segmentFile, String.format("<<<< Removed license set for [%s]:%n %s%n", fileToScan, removableLicenses));
                this.log(logFile, String.format("<<<< Removed license set for [%s]:%n %s", fileToScan, removableLicenses));
            }
            this.log(segmentFile, String.format("<<<< [%s] analysis END <<<<", relativeFilePath));
            if (derivedLicensesForFile.size() > 0) {
                LOG.info("{} ({}/{}) Analyzing file [{}] resolved {}", new Object[]{context, i, size, file.getAbsolutePath(), derivedLicensesForFile});
            } else {
                LOG.info("{} ({}/{}) Analyzing file [{}].", new Object[]{context, i, size, file.getAbsolutePath()});
            }
            if (removableLicenses.size() <= 0) continue;
            LOG.info("{} ({}/{}) Analyzing file [{}] removed [{}]", new Object[]{context, i, size, file.getAbsolutePath(), removableLicenses});
        }
        FileUtils.write((File)resultJsonFile, (CharSequence)"]", (Charset)StandardCharsets.UTF_8, (boolean)true);
        String deriveLicenseResult = "";
        if (!derivedLicenses.isEmpty()) {
            ArrayList<String> orderedList = new ArrayList<String>(derivedLicenses);
            Collections.sort(orderedList, String.CASE_INSENSITIVE_ORDER);
            deriveLicenseResult = com.metaeffekt.artifact.analysis.utils.StringUtils.toString(orderedList);
        }
        Properties result = new Properties();
        result.setProperty("derived.licenses", deriveLicenseResult);
        result.setProperty("incomplete.match", String.valueOf(derivedLicenses.contains("Incomplete Match")));
        this.applyToArtifact(artifact, result);
        PropertyUtils.saveProperties(resultPropertiesFile, result);
        return true;
    }

    public static File deriveIntermediateFolder(File analysisDir) {
        return new File(analysisDir.getParentFile(), analysisDir.getName() + "-intermediate");
    }

    public static File deriveAnalysisFolder(File analysisDir) {
        return new File(analysisDir.getParentFile(), analysisDir.getName() + "-analysis");
    }

    public static File deriveScratchFolder(File analysisDir) {
        return new File(analysisDir.getParentFile(), analysisDir.getName() + "-scratch");
    }

    private boolean hasSegmentationIssue(List<String> licenses, List<String> relevantMatches) {
        licenses.removeIf(license -> !relevantMatches.contains(license));
        InventoryUtils.removeMarkers(licenses, this.getNormalizationMetaData());
        return licenses.size() > 1;
    }

    private void writeIntermediateFileStructure(File unpackBaseDir, File file, FileSegmentation fileSegmentation, File intermediateFolder, File resultJsonFile, boolean[] resultJsonFileSemaphore) {
        String filePath = FileUtils.asRelativePath((File)unpackBaseDir, (File)file);
        File intermediateFile = new File(intermediateFolder, filePath);
        try {
            JSONObject jsonFileObject = new JSONObject();
            JSONObject jsonSegmentsObject = new JSONObject();
            jsonFileObject.put("file", (Object)filePath);
            List<FileSegment> segmentFoldersForScancode = fileSegmentation.combineSegmentsAndWriteFoldersForScancode(intermediateFile);
            jsonFileObject.put("segmentCount", segmentFoldersForScancode.size());
            for (int j = 0; j < segmentFoldersForScancode.size(); ++j) {
                FileSegment fileSegment = segmentFoldersForScancode.get(j);
                ScanResultPart normalizedSRP = fileSegment.getNormalizedSRP();
                if (normalizedSRP != null) {
                    JSONObject segmentResult = new JSONObject();
                    List<String> nameMatchedLicenses = normalizedSRP.getNameMatchedTerms();
                    List<String> textMatchedLicenses = normalizedSRP.getTextMatchedTerms();
                    List<String> resolvedLicenses = normalizedSRP.getMatchedTerms();
                    if (!nameMatchedLicenses.isEmpty()) {
                        segmentResult.put("nameMatches", nameMatchedLicenses);
                    }
                    if (!textMatchedLicenses.isEmpty()) {
                        segmentResult.put("textMatches", textMatchedLicenses);
                    }
                    if (!resolvedLicenses.isEmpty()) {
                        segmentResult.put("resolvedLicenses", resolvedLicenses);
                    }
                    if (fileSegment.getLicenseVariables() != null) {
                        segmentResult.put("variables", (Object)fileSegment.getLicenseVariables());
                    }
                    jsonSegmentsObject.put("segment-" + j, (Object)segmentResult);
                }
                jsonFileObject.put("segments", (Object)jsonSegmentsObject);
            }
            if (!resultJsonFileSemaphore[0]) {
                FileUtils.write((File)resultJsonFile, (CharSequence)",", (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            FileUtils.write((File)resultJsonFile, (CharSequence)jsonFileObject.toString(), (Charset)StandardCharsets.UTF_8, (boolean)true);
            resultJsonFileSemaphore[0] = false;
        }
        catch (Exception e) {
            LOG.warn("Creating folder for scancode failed for {}: {}. Execution continued.", (Object)file.getName(), (Object)e.getMessage());
        }
    }

    private boolean containsUnspecificLicenses(List<TermsMetaData> termsMetaData) {
        for (TermsMetaData tmd : termsMetaData) {
            if (tmd == null || !tmd.isUnspecific()) continue;
            return true;
        }
        return false;
    }

    protected void applyToArtifact(Artifact artifact, Properties p) {
        String derivedLicensesFromP = p.getProperty("derived.licenses");
        if (derivedLicensesFromP == null) {
            derivedLicensesFromP = p.getProperty("identified.terms");
        }
        if (derivedLicensesFromP == null) {
            derivedLicensesFromP = "";
        }
        if (derivedLicensesFromP.contains("Incomplete Match")) {
            String incompleteMatch = p.getProperty("incomplete.match", "false");
            artifact.set("Incomplete Match", incompleteMatch);
        }
        artifact.set("Identified Terms", derivedLicensesFromP);
    }

    protected void createHtmlReport(String htmlReportTitle, ScanResultPart scanResultPart, File targetDir, StringStats textStats, String segmentId, List<String> retainedPartialMatches, String type, String id) {
        try {
            File htmlReportFile = new File(targetDir, id + "_" + type + segmentId.replace("/", "_") + ".html");
            TermsMetaData tempLicenseMetaData = new TermsMetaData();
            tempLicenseMetaData.setCanonicalName(htmlReportTitle);
            tempLicenseMetaData.createMatchReportHtml(textStats, scanResultPart, htmlReportFile, retainedPartialMatches);
        }
        catch (Throwable e) {
            LOG.error("Cannot generate HTML Report!", e);
        }
    }

    public String extractRelativePath(File baseDir, File file) {
        String baseDirPath;
        String filePath = file.getPath();
        if (filePath.startsWith(baseDirPath = baseDir.getPath())) {
            return filePath.substring(baseDirPath.length());
        }
        return filePath;
    }

    private JSONArray getVariablesPerLicenseInSegment(List<String> normalizedLicenses, StringStats licenseTextStats) {
        JSONArray licenseVariablesArray = new JSONArray();
        for (String license : normalizedLicenses) {
            JSONObject licenseVariables = new JSONObject();
            if (!this.licenseHasVariable(license)) continue;
            licenseVariables.put(license, (Object)this.getVariableKeyValuePerLicense(license, licenseTextStats));
            licenseVariablesArray.put((Object)licenseVariables);
        }
        return licenseVariablesArray;
    }

    private boolean segmentHasVariableLicense(List<String> matchedLicenses) {
        for (String license : matchedLicenses) {
            if (!this.licenseHasVariable(license)) continue;
            return true;
        }
        return false;
    }

    private boolean licenseHasVariable(String license) {
        TermsMetaData termsMetaData = this.getNormalizationMetaData().getTermsMetaData(license);
        if (termsMetaData != null && termsMetaData.getLicenseTemplate() != null) {
            String licenseTemplate = termsMetaData.getLicenseTemplate();
            return licenseTemplate.matches(".*\\{\\{([^\\}]+)}}.*");
        }
        return false;
    }

    protected JSONObject getVariableKeyValuePerLicense(String license, StringStats licenseTextStats) {
        JSONObject keyValuePairs = new JSONObject();
        ArrayList<String> processedKeys = new ArrayList<String>();
        String licenseTemplateOriginal = this.getNormalizationMetaData().getTermsMetaData(license).getLicenseTemplate();
        StringStats normalizedLicenseTemplate = StringStats.normalize(licenseTemplateOriginal, false);
        String licenseTemplate = normalizedLicenseTemplate.getNormalizedString();
        licenseTemplate = licenseTemplate.replaceAll("\\{ \\{ ", "{{").replaceAll(" } }", "}}");
        licenseTemplate = licenseTemplate.replaceAll("\\<.*?\\>", "");
        licenseTemplate = licenseTemplate.replaceAll("\"", "");
        licenseTemplate = licenseTemplate.replaceAll(" {2,}", " ");
        licenseTemplate = licenseTemplate.replaceAll(" ?\\{\\{", "\u02dc{{").replaceAll("}} ?", "}}\u02dc");
        String[] licenseTemplateWord = licenseTemplate.split(" |\u02dc");
        block0: for (int i = 0; i < licenseTemplateWord.length; ++i) {
            if (!licenseTemplateWord[i].matches("\\{\\{.*?}}") || processedKeys.contains(licenseTemplateWord[i])) continue;
            boolean matched = false;
            boolean failed = false;
            int index = 1;
            while (!matched) {
                int a;
                int b;
                String before = "";
                String after = "";
                for (b = index; b > 0; --b) {
                    if (i - b < 0) {
                        failed = true;
                        break;
                    }
                    if (licenseTemplateWord[i - b] == null) continue;
                    for (a = b; a > 0; --a) {
                        before = (before + " " + licenseTemplateWord[i - a]).trim();
                    }
                    break;
                }
                for (b = index; b > 0; --b) {
                    if (i + b >= licenseTemplateWord.length) continue;
                    for (a = 1; a <= b; ++a) {
                        after = (after + " " + licenseTemplateWord[i + a]).trim();
                    }
                    break;
                }
                if (before.equals("") && after.equals("") || failed) {
                    keyValuePairs.put(licenseTemplateWord[i].replace("{{", "").replace("}}", ""), (Object)"");
                    processedKeys.add(licenseTemplateWord[i]);
                    matched = true;
                    continue block0;
                }
                StringStats stringStatsBefore = StringStats.normalize(before, true);
                StringStats stringStatsAfter = StringStats.normalize(after, true);
                int[] beforeMatches = licenseTextStats.allMatchesOriginalString(stringStatsBefore);
                int[] afterMatches = licenseTextStats.allMatchesOriginalString(stringStatsAfter);
                if (beforeMatches.length == 1 && afterMatches.length == 1 && beforeMatches[0] < afterMatches[0]) {
                    String content = licenseTextStats.getNormalizedString().substring(beforeMatches[0] + before.length(), afterMatches[0] - 1);
                    if (!this.noSpaceBeforePlaceholder(licenseTemplateOriginal, licenseTemplateWord[i]) || !content.startsWith(" ")) {
                        content = content.trim();
                    }
                    keyValuePairs.put(licenseTemplateWord[i].replace("{{", "").replace("}}", ""), (Object)("\"" + content + "\""));
                    matched = true;
                    processedKeys.add(licenseTemplateWord[i]);
                    continue;
                }
                if (beforeMatches.length == 1 && afterMatches.length == 1 && beforeMatches[0] > afterMatches[0]) {
                    keyValuePairs.put(licenseTemplateWord[i].replace("{{", "").replace("}}", ""), (Object)"\n");
                    matched = true;
                    processedKeys.add(licenseTemplateWord[i]);
                    continue;
                }
                if (beforeMatches.length == 0 | afterMatches.length == 0) {
                    keyValuePairs.put(licenseTemplateWord[i].replace("{{", "").replace("}}", ""), (Object)"");
                    matched = true;
                    processedKeys.add(licenseTemplateWord[i]);
                    continue;
                }
                Arrays.fill(beforeMatches, -1);
                Arrays.fill(afterMatches, -1);
                ++index;
            }
        }
        return keyValuePairs;
    }

    private boolean noSpaceBeforePlaceholder(String licenseTemplate, String placeholder) {
        int i = licenseTemplate.indexOf(placeholder);
        char c = licenseTemplate.charAt(i - 1);
        return !(c == ' ' | c == '>');
    }

    private boolean isIndicatedExceptionWithoutReference(List<TermsMetaData> terms) {
        for (TermsMetaData tmd : terms) {
            if (!tmd.isException()) continue;
            return true;
        }
        return false;
    }
}

