/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.preprocess.filter.matcher;

import com.metaeffekt.artifact.analysis.preprocess.filter.range.IntegerDiscreteRangeMap;
import java.util.Collection;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.Trie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringMatchGeneratorAhoCorasick {
    private static final Logger log = LoggerFactory.getLogger(StringMatchGeneratorAhoCorasick.class);
    private final Trie trie;
    private final Integer includeReach;

    public StringMatchGeneratorAhoCorasick(Collection<String> wordlist, Integer includeReach) {
        Trie.TrieBuilder trieBuilder = Trie.builder().ignoreCase().onlyWholeWords();
        trieBuilder.addKeywords(wordlist);
        this.trie = trieBuilder.build();
        this.includeReach = includeReach;
    }

    public IntegerDiscreteRangeMap<Integer> getMatchMap(CharSequence inputText) {
        IntegerDiscreteRangeMap<Integer> map = new IntegerDiscreteRangeMap<Integer>();
        log.trace("Parsing input text.");
        Collection emits = this.trie.parseText(inputText);
        log.trace("Putting [{}] emits into range-map.", (Object)emits.size());
        for (Emit emit : emits) {
            map.putCombining(emit.getStart() - this.includeReach, emit.getEnd() + this.includeReach, (Integer)1, Integer::sum);
        }
        return map;
    }
}

