/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.report;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class ResultInventory
implements Comparable<ResultInventory> {
    public static final Logger LOG = LoggerFactory.getLogger(ResultInventory.class);
    private Inventory inventory;
    private long timestamp;

    public ResultInventory from(File inventoryFile) throws IOException {
        Validate.notNull((Object)inventoryFile, (String)"Inventory file must not be <null>", (Object[])new Object[0]);
        Validate.isTrue((boolean)inventoryFile.exists(), (String)String.format("Inventory file [%s] must exist.", inventoryFile.getPath()), (Object[])new Object[0]);
        String inventoryName = this.extractInventoryName(inventoryFile);
        this.timestamp = this.extractTimestamp(inventoryFile, inventoryName);
        this.inventory = new InventoryReader().readInventory(inventoryFile);
        return this;
    }

    protected long extractTimestamp(File inventoryFile, String inventoryName) {
        long timestamp = inventoryFile.lastModified();
        try {
            timestamp = Long.parseLong(inventoryName);
        }
        catch (NumberFormatException e) {
            LOG.error("Expecting file name to contain timestamp of creation, but was [{}].", (Object)inventoryName);
        }
        return timestamp;
    }

    protected String extractInventoryName(File inventoryFile) {
        String inventoryName = inventoryFile.getName();
        int endIndex = inventoryName.toLowerCase().lastIndexOf(".xls");
        if (endIndex > 0) {
            inventoryName = inventoryName.substring(0, endIndex);
        }
        return inventoryName;
    }

    public static ResultInventory fromFile(File inventoryFile) throws IOException {
        return new ResultInventory().from(inventoryFile);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(@NonNull ResultInventory o) {
        return Long.compare(this.timestamp, o.timestamp);
    }

    public String toString() {
        return "ResultInventory{artifacts=" + this.inventory.getArtifacts().size() + ", timestamp=" + this.timestamp + '}';
    }
}

