/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.scancode;

import com.metaeffekt.artifact.analysis.model.DefaultPropertyProvider;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeBackend;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeClient;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeDefaultBackend;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeHttpClient;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeParser;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeProcessClient;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeService;
import com.metaeffekt.artifact.analysis.scancode.ThrowingStrategy;
import com.metaeffekt.artifact.analysis.scancode.WaitForeverStrategy;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.PropertyUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.TreeSet;
import org.json.JSONException;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanCodeSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ScanCodeSupport.class);
    private static final String COPYRIGHT_AUTHOR_SEPARATOR = String.format("|%n", new Object[0]);
    private final ScanCodeClient scancodeClient;
    private final PropertyProvider propertyProvider;

    public ScanCodeSupport(PropertyProvider propertyProvider) {
        this.propertyProvider = propertyProvider == null ? new DefaultPropertyProvider() : propertyProvider;
        this.scancodeClient = this.createClient();
    }

    protected ScanCodeClient createClient() {
        if (this.propertyProvider.isProperty("analyze.scan.scancode.clientType", "service", null)) {
            String endpointUrl = this.propertyProvider.getProperty("scancode.service.endpointUrl", "http://localhost:8000");
            ScanCodeService service = ScanCodeService.create((String)endpointUrl);
            ScanCodeDefaultBackend backend = new ScanCodeDefaultBackend(service, ScanCodeService.getErrorConverter((String)endpointUrl));
            return new ScanCodeHttpClient((ScanCodeBackend)backend, (ThrowingStrategy)new WaitForeverStrategy(10));
        }
        return new ScanCodeProcessClient(this.propertyProvider.getProperty("analyze.scancode.threads", "2"));
    }

    public boolean execute(Artifact artifact, File analysisDir) throws JSONException {
        String sourceFolderName = analysisDir.getName();
        File targetFolder = new File(analysisDir.getParentFile(), sourceFolderName + "-analysis");
        File intermediateFolder = new File(analysisDir.getParentFile(), sourceFolderName + "-intermediate");
        return this.execute(artifact, intermediateFolder, targetFolder);
    }

    public boolean execute(Artifact artifact, File intermediateDir, File resultDir) throws JSONException {
        boolean overwrite;
        String filename = artifact.getId().replace("/", "_");
        File scanCodeResultPropertiesFile = new File(resultDir, filename + "_scancode.properties");
        File scanCodeResultFile = new File(resultDir, filename + "_scancode.json");
        resultDir.mkdirs();
        boolean scancodeEnabled = this.isProperty("analyze.scan.scancode.enabled", "true", "false");
        boolean overwriteParsedResult = this.isProperty("analyze.scan.scancode.parse.overwrite", "true", "false");
        boolean overwriteScancodeResult = this.isProperty("analyze.scan.scancode.overwrite", "true", "false");
        long overwriteResultsOlderThan = Long.parseLong(this.getProperty("analyze.scan.scancode.overwrite.timestamp", "0"));
        boolean outdatedResult = !scanCodeResultFile.exists() || scanCodeResultFile.lastModified() < overwriteResultsOlderThan;
        boolean bl = overwrite = outdatedResult || overwriteScancodeResult;
        if (overwrite) {
            overwriteParsedResult = true;
        }
        if (!overwriteParsedResult && scanCodeResultPropertiesFile.exists()) {
            Properties p = PropertyUtils.loadProperties(scanCodeResultPropertiesFile);
            this.applyToArtifact(artifact, p);
            return false;
        }
        if (!scancodeEnabled) {
            return false;
        }
        String includes = this.getProperty("analyze.metascan.license.includes", "**/*");
        includes = this.getProperty("analyze.scancode.license.includes", includes);
        String[] scanIncludes = includes.split(",");
        String excludes = this.getProperty("analyze.metascan.license.excludes", "**/.git/**/*");
        excludes = this.getProperty("analyze.scancode.license.excludes", excludes);
        String[] scanExcludes = excludes.split(",");
        String scanCodeResultAsString = null;
        if (!overwrite && scanCodeResultFile.exists()) {
            scanCodeResultAsString = ScanCodeSupport.testFile(scanCodeResultFile, scanIncludes, scanExcludes);
        }
        if (StringUtils.isEmpty(scanCodeResultAsString)) {
            scanCodeResultAsString = this.runScanCode(intermediateDir, scanCodeResultFile);
        }
        if (scanCodeResultFile.exists() && StringUtils.notEmpty(scanCodeResultAsString)) {
            this.parseResults(artifact, intermediateDir, scanCodeResultAsString, scanIncludes, scanExcludes, scanCodeResultPropertiesFile);
        }
        return true;
    }

    private static String testFile(File scanCodeResultFile, String[] scanIncludes, String[] scanExcludes) {
        String scanCodeResultAsString;
        try {
            scanCodeResultAsString = FileUtils.readFileToString((File)scanCodeResultFile, (String)"UTF-8");
            if (StringUtils.hasText(scanCodeResultAsString)) {
                TreeSet<String> licenseList = new TreeSet<String>();
                TreeSet<String> copyrightList = new TreeSet<String>();
                TreeSet<String> authorList = new TreeSet<String>();
                ScanCodeParser.parseScanCodeResult(scanCodeResultAsString, licenseList, copyrightList, authorList, scanIncludes, scanExcludes);
            }
        }
        catch (IOException e) {
            LOG.warn("Failure parsing existing scancode result: {}", (Object)e.getMessage());
            scanCodeResultAsString = null;
        }
        if (scanCodeResultAsString == null || scanCodeResultAsString.trim().isEmpty()) {
            scanCodeResultAsString = null;
        }
        return scanCodeResultAsString;
    }

    private String runScanCode(File intermediateDir, File scanCodeResultFile) {
        String scanCodeResultAsString;
        LOG.info("  Running scancode on folder {}...", (Object)intermediateDir.getAbsolutePath());
        try {
            this.scancodeClient.scan(intermediateDir.getAbsolutePath(), scanCodeResultFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOG.error("Failure executing scancode. {}", (Object)e.getMessage(), (Object)e);
        }
        if (scanCodeResultFile.exists()) {
            try {
                scanCodeResultAsString = FileUtils.readFileToString((File)scanCodeResultFile, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new IllegalStateException("ScanCode execution was not successful. Cannot read file.");
            }
        } else {
            throw new IllegalStateException("ScanCode execution was not successful. No file was produced. Expected: " + scanCodeResultFile);
        }
        LOG.info("  Running ScanCode on folder {} completed.", (Object)intermediateDir);
        return scanCodeResultAsString;
    }

    private void parseResults(Artifact artifact, File intermediateDir, String scanCodeResultAsString, String[] scanIncludes, String[] scanExcludes, File scanCodeResultPropertiesFile) {
        LOG.info("  Parsing ScanCode results for folder {}...", (Object)intermediateDir);
        Properties resultProperties = new Properties();
        TreeSet<String> licenseList = new TreeSet<String>();
        TreeSet<String> copyrightList = new TreeSet<String>();
        TreeSet<String> authorList = new TreeSet<String>();
        ScanCodeParser.parseScanCodeResult(scanCodeResultAsString, licenseList, copyrightList, authorList, scanIncludes, scanExcludes);
        resultProperties.setProperty("detected.licenses", licenseList.toString());
        String copyrightListString = String.join((CharSequence)COPYRIGHT_AUTHOR_SEPARATOR, copyrightList);
        resultProperties.setProperty("detected.copyrights", copyrightListString);
        String authorListString = String.join((CharSequence)COPYRIGHT_AUTHOR_SEPARATOR, authorList);
        resultProperties.setProperty("detected.authors", authorListString);
        LOG.debug("    ScanCode license list: {}", licenseList);
        LOG.debug("    ScanCode copyright list: {}", copyrightList);
        this.applyToArtifact(artifact, resultProperties);
        PropertyUtils.saveProperties(scanCodeResultPropertiesFile, resultProperties);
        LOG.info("  Parsing ScanCode results on folder {} completed.", (Object)intermediateDir);
    }

    public boolean isProperty(String key, String testValue, String defaultValue) {
        return this.propertyProvider.isProperty(key, testValue, defaultValue);
    }

    public String getProperty(String key, String defaultValue) {
        return this.propertyProvider.getProperty(key, defaultValue);
    }

    protected void applyToArtifact(Artifact artifact, Properties p) {
        artifact.set("Derived Licenses (ScanCode)", p.getProperty("detected.licenses"));
        artifact.set("Extracted Copyrights (ScanCode)", p.getProperty("detected.copyrights"));
        artifact.set("Extracted Authors (ScanCode)", p.getProperty("detected.authors"));
    }
}

