/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.github.katjahahn.parser.FileFormatException;
import com.github.katjahahn.parser.PEData;
import com.github.katjahahn.parser.PELoader;
import com.github.katjahahn.tools.PEFileDumper;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveUtils
extends org.metaeffekt.core.util.ArchiveUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveUtils.class);
    private static final Set<String> peExtensions = new HashSet<String>();

    public static void recursiveUnpack(File baseDir, List<String> issues) throws IOException {
        String[] files;
        for (String file : files = FileUtils.scanDirectoryForFiles((File)baseDir, (String[])new String[]{"**/*.tar.gz", "**/*.tar.bz2", "**/*.tgz", "**/*.tar.xz", "**/*.tar", "**/*.deb", "**/*.rpm", "**/*.apk", "**/*.zip", "**/*.war", "**/*.jar", "**/*.mbizip", "**/*.nupkg", "**/*.nupack", "**/*.aar", "**/*.dll", "**/*.pyd", "**/*.exe", "**/*.jmod", "**/modules, **/*.ez"})) {
            File archiveFile = new File(baseDir, file);
            File targetPath = new File(archiveFile.getParentFile(), "[" + archiveFile.getName() + "]");
            if (targetPath.exists()) continue;
            boolean created = targetPath.mkdirs();
            if (ArchiveUtils.unpackIfPossible(archiveFile, targetPath, new ArrayList<String>())) {
                FileUtils.forceDelete((File)archiveFile);
                ArchiveUtils.recursiveUnpack(targetPath, issues);
                continue;
            }
            FileUtils.deleteDir(targetPath);
            issues.add("Cannot unpack " + archiveFile);
        }
    }

    public static boolean unpackIfPossible(File archiveFile, File targetDir, List<String> issues) {
        Project project = new Project();
        project.setBaseDir(archiveFile.getParentFile());
        String extension = FilenameUtils.getExtension((String)archiveFile.getName()).toLowerCase();
        if (extension.isEmpty()) {
            extension = archiveFile.getName().toLowerCase();
        }
        try {
            if (peExtensions.contains(extension)) {
                PEData peData = PELoader.loadPE((File)archiveFile);
                PEFileDumper peFileDumper = new PEFileDumper(peData, targetDir);
                targetDir.mkdirs();
                ArchiveUtils.doAndCheckForKnownIssues(() -> peFileDumper.dumpSections(), archiveFile);
                ArchiveUtils.doAndCheckForKnownIssues(() -> peFileDumper.dumpIcons(), archiveFile);
                ArchiveUtils.doAndCheckForKnownIssues(() -> peFileDumper.dumpOverlay(), archiveFile);
                ArchiveUtils.doAndCheckForKnownIssues(() -> peFileDumper.dumpResources(), archiveFile);
                return true;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("EM2: " + ex.getMessage(), ex);
        }
        return org.metaeffekt.core.util.ArchiveUtils.unpackIfPossible((File)archiveFile, (File)targetDir, issues);
    }

    private static void doAndCheckForKnownIssues(Runnable runnable, File archiveFile) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (e.getClass().isAssignableFrom(FileNotFoundException.class)) {
                LOG.warn("Cannot fully unwrap [{}]. Issue acceptable: {}", (Object)archiveFile.getPath(), (Object)e.getMessage());
                return;
            }
            if (e.getClass().isAssignableFrom(FileFormatException.class)) {
                LOG.warn("Cannot fully unwrap [{}]. Issue acceptable: {}", (Object)archiveFile.getPath(), (Object)e.getMessage());
                return;
            }
            throw e;
        }
    }

    public static void unpackArchiveOrCopyFile(File archiveFile, File unpackTargetDir) {
        File[] array;
        if (!archiveFile.exists()) {
            return;
        }
        if (unpackTargetDir == null) {
            return;
        }
        File marker = new File(unpackTargetDir.getParentFile(), unpackTargetDir.getName() + ".lock");
        if (marker.exists()) {
            LOG.warn("Detected .lock file. Previous unpack process incomplete or not successful for [{}].", (Object)unpackTargetDir.getPath());
            FileUtils.deleteDir(unpackTargetDir);
        }
        if (unpackTargetDir.exists() && (array = unpackTargetDir.listFiles()) != null && array.length > 0) {
            return;
        }
        try {
            FileUtils.touch((File)marker);
        }
        catch (IOException e) {
            LOG.debug("Cannot touch/create marker file: " + marker);
        }
        if (!unpackTargetDir.exists()) {
            unpackTargetDir.mkdirs();
        }
        boolean failure = false;
        LOG.debug(String.format("Unpacking artifact %s.", archiveFile.getName()));
        boolean unpacked = ArchiveUtils.unpackIfPossible(archiveFile, unpackTargetDir, new ArrayList<String>());
        if (!unpacked) {
            File destFile = new File(unpackTargetDir, archiveFile.getName());
            try {
                FileUtils.copyFile((File)archiveFile, (File)destFile);
            }
            catch (IOException e) {
                LOG.warn(String.format("Cannot copy [%s]. %s", archiveFile, e.getMessage()), (Throwable)e);
                failure = true;
            }
        }
        try {
            ArchiveUtils.recursiveUnpack(unpackTargetDir, new ArrayList<String>());
        }
        catch (Exception e) {
            LOG.warn("Exception during recursive unpack: {}", (Object)e.getMessage(), (Object)e);
            failure = true;
        }
        if (!failure) {
            FileUtils.deleteQuietly((File)marker);
        }
    }

    public static void tarDirectory(File directory, File targetTar) throws IOException {
        if (targetTar.exists()) {
            FileUtils.forceDelete((File)targetTar);
        }
        if (!targetTar.getParentFile().exists()) {
            targetTar.getParentFile().mkdirs();
        }
        try (TarOutputStream outputStream = new TarOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(targetTar.toPath(), new OpenOption[0])));){
            ArchiveUtils.tarDirectory(directory, outputStream, "");
        }
    }

    private static void tarDirectory(File directory, TarOutputStream outputStream, String parent) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                String entryName = parent + file.getName();
                if (file.isDirectory()) {
                    ArchiveUtils.tarDirectory(file, outputStream, entryName + "/");
                    continue;
                }
                ArchiveUtils.addFileToTar(outputStream, file, entryName);
            }
        }
    }

    private static void addFileToTar(TarOutputStream outputStream, File file, String entryName) throws IOException {
        outputStream.putNextEntry(new TarEntry(file, entryName));
        try (FileInputStream inputStream = new FileInputStream(file);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        outputStream.closeEntry();
    }

    static {
        org.metaeffekt.core.util.ArchiveUtils.registerZipExtension((String)"mbizip");
        org.metaeffekt.core.util.ArchiveUtils.registerZipExtension((String)"ez");
        peExtensions.add("dll");
        peExtensions.add("exe");
        peExtensions.add("cab");
        peExtensions.add("msi");
        peExtensions.add("pyd");
    }
}

