/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArgParser
implements Iterable<Argument> {
    private final Set<Argument> arguments = new HashSet<Argument>();
    private String prefix = null;
    private boolean prefixRequired = false;
    private boolean failOnDoubleArguments = true;

    public ArgParser setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ArgParser setPrefixRequired(boolean prefixRequired) {
        this.prefixRequired = prefixRequired;
        return this;
    }

    public ArgParser setFailOnDoubleArguments(boolean failOnDoubleArguments) {
        this.failOnDoubleArguments = failOnDoubleArguments;
        return this;
    }

    public ArgParser addArgument(Argument argument) {
        for (Argument checkArg : this.arguments) {
            for (String identifier : argument.identifiers) {
                if (!checkArg.identifiers.contains(identifier)) continue;
                return this;
            }
        }
        this.arguments.add(argument);
        return this;
    }

    public boolean removeArgument(Argument argument) {
        return this.arguments.remove(argument);
    }

    public boolean matches(String args) {
        try {
            this.parse(args);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean matches(String[] args) {
        try {
            this.parse(args);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Results parse(String[] args) {
        return this.parse(String.join((CharSequence)" ", args));
    }

    public Results parse(String args) {
        if (this.prefix != null && this.prefix.length() > 0) {
            if (this.prefixRequired && !args.matches("^" + this.prefix + ".*")) {
                throw new ArgParserException("Missing prefix '" + this.prefix + "' for input: " + args);
            }
            args = args.replaceAll("^" + this.prefix, "");
        }
        return this.parseInputStringArray(args.trim().split(" "));
    }

    private Results parseInputStringArray(String[] args) {
        ArrayList<Argument> remainingArguments = new ArrayList<Argument>(this.arguments);
        ArrayList<Result> results = new ArrayList<Result>();
        int currentArgumentIndex = 0;
        for (int i = 0; i < args.length && remainingArguments.size() > 0; ++i) {
            String parameter;
            int finalI = i;
            Argument currentArgument = remainingArguments.stream().filter(arg -> arg.containsIdentifier(args[finalI])).findFirst().orElse(null);
            if (currentArgument == null) continue;
            remainingArguments.remove(currentArgument);
            StringBuilder parameterBuilder = new StringBuilder();
            while (++i < args.length) {
                int finalI2 = i--;
                if (remainingArguments.stream().anyMatch(arg -> arg.containsIdentifier(args[finalI2]))) break;
                if (this.arguments.stream().filter(arg -> arg.containsIdentifier(args[finalI2])).findFirst().orElse(null) != null) {
                    if (this.failOnDoubleArguments) {
                        String highlighted = String.join((CharSequence)" ", args);
                        for (String identifier : currentArgument.identifiers) {
                            highlighted = ArgParser.highlightIdentifier(highlighted, identifier);
                        }
                        throw new ArgParserException("Argument appears twice in args string\n" + currentArgument + "\n" + highlighted);
                    }
                    --i;
                    break;
                }
                if (parameterBuilder.length() > 0) {
                    parameterBuilder.append(" ");
                }
                parameterBuilder.append(args[finalI2]);
            }
            if ((parameter = parameterBuilder.toString()).length() > 0) {
                if (!currentArgument.hasParameterCorrectType(parameter)) {
                    throw new ArgParserException("Argument parameter is of wrong type\n" + currentArgument + "\nGot: " + parameter + "\nExpected: " + currentArgument.parameterType.toString().toLowerCase());
                }
                if (!currentArgument.parameterIsInValidValues(parameter)) {
                    throw new ArgParserException("Argument parameter is not in allowed values set\n" + currentArgument + "\nGot: " + parameter + "\nExpected: " + String.join((CharSequence)",", currentArgument.validParameterValues));
                }
            } else {
                if (currentArgument.parameterRequired) {
                    throw new ArgParserException("Missing argument parameter\n" + currentArgument + "\nExpected: " + currentArgument.parameterType.toString().toLowerCase());
                }
                parameter = null;
            }
            if (parameter == null) {
                if (currentArgument.defaultParameterValue != null) {
                    results.add(new Result(currentArgument, currentArgumentIndex, currentArgument.defaultParameterValue));
                } else {
                    results.add(new Result(currentArgument, currentArgumentIndex, null));
                }
            } else {
                results.add(new Result(currentArgument, currentArgumentIndex, parameter));
            }
            ++currentArgumentIndex;
        }
        for (Argument currentArgument : remainingArguments) {
            if (!currentArgument.required) continue;
            throw new ArgParserException("Invalid argument syntax for '" + currentArgument + "' in '" + String.join((CharSequence)" ", args) + "'");
        }
        for (Argument currentArgument : remainingArguments) {
            if (currentArgument.defaultParameterValue == null) continue;
            results.add(new Result(currentArgument, currentArgumentIndex, currentArgument.defaultParameterValue));
            ++currentArgumentIndex;
        }
        return new Results(results);
    }

    public String commandSyntax() {
        List sortedArguments = this.arguments.stream().sorted().collect(Collectors.toList());
        StringBuilder syntax = new StringBuilder();
        if (this.prefix != null && this.prefix.length() > 0) {
            syntax.append(this.prefixRequired ? "" : "[").append(this.prefix).append(this.prefixRequired ? "" : "]");
        }
        for (Argument argument : sortedArguments) {
            syntax.append(syntax.length() == 0 ? "" : " ").append(argument);
        }
        return syntax.toString();
    }

    public String toString(boolean verbose) {
        StringBuilder header = new StringBuilder();
        if (this.prefix != null && this.prefix.length() > 0) {
            header.append(this.prefixRequired ? "" : "[").append(this.prefix).append(this.prefixRequired ? "" : "]");
        }
        List sortedArguments = this.arguments.stream().sorted().collect(Collectors.toList());
        for (Argument argument : sortedArguments) {
            header.append(" ").append(argument);
        }
        StringBuilder args = new StringBuilder();
        if (verbose) {
            for (Argument argument : sortedArguments) {
                if (argument.description == null || argument.description.length() <= 0) continue;
                if (args.length() > 0) {
                    args.append("\n");
                }
                args.append("  ").append(argument).append("\n");
                args.append("     ").append(argument.description);
            }
        }
        return header + (args.length() > 0 ? "\n" + args : "");
    }

    public String toString() {
        return this.toString(true);
    }

    public Stream<Argument> stream() {
        return this.arguments.stream();
    }

    @Override
    public Iterator<Argument> iterator() {
        return this.arguments.iterator();
    }

    private static String highlightIdentifier(String str, String highlight) {
        return str.replaceAll("(^| )" + highlight + "($| )", " --> " + highlight + " <-- ");
    }

    private static class ArgParserException
    extends IllegalArgumentException {
        public ArgParserException(String message) {
            super(message);
        }
    }

    public static class Argument
    implements Comparable<Argument> {
        private ParameterType parameterType = ParameterType.NONE;
        private String parameterName = null;
        private String defaultParameterValue = null;
        private final Set<String> validParameterValues = new HashSet<String>();
        private boolean parameterRequired = false;
        private boolean required = false;
        private final Set<String> identifiers = new HashSet<String>();
        private String description = null;

        public Argument setParameterType(ParameterType parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public Argument setParameterRequired(boolean parameterRequired) {
            this.parameterRequired = parameterRequired;
            return this;
        }

        public Argument setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Argument setDescription(String description) {
            this.description = description;
            return this;
        }

        public Argument setParameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public Argument setDefaultParameterValue(String defaultParameterValue) {
            this.defaultParameterValue = defaultParameterValue;
            return this;
        }

        public Argument setDefaultParameterValue(boolean defaultParameterValue) {
            this.defaultParameterValue = "" + defaultParameterValue;
            return this;
        }

        public Argument setDefaultParameterValue(double defaultParameterValue) {
            this.defaultParameterValue = "" + defaultParameterValue;
            return this;
        }

        public Argument setDefaultParameterValue(float defaultParameterValue) {
            this.defaultParameterValue = "" + defaultParameterValue;
            return this;
        }

        public Argument setDefaultParameterValue(int defaultParameterValue) {
            this.defaultParameterValue = "" + defaultParameterValue;
            return this;
        }

        public Argument setDefaultParameterValue(long defaultParameterValue) {
            this.defaultParameterValue = "" + defaultParameterValue;
            return this;
        }

        public Argument setDefaultParameterValue(String[] defaultParameterValue) {
            this.defaultParameterValue = String.join((CharSequence)" ", defaultParameterValue);
            return this;
        }

        public Argument addIdentifier(String ... identifier) {
            this.identifiers.addAll(Arrays.stream(identifier).collect(Collectors.toSet()));
            return this;
        }

        public Argument removeIdentifier(String identifier) {
            this.identifiers.remove(identifier);
            return this;
        }

        public Argument addValidParameterValue(String ... value) {
            this.validParameterValues.addAll(Arrays.stream(value).collect(Collectors.toSet()));
            return this;
        }

        public Argument addValidParameterValue(List<String> values) {
            this.validParameterValues.addAll(values);
            return this;
        }

        public Argument removeValidParameterValue(String value) {
            this.validParameterValues.remove(value);
            return this;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<String> getIdentifiers() {
            return this.identifiers;
        }

        public ParameterType getParameterType() {
            return this.parameterType;
        }

        public String getDefaultParameterValue() {
            return this.defaultParameterValue;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public boolean containsIdentifier(String identifier) {
            return this.identifiers.contains(identifier);
        }

        public boolean hasParameterCorrectType(String parameter) {
            switch (this.parameterType) {
                case STRING: 
                case STRING_ARRAY: 
                case ANY: {
                    return parameter != null;
                }
                case INTEGER: {
                    return parameter.matches("-?\\d{1,10}");
                }
                case LONG: {
                    return parameter.matches("-?\\d{1,19}");
                }
                case FLOAT: 
                case DOUBLE: {
                    return parameter.matches("-?[0-9]*\\.?[0-9]+");
                }
                case BOOLEAN: {
                    return parameter.toLowerCase().matches("(true|false|1|0)");
                }
            }
            return false;
        }

        public boolean parameterIsInValidValues(String parameter) {
            return this.validParameterValues.size() == 0 || this.validParameterValues.contains(parameter);
        }

        public String toString() {
            StringBuilder arg = new StringBuilder();
            arg.append(this.required ? "" : "[");
            arg.append(this.identifiers.stream().sorted().collect(Collectors.joining(",")));
            if (this.parameterType != ParameterType.NONE) {
                arg.append(this.parameterRequired ? " <" : " [");
                if (this.parameterName != null) {
                    arg.append(this.parameterName).append(":");
                }
                if (this.validParameterValues.size() > 0) {
                    arg.append(this.validParameterValues.stream().sorted().collect(Collectors.joining("|")));
                } else {
                    arg.append(this.parameterType.toString().toLowerCase());
                }
                arg.append(this.parameterRequired ? ">" : "]");
            }
            arg.append(this.required ? "" : "]");
            return arg.toString();
        }

        @Override
        public int compareTo(Argument o) {
            int required = Boolean.compare(o.required, this.required);
            if (required == 0 && this.identifiers.size() > 0 && o.identifiers.size() > 0) {
                return this.identifiers.stream().findAny().orElse("z").replace("-", "").compareTo(o.identifiers.stream().findAny().orElse("z").replace("-", ""));
            }
            return required;
        }

        public static enum ParameterType {
            STRING,
            STRING_ARRAY,
            INTEGER,
            LONG,
            FLOAT,
            DOUBLE,
            BOOLEAN,
            ANY,
            NONE;

        }
    }

    public static class Result {
        private final Argument argument;
        private final int index;
        private final String parameter;

        private Result(Argument argument, int index, String parameter) {
            this.argument = argument;
            this.index = index;
            this.parameter = parameter;
        }

        public Argument getArgument() {
            return this.argument;
        }

        public int getIndex() {
            return this.index;
        }

        public String getParameter() {
            return this.parameter;
        }

        public String getString() {
            return this.parameter;
        }

        public String[] getStringArray() {
            return this.parameter.split(" ");
        }

        public boolean getBoolean() {
            return this.parameter.toLowerCase().matches("(true|1)");
        }

        public float getFloat() {
            return Float.parseFloat(this.parameter);
        }

        public double getDouble() {
            return Double.parseDouble(this.parameter);
        }

        public long getLong() {
            return Long.parseLong(this.parameter);
        }

        public int getInt() {
            return Integer.parseInt(this.parameter);
        }
    }

    public static class Results
    implements Iterable<Result> {
        private final List<Result> results;

        public Results(List<Result> results) {
            this.results = results;
        }

        public List<Result> getResults() {
            return this.results;
        }

        public Result getResult(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().orElse(null);
        }

        public String getParameter(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getParameter).orElse(null);
        }

        public String get(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getParameter).orElse(null);
        }

        public int getIndex(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getIndex).orElse(-1);
        }

        public Argument getArgument(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getArgument).orElse(null);
        }

        public String getParameter(Argument argument) {
            return this.results.stream().filter(result -> ((Result)result).argument == argument).findFirst().map(Result::getParameter).orElse(null);
        }

        public int getIndex(Argument argument) {
            return this.results.stream().filter(result -> ((Result)result).argument == argument).findFirst().map(Result::getIndex).orElse(-1);
        }

        public boolean isPresent(String identifier) {
            return this.results.stream().anyMatch(result -> ((Result)result).argument.identifiers.contains(identifier));
        }

        public boolean isAbsent(String identifier) {
            return this.results.stream().noneMatch(result -> ((Result)result).argument.identifiers.contains(identifier));
        }

        public String getString(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getString).orElse(null);
        }

        public String[] getStringArray(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getStringArray).orElse(null);
        }

        public boolean getBoolean(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getBoolean).orElse(false);
        }

        public float getFloat(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getFloat).orElse(Float.valueOf(-1.0f)).floatValue();
        }

        public double getDouble(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getDouble).orElse(-1.0);
        }

        public long getLong(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getLong).orElse(-1L);
        }

        public int getInt(String identifier) {
            return this.results.stream().filter(result -> ((Result)result).argument.identifiers.contains(identifier)).findFirst().map(Result::getInt).orElse(-1);
        }

        public Stream<Result> stream() {
            return this.results.stream();
        }

        @Override
        public Iterator<Result> iterator() {
            return this.results.iterator();
        }
    }
}

