/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.Zip;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class FileUtils
extends org.metaeffekt.core.util.FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    public static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();

    public static final void deleteDir(File dir) {
        if (dir.exists()) {
            Delete delete = new Delete();
            Project project = new Project();
            project.setBaseDir(dir);
            delete.setProject(project);
            delete.setDir(dir);
            delete.execute();
        }
    }

    public static String[] scanDirectoryForFiles(File targetDir, boolean addDefaultExcludes, String ... includes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(targetDir);
        scanner.setIncludes(includes);
        scanner.setCaseSensitive(false);
        if (addDefaultExcludes) {
            scanner.addDefaultExcludes();
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static boolean compareFolders(File sourceDir, File targetDir) {
        FileUtils.validateExists((File)sourceDir);
        FileUtils.validateExists((File)targetDir);
        HashSet<String> sourceFileSet = FileUtils.fileToSet(sourceDir);
        HashSet<String> targetFileSet = FileUtils.fileToSet(targetDir);
        ArrayList<String> messages = new ArrayList<String>();
        for (String file : sourceFileSet) {
            if (targetFileSet.contains(file)) continue;
            messages.add(String.format("Target folder does not contain file %s", file));
        }
        for (String file : targetFileSet) {
            if (sourceFileSet.contains(file)) continue;
            messages.add(String.format("Source folder does not contain file %s", file));
        }
        for (String file : sourceFileSet) {
            String targetCS;
            String sourceCS = FileUtils.computeChecksum((File)new File(sourceDir, file));
            if (sourceCS.equals(targetCS = FileUtils.computeChecksum((File)new File(targetDir, file)))) continue;
            messages.add(String.format("Content of file %s differs.", file));
        }
        for (String message : messages) {
            LOG.info(message);
        }
        return !messages.isEmpty();
    }

    public static HashSet<String> fileToSet(File dir) {
        String[] files = FileUtils.scanDirectoryForFiles(dir, true, "**/*");
        HashSet<String> fileSet = new HashSet<String>();
        for (String file : files) {
            fileSet.add(file);
        }
        return fileSet;
    }

    public static void zipAnt(File sourceDir, File targetZipFile) {
        Zip zip = new Zip();
        Project project = new Project();
        project.setBaseDir(sourceDir);
        zip.setProject(project);
        zip.setBasedir(sourceDir);
        zip.setCompress(true);
        zip.setDestFile(targetZipFile);
        zip.setFollowSymlinks(false);
        zip.execute();
    }

    public static void gzip(File sourceDir, File targetZipFile) throws IOException {
        Tar zip = new Tar();
        Project project = new Project();
        project.setBaseDir(sourceDir);
        zip.setBasedir(sourceDir);
        zip.setProject(project);
        zip.setDestFile(targetZipFile);
        zip.setDescription("");
        zip.execute();
    }

    public static boolean matches(String absolutePath, String[] patterns) {
        for (String pattern : patterns) {
            pattern = pattern.trim();
            pattern = "/" + pattern;
            if (!ANT_PATH_MATCHER.match(pattern, absolutePath)) continue;
            return true;
        }
        return false;
    }

    public static File findSingleFile(File baseFile, String pattern) {
        String[] files = FileUtils.scanDirectoryForFiles((File)baseFile, (String[])new String[]{pattern});
        if (files.length == 1) {
            return new File(baseFile, files[0]);
        }
        return null;
    }

    public static File findSingleDir(File baseFile, String pattern) {
        String[] dirs = FileUtils.scanDirectoryForFolders((File)baseFile, (String[])new String[]{pattern});
        if (dirs.length == 1) {
            return new File(baseFile, dirs[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeContentChecksum(File file, File tmpFolder) throws IOException {
        File contentChecksumFile = new File(tmpFolder, file.getName() + ".content.md5");
        FileUtils.createDirectoryContentChecksumFile((File)file, (File)contentChecksumFile);
        try {
            String string = FileUtils.computeChecksum((File)contentChecksumFile);
            return string;
        }
        finally {
            FileUtils.deleteQuietly((File)contentChecksumFile);
        }
    }

    public static void forceMkDirQuietly(File file) {
        try {
            FileUtils.forceMkdir((File)file);
        }
        catch (IOException exception) {
            throw new IllegalStateException("Cannot create folder [" + file + "].");
        }
    }

    public static boolean exists(String filePath) {
        if (filePath == null) {
            return false;
        }
        return new File(filePath).exists();
    }

    public static String detectEncoding(File file) throws IOException {
        String encoding = UniversalDetector.detectCharset((File)file);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }
}

