/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;

public class InventoryDiffMerger {
    private final Inventory referenceInventory;
    private final Inventory specificInventory;
    private Inventory mergedInventory;
    private Map<String, MergeFunction> compareAttributes = new HashMap<String, MergeFunction>();
    public static final MergeFunction CSV_MERGER = (referenceValue, specificValue) -> {
        LinkedHashSet mergedValues = new LinkedHashSet();
        mergedValues.addAll(Arrays.stream(referenceValue.split(", ")).collect(Collectors.toList()));
        mergedValues.addAll(Arrays.stream(specificValue.split(", ")).collect(Collectors.toList()));
        return String.join((CharSequence)", ", mergedValues);
    };

    public InventoryDiffMerger(Inventory referenceInventory, Inventory specificInventory) {
        this.referenceInventory = referenceInventory;
        this.specificInventory = specificInventory;
    }

    public Inventory getReferenceInventory() {
        return this.referenceInventory;
    }

    public Inventory getSpecificInventory() {
        return this.specificInventory;
    }

    public Inventory getMergedInventory() {
        return this.mergedInventory;
    }

    public void addCompareAttribute(String attribute, MergeFunction mergeFunction) {
        this.compareAttributes.put(attribute, mergeFunction);
    }

    public void addMergeByCsvAttribute(String attribute) {
        this.addCompareAttribute(attribute, CSV_MERGER);
    }

    public void loadVulnerabilityDataCompareAttributes() {
        this.addMergeByCsvAttribute(InventoryAttribute.ADDITIONAL_CPE.getKey());
        this.addMergeByCsvAttribute(InventoryAttribute.INAPPLICABLE_CPE.getKey());
        this.addMergeByCsvAttribute(InventoryAttribute.INITIAL_CPE_URIS.getKey());
        this.addMergeByCsvAttribute(InventoryAttribute.CVE_INDICATION.getKey());
        this.addMergeByCsvAttribute(InventoryAttribute.INAPPLICABLE_CVE.getKey());
        this.addMergeByCsvAttribute(InventoryAttribute.MS_PRODUCT_ID.getKey());
    }

    public Inventory merge(boolean addArtifactsFromSpecificInventory) {
        this.mergedInventory = new Inventory();
        if (this.referenceInventory == null || this.specificInventory == null) {
            return this.mergedInventory;
        }
        List<Difference> differences = this.findDifferences(addArtifactsFromSpecificInventory);
        List mergedArtifacts = this.mergedInventory.getArtifacts();
        HashSet<Artifact> knownArtifacts = new HashSet<Artifact>();
        for (Difference difference : differences) {
            Artifact mergedArtifact;
            if (difference.artifactReference != null) {
                knownArtifacts.add(difference.artifactReference);
            }
            if (difference.artifactSpecific != null && addArtifactsFromSpecificInventory) {
                knownArtifacts.add(difference.artifactSpecific);
            }
            if (difference.type == DifferenceType.SPECIFIC_ARTIFACT_DOES_NOT_EXIST && difference.artifactReference != null) {
                mergedArtifact = new Artifact(difference.artifactReference);
                mergedArtifacts.add(mergedArtifact);
                continue;
            }
            if (addArtifactsFromSpecificInventory && difference.type == DifferenceType.REFERENCE_ARTIFACT_DOES_NOT_EXIST && difference.artifactSpecific != null) {
                mergedArtifact = new Artifact(difference.artifactSpecific);
                mergedArtifacts.add(mergedArtifact);
                continue;
            }
            if (difference.type == DifferenceType.REFERENCE_ATTRIBUTE_DOES_NOT_EXIST && difference.artifactSpecific != null) {
                mergedArtifact = this.findOrCreateNew(difference.artifactReference, this.mergedInventory);
                mergedArtifact.set(difference.attribute, difference.artifactSpecific.get(difference.attribute));
                this.addIfNotContained(mergedArtifact, mergedArtifacts);
                continue;
            }
            if (difference.type == DifferenceType.SPECIFIC_ATTRIBUTE_DOES_NOT_EXIST || difference.type == DifferenceType.EQUAL) {
                mergedArtifact = this.findOrCreateNew(difference.artifactReference, this.mergedInventory);
                this.addIfNotContained(mergedArtifact, mergedArtifacts);
                continue;
            }
            if (difference.type != DifferenceType.NOT_EQUAL) continue;
            String referenceValue = difference.artifactReference.get(difference.attribute);
            String specificValue = difference.artifactSpecific.get(difference.attribute);
            String mergedValue = this.compareAttributes.getOrDefault(difference.attribute, CSV_MERGER).merge(referenceValue, specificValue);
            Artifact mergedArtifact2 = this.findOrCreateNew(difference.artifactReference, this.mergedInventory);
            mergedArtifact2.set(difference.attribute, mergedValue);
            this.addIfNotContained(mergedArtifact2, mergedArtifacts);
        }
        knownArtifacts.addAll(mergedArtifacts);
        HashSet checkArtifacts = new HashSet(this.referenceInventory.getArtifacts());
        if (addArtifactsFromSpecificInventory) {
            checkArtifacts.addAll(this.specificInventory.getArtifacts());
        }
        for (Artifact checkArtifact : checkArtifacts) {
            if (knownArtifacts.contains(checkArtifact)) continue;
            mergedArtifacts.add(checkArtifact);
        }
        return this.mergedInventory;
    }

    private Artifact findOrCreateNew(Artifact reference, Inventory inventory) {
        if (inventory.getArtifacts().contains(reference)) {
            return reference;
        }
        Artifact checkArtifact = this.findArtifact(reference, inventory);
        if (checkArtifact != null) {
            return checkArtifact;
        }
        return new Artifact(reference);
    }

    private Artifact findArtifact(Artifact artifact, Inventory inventory) {
        Artifact foundArtifact = this.findArtifactByIdChecksumVersion(inventory, artifact);
        return foundArtifact;
    }

    private Artifact findArtifactByIdChecksumVersion(Inventory inventory, Artifact checkArtifact) {
        for (Artifact candidate : inventory.getArtifacts()) {
            boolean idEquals = this.attributeEquals(checkArtifact, candidate, Artifact.Attribute.ID.getKey());
            boolean checksumEquals = this.attributeEquals(checkArtifact, candidate, Artifact.Attribute.CHECKSUM.getKey());
            boolean versionEquals = this.attributeEquals(checkArtifact, candidate, Artifact.Attribute.VERSION.getKey());
            if (!idEquals || !checksumEquals || !versionEquals) continue;
            return candidate;
        }
        return null;
    }

    private boolean attributeEquals(Artifact a1, Artifact a2, String attribute) {
        return a1.get(attribute) == null && a2.get(attribute) == null || a1.get(attribute) != null && a2.get(attribute) != null && a1.get(attribute).equals(a2.get(attribute));
    }

    private void addIfNotContained(Artifact reference, List<Artifact> artifacts) {
        if (!artifacts.contains(reference)) {
            artifacts.add(reference);
        }
    }

    public List<Difference> findDifferences() {
        return this.findDifferences(true);
    }

    public List<Difference> findDifferences(boolean addArtifactsFromSpecificInventory) {
        ArrayList<Artifact> knownMergedArtifacts = new ArrayList<Artifact>();
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (addArtifactsFromSpecificInventory) {
            for (Artifact specificArtifact : this.specificInventory.getArtifacts()) {
                Artifact referenceArtifact = this.findArtifact(specificArtifact, this.referenceInventory);
                differences.addAll(this.findDifferences(referenceArtifact, specificArtifact));
                knownMergedArtifacts.add(specificArtifact);
                knownMergedArtifacts.add(referenceArtifact);
            }
        }
        for (Artifact referenceArtifact : this.referenceInventory.getArtifacts()) {
            if (knownMergedArtifacts.contains(referenceArtifact)) continue;
            Artifact specificArtifact = this.findArtifact(referenceArtifact, this.specificInventory);
            differences.addAll(this.findDifferences(referenceArtifact, specificArtifact));
            knownMergedArtifacts.add(specificArtifact);
            knownMergedArtifacts.add(referenceArtifact);
        }
        return differences;
    }

    private List<Difference> findDifferences(Artifact referenceArtifact, Artifact specificArtifact) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (referenceArtifact == null && specificArtifact == null) {
            return differences;
        }
        if (referenceArtifact == null) {
            differences.add(new Difference(DifferenceType.REFERENCE_ARTIFACT_DOES_NOT_EXIST, null, null, specificArtifact));
            return differences;
        }
        if (specificArtifact == null) {
            differences.add(new Difference(DifferenceType.SPECIFIC_ARTIFACT_DOES_NOT_EXIST, null, referenceArtifact, null));
            return differences;
        }
        for (String attribute : this.compareAttributes.keySet()) {
            String referenceValue = referenceArtifact.get(attribute);
            String specificValue = specificArtifact.get(attribute);
            if (referenceValue == null && specificValue == null) {
                differences.add(new Difference(DifferenceType.EQUAL, attribute, referenceArtifact, specificArtifact));
                continue;
            }
            if (referenceValue == null) {
                differences.add(new Difference(DifferenceType.SPECIFIC_ATTRIBUTE_DOES_NOT_EXIST, attribute, referenceArtifact, specificArtifact));
                continue;
            }
            if (specificValue == null) {
                differences.add(new Difference(DifferenceType.REFERENCE_ATTRIBUTE_DOES_NOT_EXIST, attribute, referenceArtifact, specificArtifact));
                continue;
            }
            if (specificValue.equals(referenceValue)) {
                differences.add(new Difference(DifferenceType.EQUAL, attribute, referenceArtifact, specificArtifact));
                continue;
            }
            differences.add(new Difference(DifferenceType.NOT_EQUAL, attribute, referenceArtifact, specificArtifact));
        }
        return differences;
    }

    public JSONArray differencesToJson(List<Difference> differences) {
        JSONArray differenceJson = new JSONArray();
        differences.stream().filter(Objects::nonNull).filter(d -> ((Difference)d).type != DifferenceType.EQUAL).map(Difference::toJson).forEach(arg_0 -> ((JSONArray)differenceJson).put(arg_0));
        return differenceJson;
    }

    public static interface MergeFunction {
        public String merge(String var1, String var2);
    }

    public static enum DifferenceType {
        REFERENCE_ARTIFACT_DOES_NOT_EXIST,
        SPECIFIC_ARTIFACT_DOES_NOT_EXIST,
        REFERENCE_ATTRIBUTE_DOES_NOT_EXIST,
        SPECIFIC_ATTRIBUTE_DOES_NOT_EXIST,
        EQUAL,
        NOT_EQUAL;

    }

    private static class Difference {
        private final DifferenceType type;
        private final String attribute;
        private final Artifact artifactReference;
        private final Artifact artifactSpecific;

        public Difference(DifferenceType type, String attribute, Artifact artifactReference, Artifact artifactSpecific) {
            this.type = type;
            this.attribute = attribute;
            this.artifactReference = artifactReference;
            this.artifactSpecific = artifactSpecific;
        }

        public DifferenceType getType() {
            return this.type;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Artifact getArtifactReference() {
            return this.artifactReference;
        }

        public Artifact getArtifactSpecific() {
            return this.artifactSpecific;
        }

        public JSONObject toJson() {
            JSONObject json = new JSONObject();
            json.put("type", (Object)this.type.name());
            json.put("attribute", (Object)this.attribute);
            if (this.artifactReference != null) {
                json.put("referenceId", (Object)this.artifactReference.getId());
                json.put("referenceChecksum", (Object)this.artifactReference.getChecksum());
            }
            if (this.artifactSpecific != null) {
                json.put("specificId", (Object)this.artifactSpecific.getId());
                json.put("specificChecksum", (Object)this.artifactSpecific.getChecksum());
            }
            return json;
        }

        public String toString() {
            return "Difference{type='" + this.type.name() + '\'' + ", attribute='" + this.attribute + '\'' + ", artifactReference=" + (this.artifactReference == null ? null : this.artifactReference.getId()) + ", artifactSpecific=" + (this.artifactSpecific == null ? null : this.artifactSpecific.getId()) + '}';
        }
    }
}

