/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.LicenseData;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class InventoryMergeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryMergeUtils.class);
    protected boolean addDefaultArtifactExcludedAttributes = true;
    protected Set<String> artifactExcludedAttributes = new HashSet<String>();
    protected boolean addDefaultArtifactMergeAttributes = true;
    protected Set<String> artifactMergeAttributes = new HashSet<String>();

    public void merge(List<File> sourceInventories, Inventory targetInventory) throws IOException {
        for (File sourceInventoryFile : sourceInventories) {
            Inventory sourceInventory = new InventoryReader().readInventory(sourceInventoryFile);
            this.mergeArtifacts(sourceInventory, targetInventory);
            InventoryMergeUtils.mergeAssetMetaData(sourceInventory, targetInventory);
            this.mergeLicenseData(sourceInventory, targetInventory);
        }
    }

    private void mergeArtifacts(Inventory sourceInv, Inventory targetInv) {
        for (Artifact artifact : targetInv.getArtifacts()) {
            if (StringUtils.isNotBlank((CharSequence)artifact.getChecksum())) continue;
            List candidates = sourceInv.findAllWithId(artifact.getId());
            ArrayList<Artifact> matches = new ArrayList<Artifact>();
            for (Artifact artifact2 : candidates) {
                if (!this.matchesProjects(artifact, artifact2)) continue;
                matches.add(artifact2);
            }
            for (Artifact artifact3 : matches) {
                artifact.setChecksum(artifact3.getChecksum());
            }
        }
        for (Artifact artifact : sourceInv.getArtifacts()) {
            Artifact candidate = targetInv.findArtifactByIdAndChecksum(artifact.getId(), artifact.getChecksum());
            if (candidate != null) continue;
            targetInv.getArtifacts().add(artifact);
        }
        HashSet<Artifact> toBeDeleted = new HashSet<Artifact>();
        HashMap<String, Artifact> representationArtifactMap = new HashMap<String, Artifact>();
        HashSet attributes = new HashSet();
        HashSet<String> excludedAttributes = new HashSet<String>(this.artifactExcludedAttributes);
        if (this.addDefaultArtifactExcludedAttributes) {
            excludedAttributes.add("Verified");
            excludedAttributes.add("Archive Path");
            excludedAttributes.add("Latest Version");
            excludedAttributes.add("Security Relevance");
            excludedAttributes.add("Security Category");
            excludedAttributes.add("WILDCARD-MATCH");
        }
        HashSet<String> mergeAttributes = new HashSet<String>(this.artifactMergeAttributes);
        if (this.addDefaultArtifactMergeAttributes) {
            mergeAttributes.add(Artifact.Attribute.ROOT_PATHS.getKey());
            mergeAttributes.add("Source Project");
        }
        for (Artifact artifact : targetInv.getArtifacts()) {
            for (String attribute : excludedAttributes) {
                artifact.set(attribute, null);
            }
            attributes.addAll(artifact.getAttributes());
        }
        attributes.removeAll(mergeAttributes);
        ArrayList arrayList = new ArrayList(attributes);
        arrayList.sort(String::compareToIgnoreCase);
        for (Artifact artifact : targetInv.getArtifacts()) {
            StringBuilder stringRepresentation = new StringBuilder();
            for (String attribute : attributes) {
                if (stringRepresentation.length() == 0) {
                    stringRepresentation.append(";");
                }
                stringRepresentation.append(attribute).append("=").append(artifact.get(attribute));
            }
            String rep = stringRepresentation.toString();
            if (representationArtifactMap.containsKey(rep)) {
                toBeDeleted.add(artifact);
                Artifact retainedArtifact = (Artifact)representationArtifactMap.get(rep);
                for (String key : mergeAttributes) {
                    retainedArtifact.append(key, artifact.get(key), ", ");
                }
                continue;
            }
            representationArtifactMap.put(rep, artifact);
        }
        targetInv.getArtifacts().removeAll(toBeDeleted);
    }

    private static void mergeAssetMetaData(Inventory sourceInv, Inventory targetInv) {
        targetInv.getAssetMetaData().addAll(sourceInv.getAssetMetaData());
    }

    private void mergeLicenseData(Inventory sourceInv, Inventory targetInv) {
        HashMap<String, LicenseData> canonicalNameLicenseDataMap = new HashMap<String, LicenseData>();
        for (LicenseData licenseData : targetInv.getLicenseData()) {
            canonicalNameLicenseDataMap.put(licenseData.get(LicenseData.Attribute.CANONICAL_NAME), licenseData);
        }
        for (LicenseData sourceLicenseData : sourceInv.getLicenseData()) {
            String canonicalName = sourceLicenseData.get(LicenseData.Attribute.CANONICAL_NAME);
            LicenseData targetLicenseData = (LicenseData)canonicalNameLicenseDataMap.get(canonicalName);
            if (targetLicenseData != null) {
                targetLicenseData.merge(sourceLicenseData);
                continue;
            }
            targetInv.getLicenseData().add(sourceLicenseData);
            canonicalNameLicenseDataMap.put(canonicalName, sourceLicenseData);
        }
    }

    private boolean matchesProjects(Artifact artifact, Artifact candidate) {
        for (String location : artifact.getRootPaths()) {
            for (String candidateLocation : candidate.getRootPaths()) {
                if (!candidateLocation.contains(location)) continue;
                return true;
            }
        }
        return false;
    }
}

