/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class StringUtils {
    public static final String EMPTY_STRING = "";

    protected StringUtils() {
    }

    public static String replace(String string, Map<String, String> parameter) {
        for (Map.Entry<String, String> entry : parameter.entrySet()) {
            string = string.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return string;
    }

    public static void compare(String license, String referenceLicense) {
        String referenceLic;
        String lic = license.trim();
        if (!lic.equals(referenceLic = referenceLicense.trim())) {
            throw new IllegalArgumentException("Licenses differ.");
        }
    }

    public static List<String> stringToLines(String string) {
        string = string.replace("\n", "***");
        string = string.replace("\r", "***");
        string = string.replace("******", "***");
        return Arrays.asList(string.split("\\*\\*\\*"));
    }

    public static List<String> compareStrings(String lhs, String rhs) {
        ArrayList<String> diff = new ArrayList<String>();
        Patch patch = DiffUtils.diff(StringUtils.stringToLines(lhs), StringUtils.stringToLines(rhs));
        for (Delta delta : patch.getDeltas()) {
            for (String line : delta.getRevised().getLines()) {
                diff.add(line);
            }
        }
        return diff;
    }

    public static boolean isEmpty(String string) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)string);
    }

    public static boolean notEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static String notNull(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return string;
    }

    public static String nonNull(String ... strings) {
        if (strings == null) {
            return null;
        }
        for (String object : strings) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static String toString(List<String> list) {
        return list.stream().collect(Collectors.joining(", "));
    }

    public static List<String> split(String s, int maxSize) {
        ArrayList<String> split = new ArrayList<String>();
        String rest = s;
        while (s.length() > maxSize) {
            rest = s.substring(maxSize);
            s = s.substring(0, maxSize);
            split.add(s);
            s = rest;
        }
        split.add(rest);
        return split;
    }

    public static String normalize(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\s+", " ").toLowerCase().trim();
    }

    public static String stripArrayBoundaries(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("[")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.endsWith("[")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public static boolean hasText(String s) {
        return StringUtils.notEmpty(s);
    }

    public static Set<String> splitToSet(String string, String delimiter) {
        return StringUtils.splitToSet(string, delimiter, true);
    }

    public static Set<String> splitToSet(String string, String delimiter, boolean trim) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Delimiter must not be null.");
        }
        if (StringUtils.notEmpty(string)) {
            String[] split = string.split(delimiter);
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (String item : split) {
                if (trim) {
                    set.add(item.trim());
                    continue;
                }
                set.add(item);
            }
            return Collections.unmodifiableSet(set);
        }
        return Collections.emptySet();
    }

    public static void addNonEmptyString(String value, Collection<String> copyrights) {
        if (StringUtils.notEmpty(value)) {
            copyrights.add(value);
        }
    }

    public static boolean equals(String lhs, String rhs) {
        if (!StringUtils.hasText(lhs) && !StringUtils.hasText(rhs)) {
            return true;
        }
        if (StringUtils.hasText(lhs)) {
            return lhs.equals(rhs);
        }
        return rhs.equals(lhs);
    }

    public static boolean containsIgnoreCase(CharSequence seq, CharSequence searchSeq) {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)seq, (CharSequence)searchSeq);
    }
}

