/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public abstract class TimeUtils {
    public static final DateTimeFormatter HUMAN_READABLE_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd@HH'h'mm'm'ss's'");
    private static final List<SimpleDateFormat> DATE_FORMATS = Arrays.asList(TimeUtils.nonLenientUtcSimpleDateFormat("yyyy-MM-dd HH:mm:ss"), TimeUtils.createUtcSimpleDateFormat("dd MMMMM yyyy", Locale.GERMAN), TimeUtils.createUtcSimpleDateFormat("dd MMMMM yyyy", Locale.FRANCE), TimeUtils.createUtcSimpleDateFormat("dd MMMMM yyyy", Locale.ENGLISH), TimeUtils.nonLenientUtcSimpleDateFormat("dd MMMMM yyyy"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy-MM-dd'T'HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy-MM-dd HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("dd-MM-yyyy'T'HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("dd-MM-yyyy'T'HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("dd-MM-yyyy HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("dd-MM-yyyy HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("MM-dd-yyyy'T'HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("MM-dd-yyyy'T'HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("MM-dd-yyyy HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("MM-dd-yyyy HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("MM/dd/yyyy'T'HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("MM/dd/yyyy'T'HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("MM/dd/yyyy HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("MM/dd/yyyy HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("dd/MM/yyyy'T'HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("dd/MM/yyyy'T'HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("dd/MM/yyyy HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("dd/MM/yyyy HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy/MM/dd'T'HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy/MM/dd HH:mm:ss"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy/MM/dd HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy-MM-dd"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy-MM"), TimeUtils.nonLenientUtcSimpleDateFormat("dd-MM-yyyy"), TimeUtils.nonLenientUtcSimpleDateFormat("MM-dd-yyyy"), TimeUtils.nonLenientUtcSimpleDateFormat("MM/dd/yyyy"), TimeUtils.nonLenientUtcSimpleDateFormat("dd/MM/yyyy"), TimeUtils.createUtcSimpleDateFormat("yyyy/MM/dd"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy.MM.dd"), TimeUtils.nonLenientUtcSimpleDateFormat("dd.MM.yyyy"), TimeUtils.nonLenientUtcSimpleDateFormat("MM.dd.yyyy"), TimeUtils.createUtcSimpleDateFormat("dd.MM.yyyy'T'HH:mm:ss"), TimeUtils.createUtcSimpleDateFormat("dd.MM.yyyy'T'HH:mm"), TimeUtils.createUtcSimpleDateFormat("dd.MM.yyyy HH:mm:ss"), TimeUtils.createUtcSimpleDateFormat("dd.MM.yyyy HH:mm"), TimeUtils.nonLenientUtcSimpleDateFormat("yyyy"));
    private static final List<SimpleDateFormat> FORMATS_WITH_T = new ArrayList<SimpleDateFormat>();
    private static final List<SimpleDateFormat> FORMATS_WITH_SLASH = new ArrayList<SimpleDateFormat>();
    private static final List<SimpleDateFormat> FORMATS_WITH_DASH = new ArrayList<SimpleDateFormat>();
    private static final List<SimpleDateFormat> FORMATS_TEXT = new ArrayList<SimpleDateFormat>();
    private static final List<SimpleDateFormat> FORMATS_GENERIC = new ArrayList<SimpleDateFormat>();
    private static final SimpleDateFormat NORMALIZED_DATE_PATTERN;

    public static long parseHumanFormatTime(String time) {
        if (time == null) {
            return -1L;
        }
        if (time.isEmpty() || time.equals("now")) {
            return TimeUtils.utcNow();
        }
        String[] parts = time.replace("ago", "").replace("last", "").split("(,|and)");
        long value = 0L;
        boolean hadValidPart = false;
        for (String part : parts) {
            long l;
            String[] split = part.trim().split(" ");
            if (split.length == 2) {
                l = TimeUtils.parseHumanFormatTime(split[0], split[1]);
                if (l <= 0L) continue;
                value += l;
                hadValidPart = true;
                continue;
            }
            if (split.length != 1 || (l = TimeUtils.parseHumanFormatTime("1", split[0])) <= 0L) continue;
            value += l;
            hadValidPart = true;
        }
        if (!hadValidPart) {
            return -1L;
        }
        return value;
    }

    private static long parseHumanFormatTime(String time, String unit) {
        if ((time = time.replaceAll("[^0-9]", "")).isEmpty()) {
            return -1L;
        }
        int parsedTime = Integer.parseInt(time);
        if (unit.contains("year")) {
            return (long)parsedTime * 365L * 24L * 60L * 60L * 1000L;
        }
        if (unit.contains("month")) {
            return (long)parsedTime * 30L * 24L * 60L * 60L * 1000L;
        }
        if (unit.contains("week")) {
            return (long)parsedTime * 7L * 24L * 60L * 60L * 1000L;
        }
        if (unit.contains("day")) {
            return (long)parsedTime * 24L * 60L * 60L * 1000L;
        }
        if (unit.contains("hour")) {
            return (long)parsedTime * 60L * 60L * 1000L;
        }
        if (unit.contains("minute")) {
            return (long)parsedTime * 60L * 1000L;
        }
        if (unit.contains("second")) {
            return (long)parsedTime * 1000L;
        }
        return -1L;
    }

    public static long parseTimeFromInput(String input) {
        if (input == null) {
            return 0L;
        }
        if (input.matches("[0-9]+")) {
            return Long.parseLong(input);
        }
        if (input.equals("now")) {
            return TimeUtils.utcNow();
        }
        long humanTime = TimeUtils.parseHumanFormatTime(input);
        if (humanTime != -1L) {
            return TimeUtils.utcNow() - humanTime;
        }
        return TimeUtils.timestampFromNormalizedDate(TimeUtils.normalizeDate(input));
    }

    public static long timestampFromNormalizedDate(String date) {
        String timePart;
        if (!date.contains("-")) {
            return 0L;
        }
        String[] dateTimeParts = date.split("[T ]");
        String datePart = dateTimeParts[0];
        String string = timePart = dateTimeParts.length > 1 ? dateTimeParts[1] : "00:00:00";
        if (datePart.contains(" ")) {
            datePart = datePart.substring(0, datePart.indexOf(" "));
        }
        String[] dateParts = datePart.split("-");
        String[] timeParts = timePart.split(":");
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(Integer.parseInt(dateParts[0]), Integer.parseInt(dateParts[1]) - 1, Integer.parseInt(dateParts[2]), Integer.parseInt(timeParts[0]), Integer.parseInt(timeParts[1]), Integer.parseInt(timeParts[2]));
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    private static void sortFormatsByPriority(List<SimpleDateFormat> formats) {
        formats.sort((a, b) -> Integer.compare(b.toPattern().length(), a.toPattern().length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date tryParse(String dateString) {
        if (dateString == null) {
            return null;
        }
        if (dateString.matches("\\d{5,}")) {
            return new Date(Long.parseLong(dateString));
        }
        ArrayList<SimpleDateFormat> candidates = new ArrayList<SimpleDateFormat>(8);
        if (dateString.contains("T")) {
            candidates.addAll(FORMATS_WITH_T);
        } else if (dateString.contains("/")) {
            candidates.addAll(FORMATS_WITH_SLASH);
        } else if (dateString.contains("-")) {
            candidates.addAll(FORMATS_WITH_DASH);
        } else if (dateString.matches(".*[a-zA-Z].*")) {
            candidates.addAll(FORMATS_TEXT);
        } else {
            candidates.addAll(FORMATS_GENERIC);
        }
        List<SimpleDateFormat> list = DATE_FORMATS;
        synchronized (list) {
            for (SimpleDateFormat formatter : candidates) {
                try {
                    return formatter.parse(dateString);
                }
                catch (ParseException parseException) {
                }
            }
        }
        return null;
    }

    private static SimpleDateFormat nonLenientSimpleDateFormat(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        return sdf;
    }

    public static String normalizeDate(String string) {
        if (string == null) {
            return "n.a.";
        }
        Date parsedDate = TimeUtils.tryParse(string);
        if (parsedDate != null) {
            return TimeUtils.formatNormalizedDate(parsedDate);
        }
        if (string.contains("T")) {
            return string.substring(0, string.indexOf("T"));
        }
        return string;
    }

    public static String formatNormalizedDate(Date date) {
        if (date == null) {
            return "n.a.";
        }
        return NORMALIZED_DATE_PATTERN.format(date).replace(" 00:00:00", "").replaceAll(":00$", "");
    }

    public static String formatTimeDiff(long diff) {
        if (diff < 1000L) {
            return diff + "ms";
        }
        if (diff < 60000L) {
            long s = diff / 1000L;
            long ms = diff % 1000L;
            return s + "s" + (ms == 0L ? "" : " " + ms + "ms");
        }
        if (diff < 3600000L) {
            long m = diff / 1000L / 60L;
            long s = diff / 1000L % 60L;
            return m + "m" + (s == 0L ? "" : " " + s + "s");
        }
        if (diff < 86400000L) {
            long h = diff / 1000L / 60L / 60L;
            long m = diff / 1000L / 60L % 60L;
            return h + "h" + (m == 0L ? "" : " " + m + "m");
        }
        long d = diff / 1000L / 60L / 60L / 24L;
        long h = diff / 1000L / 60L / 60L % 24L;
        return d + "d" + (h == 0L ? "" : " " + h + "h");
    }

    public static Date tryParse(Object date) {
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date instanceof Number) {
            return new Date(((Number)date).longValue());
        }
        if (date instanceof String) {
            return TimeUtils.tryParse((String)date);
        }
        return null;
    }

    public static long utcNow() {
        return Instant.now().toEpochMilli();
    }

    public static String formatTimeUntilOrAgoDefault(long timeUntil) {
        return TimeUtils.formatTimeUntilOrAgo(timeUntil, "", "in", "ago", "", " and ", "no date provided");
    }

    public static String formatTimeNoSuffixPrefix(long timeUntil) {
        return TimeUtils.formatTimeUntilOrAgo(timeUntil, "", "", "", "", " and ", "no date provided");
    }

    public static String formatTimeUntilOrAgo(long timeUntil, String prefixBefore, String prefixAfter, String suffixBefore, String suffixAfter, String joinWord, String neverWord) {
        String prefixUsed = timeUntil < 0L ? prefixBefore : prefixAfter;
        String suffixUsed = timeUntil < 0L ? suffixBefore : suffixAfter;
        prefixUsed = prefixUsed.isEmpty() ? "" : prefixUsed + " ";
        suffixUsed = suffixUsed.isEmpty() ? "" : " " + suffixUsed;
        long absTime = Math.abs(timeUntil);
        if (timeUntil == Long.MAX_VALUE) {
            return neverWord;
        }
        if (absTime < 10000L) {
            return "now";
        }
        String format = prefixUsed + "%d %s" + joinWord + "%d %s" + suffixUsed;
        String formatZero = prefixUsed + "%d %s" + suffixUsed;
        long years = absTime / 31536000000L;
        long months = absTime / 2592000000L;
        long weeks = absTime / 604800000L;
        long days = absTime / 86400000L;
        long hours = absTime / 3600000L;
        long minutes = absTime / 60000L;
        long seconds = absTime / 1000L;
        if (years > 0L) {
            return months % 12L == 0L ? String.format(formatZero, years, years > 1L ? "years" : "year") : String.format(format, years, years > 1L ? "years" : "year", months % 12L, months % 12L == 1L ? "month" : "months");
        }
        if (months > 0L) {
            return weeks % 4L == 0L ? String.format(formatZero, months, months > 1L ? "months" : "month") : String.format(format, months, months > 1L ? "months" : "month", weeks % 4L, weeks % 4L == 1L ? "week" : "weeks");
        }
        if (weeks > 0L) {
            return days % 7L == 0L ? String.format(formatZero, weeks, weeks > 1L ? "weeks" : "week") : String.format(format, weeks, weeks > 1L ? "weeks" : "week", days % 7L, days % 7L == 1L ? "day" : "days");
        }
        if (days > 0L) {
            return hours % 24L == 0L ? String.format(formatZero, days, days > 1L ? "days" : "day") : String.format(format, days, days > 1L ? "days" : "day", hours % 24L, hours % 24L == 1L ? "hour" : "hours");
        }
        if (hours > 0L) {
            return minutes % 60L == 0L ? String.format(formatZero, hours, hours > 1L ? "hours" : "hour") : String.format(format, hours, hours > 1L ? "hours" : "hour", minutes % 60L, minutes % 60L == 1L ? "minute" : "minutes");
        }
        if (minutes > 0L) {
            return seconds % 60L == 0L ? String.format(formatZero, minutes, minutes > 1L ? "minutes" : "minute") : String.format(format, minutes, minutes > 1L ? "minutes" : "minute", seconds % 60L, seconds % 60L == 1L ? "second" : "seconds");
        }
        return String.format(formatZero, seconds, "seconds");
    }

    public static String createHumanReadableTimestamp() {
        return ZonedDateTime.now(ZoneOffset.UTC).format(HUMAN_READABLE_TIMESTAMP_FORMATTER);
    }

    private static SimpleDateFormat createUtcSimpleDateFormat(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    private static SimpleDateFormat createUtcSimpleDateFormat(String pattern, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    private static SimpleDateFormat nonLenientUtcSimpleDateFormat(String pattern) {
        SimpleDateFormat sdf = TimeUtils.createUtcSimpleDateFormat(pattern);
        sdf.setLenient(false);
        return sdf;
    }

    static {
        for (SimpleDateFormat sdf : DATE_FORMATS) {
            String pattern = sdf.toPattern();
            if (pattern.contains("'T'")) {
                FORMATS_WITH_T.add(sdf);
                continue;
            }
            if (pattern.contains("/")) {
                FORMATS_WITH_SLASH.add(sdf);
                continue;
            }
            if (pattern.contains("-")) {
                FORMATS_WITH_DASH.add(sdf);
                continue;
            }
            if (pattern.contains("MMM") || pattern.contains("EEE")) {
                FORMATS_TEXT.add(sdf);
                continue;
            }
            FORMATS_GENERIC.add(sdf);
        }
        TimeUtils.sortFormatsByPriority(FORMATS_WITH_T);
        TimeUtils.sortFormatsByPriority(FORMATS_WITH_SLASH);
        TimeUtils.sortFormatsByPriority(FORMATS_WITH_DASH);
        TimeUtils.sortFormatsByPriority(FORMATS_TEXT);
        TimeUtils.sortFormatsByPriority(FORMATS_GENERIC);
        NORMALIZED_DATE_PATTERN = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        NORMALIZED_DATE_PATTERN.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

