/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version;

import com.metaeffekt.artifact.analysis.utils.LruLinkedHashMap;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.VersionComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NormalizationVersionImpl
implements Version {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizationVersionImpl.class);
    private static final Map<String, String> NORMALISED_VERSION_CACHE = new LruLinkedHashMap<String, String>(2500);
    private final String versionPart;
    private final String updatePart;
    private final String normalized;
    private static final Pattern REGEXP_PATTERN_TRAILING_LETTERS = Pattern.compile("[^a-zA-Z]*[a-zA-Z]");
    private static final Pattern REGEXP_PATTER_TRAILING_LETTERS = Pattern.compile("[a-zA-Z].*");
    private static final String[] UPDATE_PARTS = new String[]{"prealpha", "alpha", "beta", "releasecandidate", "rc", "stable", "sr", "rs", "generalavailability", "ga", "longtermsupport", "lts", "update", "sp", "featurecomplete", "fc", "endoflife", "eol"};

    public NormalizationVersionImpl(String versionPart) {
        this.versionPart = versionPart;
        this.updatePart = null;
        this.normalized = this.normalizeVersion(versionPart);
    }

    public NormalizationVersionImpl(String versionPart, String updatePart) {
        this.versionPart = versionPart;
        this.updatePart = updatePart;
        this.normalized = this.normalizeVersion(versionPart);
    }

    @Override
    public boolean equals(Version version) {
        return this.matchesVersionOf(version);
    }

    @Override
    public boolean matchesVersionOf(String checkVersion, String checkUpdate, String versionEndIncluding, String versionEndExcluding, String versionStartExcluding, String versionStartIncluding, VersionContext context) {
        boolean inRange;
        if (this.versionPart != null && this.updatePart == null && (this.versionPart.equals("*") || this.versionPart.equals("-"))) {
            return true;
        }
        if (checkVersion.equals("-") ? StringUtils.hasText(this.versionPart) && !this.versionPart.equals("*") && !this.versionPart.equals("-") : checkUpdate.equals("-") && StringUtils.hasText(this.updatePart) && !this.updatePart.equals("*") && !this.updatePart.equals("-")) {
            return false;
        }
        String normalisedCheckVersion = this.normalizePart(checkVersion);
        String normalisedCheckUpdate = this.normalizePart(checkUpdate);
        String normalisedVersionEndIncluding = this.normalizePart(versionEndIncluding);
        String normalisedVersionEndExcluding = this.normalizePart(versionEndExcluding);
        String normalisedVersionStartExcluding = this.normalizePart(versionStartExcluding);
        String normalisedVersionStartIncluding = this.normalizePart(versionStartIncluding);
        if (this.versionPart == null && this.updatePart == null) {
            return true;
        }
        if (this.matchesVersionOf(normalisedCheckVersion, normalisedCheckUpdate)) {
            return true;
        }
        if (this.matchesVersionOf(normalisedVersionStartExcluding, null)) {
            return false;
        }
        if (this.matchesVersionOf(normalisedVersionEndExcluding, null)) {
            return false;
        }
        if (this.matchesVersionOf(normalisedVersionStartIncluding, null)) {
            return true;
        }
        if (this.matchesVersionOf(normalisedVersionEndIncluding, null)) {
            return true;
        }
        boolean beforeStart = false;
        String startBoundary = StringUtils.nonNull(normalisedVersionStartExcluding, normalisedVersionStartIncluding, normalisedCheckVersion);
        if (startBoundary != null && this.before(startBoundary)) {
            beforeStart = true;
        }
        boolean afterEnd = false;
        String endBoundary = StringUtils.nonNull(normalisedVersionEndExcluding, normalisedVersionEndIncluding, normalisedCheckVersion);
        if (endBoundary != null && this.after(endBoundary)) {
            afterEnd = true;
        }
        boolean bl = inRange = !beforeStart && !afterEnd;
        if (startBoundary != null && startBoundary.equals(endBoundary) && inRange && normalisedCheckUpdate != null && !normalisedCheckUpdate.equals(this.updatePart) && !"*".equals(this.updatePart)) {
            return false;
        }
        return inRange;
    }

    protected String normalizeVersion(String version) {
        String cacheKey;
        String cachedVersion;
        if (version == null) {
            return null;
        }
        if (version.equals("*") || version.equals("-")) {
            return null;
        }
        if (version.startsWith("v") || version.startsWith("V")) {
            version = version.substring(1);
        }
        if ((cachedVersion = NORMALISED_VERSION_CACHE.get(cacheKey = version)) != null) {
            return cachedVersion;
        }
        char versionLetter = REGEXP_PATTERN_TRAILING_LETTERS.matcher(version).matches() ? (char)version.charAt(version.length() - 1) : (char)'\uffff';
        version = REGEXP_PATTER_TRAILING_LETTERS.matcher(version).replaceAll("");
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(version.split("[\\.-]+")));
        if (versionLetter != '\uffff') {
            while (parts.size() < 3) {
                parts.add("0");
            }
            parts.add(String.valueOf(versionLetter));
        }
        parts.replaceAll(str -> org.apache.commons.lang3.StringUtils.leftPad((String)str, (int)15, (String)"0"));
        String joined = String.join((CharSequence)".", parts);
        NORMALISED_VERSION_CACHE.put(cacheKey, joined);
        return joined;
    }

    private String normalizeUpdate(String updatePart) {
        if (updatePart == null || updatePart.equals("*") || updatePart.equals("-")) {
            return null;
        }
        return updatePart.replace(" ", "").replace("_", "").replace("-", "").replace(".", "").replaceAll("^[^a-zA-Z]+", "").toLowerCase();
    }

    public boolean matchesVersionOf(String version, String update) {
        version = this.normalizeVersion(version);
        if (this.normalized == null || version == null) {
            return false;
        }
        ArrayList<String> parts1 = new ArrayList<String>(Arrays.asList(this.normalized.split("\\.")));
        ArrayList<String> parts2 = new ArrayList<String>(Arrays.asList(version.split("\\.")));
        if (parts1.size() != parts2.size()) {
            return false;
        }
        for (int i = 0; i < parts1.size(); ++i) {
            String part2;
            String part1 = (String)parts1.get(i);
            if (part1.equals(part2 = (String)parts2.get(i))) continue;
            return false;
        }
        if ((this.updatePart == null || this.updatePart.equals("*") || this.updatePart.equals("-") || this.updatePart.equals("")) && (update == null || update.equals("*") || update.equals("-") || update.equals(""))) {
            return true;
        }
        if (this.updatePart == null || update == null) {
            return false;
        }
        return this.updatePart.equalsIgnoreCase(update);
    }

    public boolean before_(String v2) {
        String v1 = this.normalizeVersion(this.versionPart);
        v2 = this.normalizeVersion(v2);
        ArrayList<String> parts1 = new ArrayList<String>(Arrays.asList(v1.split("\\.")));
        ArrayList<String> parts2 = new ArrayList<String>(Arrays.asList(v2.split("\\.")));
        for (int i = 0; i < parts1.size() && i < parts2.size(); ++i) {
            String part2;
            String part1 = (String)parts1.get(i);
            if (String.CASE_INSENSITIVE_ORDER.compare(part1, part2 = (String)parts2.get(i)) < 0) continue;
            return false;
        }
        return true;
    }

    public boolean before(String version) {
        return this.before(version, null);
    }

    @Override
    public boolean before(Version version) {
        return this.before(version.getVersion(), version.getUpdate());
    }

    public boolean before(String version, String updatePart) {
        if (this.normalized == null || this.normalizeVersion(version) == null) {
            return false;
        }
        int versionCompareResult = String.CASE_INSENSITIVE_ORDER.compare(this.normalized, this.normalizeVersion(version));
        if (versionCompareResult != 0) {
            return versionCompareResult < 0;
        }
        return this.compareUpdate(updatePart) < 0;
    }

    public boolean after(String version) {
        return this.after(version, null);
    }

    @Override
    public boolean after(Version version) {
        return this.after(version.getVersion(), version.getUpdate());
    }

    public boolean after(String version, String updatePart) {
        if (this.normalized == null || this.normalizeVersion(version) == null) {
            return false;
        }
        int versionCompareResult = String.CASE_INSENSITIVE_ORDER.compare(this.normalized, this.normalizeVersion(version));
        if (versionCompareResult != 0) {
            return versionCompareResult > 0;
        }
        return this.compareUpdate(updatePart) > 0;
    }

    @Override
    public boolean beforeOrEqual(Version other) {
        return this.equals(other) || this.before(other);
    }

    @Override
    public boolean afterOrEqual(Version other) {
        return this.equals(other) || this.after(other);
    }

    public int compareUpdate(String updatePart) {
        if (updatePart == null || this.updatePart == null) {
            return 0;
        }
        int ownIndex = this.scoreComparisonUpdate(this.updatePart);
        int compareIndex = this.scoreComparisonUpdate(updatePart);
        return Integer.compare(ownIndex, compareIndex);
    }

    private int scoreComparisonUpdate(String updatePart) {
        String comparePart = this.normalizeUpdate(updatePart);
        if (comparePart == null) {
            return 0;
        }
        int value = 0;
        if (comparePart.matches(".*[0-9].*")) {
            value += Integer.parseInt(comparePart.replaceAll("[^0-9]", ""));
        }
        for (int i = 0; i < UPDATE_PARTS.length; ++i) {
            if (!comparePart.contains(UPDATE_PARTS[i])) continue;
            value += (i + 1) * 100000;
            break;
        }
        return value;
    }

    public String getVersionPart() {
        return this.versionPart;
    }

    public String getUpdatePart() {
        return this.updatePart;
    }

    @Override
    public String getVersion() {
        return this.versionPart;
    }

    @Override
    public String getUpdate() {
        return this.updatePart;
    }

    public String toString() {
        return "Version{versionPart='" + this.versionPart + '\'' + ", updatePart='" + this.updatePart + '\'' + '}';
    }

    @Override
    public int compareTo(Version o) {
        return VersionComparator.INSTANCE.compare(this.getVersion(), o.getVersion());
    }
}

