/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.CommonPartsVersionImpl;
import com.metaeffekt.artifact.analysis.version.VersionConstructor;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRange;
import java.util.concurrent.atomic.AtomicReference;

public interface Version
extends Comparable<Version> {
    public static final AtomicReference<VersionConstructor<?>> DEFAULT_VERSION_FACTORY = new AtomicReference<VersionConstructor<Version>>(CommonPartsVersionImpl::new);

    default public boolean matchesVersionOf(String checkVersion, String checkUpdate, String versionEndIncluding, String versionEndExcluding, String versionStartExcluding, String versionStartIncluding) {
        return this.matchesVersionOf(checkVersion, checkUpdate, versionEndIncluding, versionEndExcluding, versionStartExcluding, versionStartIncluding, VersionContext.EMPTY);
    }

    default public boolean matchesVersionOf(String checkVersion, String checkUpdate, String versionEndIncluding, String versionEndExcluding, String versionStartExcluding, String versionStartIncluding, VersionContext context) {
        String normalisedCheckUpdate;
        if (this.getVersion() != null && this.getUpdate() == null && (this.getVersion().equals("*") || this.getVersion().equals("-"))) {
            return true;
        }
        if ("-".equals(checkVersion) ? StringUtils.hasText(this.getVersion()) && !this.getVersion().equals("*") && !this.getVersion().equals("-") : "-".equals(checkUpdate) && StringUtils.hasText(this.getUpdate()) && !this.getUpdate().equals("*") && !this.getUpdate().equals("-")) {
            return false;
        }
        String normalisedCheckVersion = this.normalizePart(checkVersion);
        Version vsVersion = Version.of(normalisedCheckVersion, normalisedCheckUpdate = this.normalizePart(checkUpdate), context);
        if (vsVersion.isNotEmpty() && vsVersion.equals(this)) {
            return true;
        }
        if (this.normalizePart(this.getVersion()) != null) {
            String normalisedVersionEndIncluding = this.normalizePart(versionEndIncluding);
            String normalisedVersionEndExcluding = this.normalizePart(versionEndExcluding);
            String normalisedVersionStartExcluding = this.normalizePart(versionStartExcluding);
            String normalisedVersionStartIncluding = this.normalizePart(versionStartIncluding);
            Version vsVersionStartExcluding = Version.of(normalisedVersionStartExcluding, context);
            if (vsVersionStartExcluding.isNotEmpty() && !this.after(vsVersionStartExcluding)) {
                return false;
            }
            Version vsVersionEndExcluding = Version.of(normalisedVersionEndExcluding, context);
            if (vsVersionEndExcluding.isNotEmpty() && !this.before(vsVersionEndExcluding)) {
                return false;
            }
            Version vsVersionStartIncluding = Version.of(StringUtils.nonNull(normalisedVersionStartIncluding, normalisedVersionStartExcluding, normalisedCheckVersion), context);
            if (vsVersionStartIncluding.isNotEmpty() && !this.afterOrEqual(vsVersionStartIncluding)) {
                return false;
            }
            Version vsVersionEndIncluding = Version.of(StringUtils.nonNull(normalisedVersionEndIncluding, normalisedVersionEndExcluding, normalisedCheckVersion), context);
            if (vsVersionEndIncluding.isNotEmpty() && !this.beforeOrEqual(vsVersionEndIncluding)) {
                return false;
            }
        }
        return true;
    }

    default public String normalizePart(String cpeVersion) {
        return cpeVersion == null || cpeVersion.equals("*") || cpeVersion.equals("-") ? null : cpeVersion;
    }

    default public boolean matchesVersionOf(VulnerableSoftwareVersionRange vulnerableSoftware) {
        return this.matchesVersionOf(vulnerableSoftware.getVersion(), vulnerableSoftware.getUpdate(), vulnerableSoftware.getVersionEndIncluding(), vulnerableSoftware.getVersionEndExcluding(), vulnerableSoftware.getVersionStartExcluding(), vulnerableSoftware.getVersionStartIncluding(), vulnerableSoftware.getContext());
    }

    default public boolean matchesVersionOf(Version version) {
        return this.equals(version);
    }

    default public boolean equals(Version other) {
        return this.compareTo(other) == 0;
    }

    default public boolean before(Version other) {
        return this.compareTo(other) < 0;
    }

    default public boolean after(Version other) {
        return this.compareTo(other) > 0;
    }

    default public boolean beforeOrEqual(Version other) {
        return this.compareTo(other) <= 0;
    }

    default public boolean afterOrEqual(Version other) {
        return this.compareTo(other) >= 0;
    }

    public String getVersion();

    public String getUpdate();

    default public boolean isNotEmpty() {
        return this.getVersion() != null || this.getUpdate() != null;
    }

    default public boolean isEmpty() {
        return !this.isNotEmpty();
    }

    public static void setDefaultVersionFactory(VersionConstructor<?> versionFactory) {
        DEFAULT_VERSION_FACTORY.set(versionFactory);
    }

    public static Version of(String version, String update) {
        return Version.of(version, update, VersionContext.EMPTY, DEFAULT_VERSION_FACTORY.get());
    }

    public static Version of(String version) {
        return Version.of(version, null, VersionContext.EMPTY, DEFAULT_VERSION_FACTORY.get());
    }

    public static Version of(String version, String update, VersionContext context) {
        return Version.of(version, update, context, DEFAULT_VERSION_FACTORY.get());
    }

    public static Version of(String version, VersionContext context) {
        return Version.of(version, null, context, DEFAULT_VERSION_FACTORY.get());
    }

    public static <T extends Version> T of(String version, VersionContext context, VersionConstructor<T> versionFactory) {
        return Version.of(version, null, context, versionFactory);
    }

    public static <T extends Version> T of(String version, String update, VersionContext context, VersionConstructor<T> versionFactory) {
        String normalizedVersion = Version.normalizeStringForOf(version);
        String normalizedUpdate = Version.normalizeStringForOf(update);
        return versionFactory.create(normalizedVersion, normalizedUpdate, context);
    }

    public static String normalizeStringForOf(String str) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        return str;
    }
}

