/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version.curation;

import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.correlation.ArtifactCorrelationEntryMatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

public class VersionContextMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(VersionContextMatcher.class);
    private final ArtifactCorrelationEntryMatcher artifactMatcher;
    private final List<Cpe> cpeMatchers;
    private final List<String> vulnerabilities;
    private final List<String> eolIds;
    private final List<String> ghsaProducts;

    public VersionContextMatcher(ArtifactCorrelationEntryMatcher artifactMatcher, List<Cpe> cpeMatchers, List<String> vulnerabilities, List<String> eolIds, List<String> ghsaProducts) {
        this.artifactMatcher = artifactMatcher;
        this.cpeMatchers = cpeMatchers;
        this.vulnerabilities = vulnerabilities;
        this.eolIds = eolIds;
        this.ghsaProducts = ghsaProducts;
    }

    public ArtifactCorrelationEntryMatcher getArtifactMatcher() {
        return this.artifactMatcher;
    }

    public List<Cpe> getCpeMatchers() {
        return this.cpeMatchers;
    }

    public List<String> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public boolean matches(VersionContext context) {
        boolean bl;
        boolean matchesArtifact = false;
        if (this.artifactMatcher != null) {
            for (Artifact artifact : context.getArtifacts()) {
                if (!this.artifactMatcher.affects(artifact)) continue;
                matchesArtifact = true;
                break;
            }
        }
        boolean matchesCpe = false;
        if (this.cpeMatchers != null) {
            block1: for (Cpe cpe : context.getCpes()) {
                for (Cpe cpeMatcher : this.cpeMatchers) {
                    if (!CommonEnumerationUtil.compareCpeUsingWildcards(cpe, cpeMatcher)) continue;
                    matchesCpe = true;
                    continue block1;
                }
            }
        }
        boolean matchesVulnerability = false;
        if (this.vulnerabilities != null) {
            block3: for (String string : context.getVulnerabilities()) {
                for (String string2 : this.vulnerabilities) {
                    if (!string2.equals(string)) continue;
                    matchesVulnerability = true;
                    continue block3;
                }
            }
        }
        boolean matchesEol = false;
        if (this.eolIds != null) {
            block5: for (String eolId : context.getEolIds()) {
                for (String eolIdMatcher : this.eolIds) {
                    if (!eolIdMatcher.equals(eolId)) continue;
                    matchesEol = true;
                    continue block5;
                }
            }
        }
        boolean bl2 = false;
        if (this.ghsaProducts != null) {
            block7: for (String string : context.getGhsaProducts()) {
                for (String ghsaProductMatcher : this.ghsaProducts) {
                    if (!ghsaProductMatcher.equals(string)) continue;
                    bl = true;
                    continue block7;
                }
            }
        }
        return !(this.artifactMatcher != null && !matchesArtifact || this.cpeMatchers != null && !matchesCpe || this.vulnerabilities != null && !matchesVulnerability || this.eolIds != null && !matchesEol || this.ghsaProducts != null && !bl);
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static VersionContextMatcher fromYaml(Map<String, Object> context) {
        ArtifactCorrelationEntryMatcher artifactMatcher = null;
        ArrayList<Cpe> cpeMatchers = null;
        ArrayList<String> vulnerabilities = null;
        ArrayList<String> eolIds = null;
        ArrayList<String> ghsaProducts = null;
        if (context.containsKey("artifact")) {
            if (context.get("artifact") instanceof LinkedHashMap) {
                artifactMatcher = ArtifactCorrelationEntryMatcher.createEntryFromYamlMap((LinkedHashMap)context.get("artifact"));
            } else if (context.get("artifact") instanceof String) {
                artifactMatcher = ArtifactCorrelationEntryMatcher.createEntryFromArtifactIdAffects(String.valueOf(context.get("artifact")));
            } else {
                throw new IllegalArgumentException("Artifact matcher must be an artifact Id (String) or a Map: " + context.get("artifact"));
            }
        }
        if (context.containsKey("cpe") && context.get("cpe") instanceof ArrayList) {
            cpeMatchers = new ArrayList<Cpe>();
            for (Object o : (ArrayList)context.get("cpe")) {
                if (o instanceof String) {
                    cpeMatchers.add(CommonEnumerationUtil.parseCpe(String.valueOf(o)).get());
                    continue;
                }
                throw new IllegalArgumentException("CPE matcher must be a string: " + o);
            }
        }
        if (context.containsKey("vulnerability") && context.get("vulnerability") instanceof ArrayList) {
            vulnerabilities = new ArrayList<String>();
            for (Object o : (ArrayList)context.get("vulnerability")) {
                if (o instanceof String) {
                    vulnerabilities.add(String.valueOf(o));
                    continue;
                }
                throw new IllegalArgumentException("Vulnerability matcher must be a string: " + o);
            }
        }
        if (context.containsKey("eolIds") && context.get("eolIds") instanceof ArrayList) {
            eolIds = new ArrayList<String>();
            for (Object o : (ArrayList)context.get("eolIds")) {
                if (o instanceof String) {
                    eolIds.add(String.valueOf(o));
                    continue;
                }
                throw new IllegalArgumentException("eolIds matcher must be a string: " + o);
            }
        }
        if (context.containsKey("ghsaProducts") && context.get("ghsaProducts") instanceof ArrayList) {
            ghsaProducts = new ArrayList<String>();
            for (Object o : (ArrayList)context.get("ghsaProducts")) {
                if (o instanceof String) {
                    ghsaProducts.add(String.valueOf(o));
                    continue;
                }
                throw new IllegalArgumentException("ghsaProducts matcher must be a string: " + o);
            }
        }
        return new VersionContextMatcher(artifactMatcher, cpeMatchers, vulnerabilities, eolIds, ghsaProducts);
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.artifactMatcher != null) {
            jsonObject.put("artifact", (Object)this.artifactMatcher.toJson());
        }
        if (this.cpeMatchers != null) {
            jsonObject.put("cpe", (Object)CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(this.cpeMatchers));
        }
        if (this.vulnerabilities != null) {
            jsonObject.put("vulnerability", this.vulnerabilities);
        }
        return jsonObject;
    }
}

