/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version.curation.functions;

import com.metaeffekt.artifact.analysis.version.curation.ExtractedCuratedVersionParts;
import com.metaeffekt.artifact.analysis.version.curation.functions.CuratedVersionFunctionClearIfMatches;
import com.metaeffekt.artifact.analysis.version.curation.functions.CuratedVersionFunctionFillEmpty;
import com.metaeffekt.artifact.analysis.version.curation.functions.CuratedVersionFunctionReplace;
import com.metaeffekt.artifact.analysis.version.curation.functions.CuratedVersionFunctionReplaceRegex;
import com.metaeffekt.artifact.analysis.version.curation.functions.CuratedVersionFunctionSegmentsCount;
import com.metaeffekt.artifact.analysis.version.token.VersionToken;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.json.JSONObject;

public abstract class CuratedVersionFunction {
    private final String partName;
    private static final Map<String, Function<LinkedHashMap<String, Object>, CuratedVersionFunction>> CURATION_FUNCTIONS = CuratedVersionFunction.createCurationFunctionMap();

    protected CuratedVersionFunction(LinkedHashMap<String, Object> yaml) {
        this.partName = String.valueOf(yaml.get("part"));
    }

    public String getPartName() {
        return this.partName;
    }

    public void apply(ExtractedCuratedVersionParts parts) {
        switch (this.partName) {
            case "spec": {
                parts.setSpecVersion(this.applyToPart(parts.getSpecVersion()));
                break;
            }
            case "sem": {
                parts.setSemVersion(this.applyToPart(parts.getSemVersion()));
                break;
            }
            case "build": {
                parts.setBuildVersion(this.applyToPart(parts.getBuildVersion()));
                break;
            }
            case "modifier": {
                parts.setVersionModifier(this.applyToPart(parts.getVersionModifier()));
                break;
            }
            case "other": {
                parts.setOtherVersionPart(this.applyToPart(parts.getOtherVersionPart()));
                break;
            }
            case "after-all": {
                parts.setAfterAllPart(this.applyToPart(parts.getAfterAllPart()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported part: " + this.partName);
            }
        }
    }

    protected abstract VersionToken applyToPart(VersionToken var1);

    public String getFunctionName() {
        return this.getClass().getSimpleName().replace("CuratedVersionFunction", "").replaceAll("(?<!^)(?=[A-Z])", "_").toLowerCase();
    }

    public JSONObject toJson() {
        return new JSONObject().put("part", (Object)this.partName).put("function", (Object)this.getFunctionName());
    }

    private static Map<String, Function<LinkedHashMap<String, Object>, CuratedVersionFunction>> createCurationFunctionMap() {
        LinkedHashMap<String, Function<LinkedHashMap<String, Object>, CuratedVersionFunction>> map = new LinkedHashMap<String, Function<LinkedHashMap<String, Object>, CuratedVersionFunction>>();
        map.put("segments_count", CuratedVersionFunctionSegmentsCount::new);
        map.put("replace", CuratedVersionFunctionReplace::new);
        map.put("replace_regex", CuratedVersionFunctionReplaceRegex::new);
        map.put("fill_empty", CuratedVersionFunctionFillEmpty::new);
        map.put("clear_if_matches", CuratedVersionFunctionClearIfMatches::new);
        return map;
    }

    public static void registerCurationFunction(String name, Function<LinkedHashMap<String, Object>, CuratedVersionFunction> constructor) {
        CURATION_FUNCTIONS.put(name, constructor);
    }

    public static void unregisterCurationFunction(String name) {
        CURATION_FUNCTIONS.remove(name);
    }

    public static CuratedVersionFunction fromYaml(LinkedHashMap<String, Object> yaml) {
        String functionName = String.valueOf(yaml.get("function"));
        Function<LinkedHashMap<String, Object>, CuratedVersionFunction> functionConstructor = CURATION_FUNCTIONS.get(functionName);
        if (functionConstructor == null) {
            throw new IllegalArgumentException("Unsupported curation function: " + functionName);
        }
        return functionConstructor.apply(yaml);
    }

    protected String getStringProperty(LinkedHashMap<String, Object> yaml, String key, String defaultValue) {
        Object value = yaml.get(key);
        if (value == null) {
            return defaultValue;
        }
        return String.valueOf(value);
    }

    protected String getStringPropertyOrThrow(LinkedHashMap<String, Object> yaml, String key) {
        Object value = yaml.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Missing property on function " + this.getFunctionName() + ": " + key);
        }
        return String.valueOf(value);
    }

    protected int getIntProperty(LinkedHashMap<String, Object> yaml, String key, int defaultValue) {
        Object value = yaml.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(String.valueOf(value));
    }

    protected int getIntPropertyOrThrow(LinkedHashMap<String, Object> yaml, String key) {
        Object value = yaml.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Missing property on function " + this.getFunctionName() + ": " + key);
        }
        return Integer.parseInt(String.valueOf(value));
    }

    protected boolean getBooleanProperty(LinkedHashMap<String, Object> yaml, String key, boolean defaultValue) {
        Object value = yaml.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(String.valueOf(value));
    }

    protected boolean getBooleanPropertyOrThrow(LinkedHashMap<String, Object> yaml, String key) {
        Object value = yaml.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Missing property on function " + this.getFunctionName() + ": " + key);
        }
        return Boolean.parseBoolean(String.valueOf(value));
    }

    protected LinkedHashMap<String, Object> getSubMap(LinkedHashMap<String, Object> yaml, String key) {
        Object value = yaml.get(key);
        if (value == null) {
            return null;
        }
        return (LinkedHashMap)value;
    }

    protected LinkedHashMap<String, Object> getSubMapOrThrow(LinkedHashMap<String, Object> yaml, String key) {
        Object value = yaml.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Missing property on function " + this.getFunctionName() + ": " + key);
        }
        return (LinkedHashMap)value;
    }
}

