/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment;

import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    public static final VersionComparator INSTANCE = new VersionComparator(false);
    public static final VersionComparator INSTANCE_COMMON_PARTS = new VersionComparator(true);
    private final boolean useOnlyCommonParts;

    private VersionComparator(boolean useOnlyCommonParts) {
        this.useOnlyCommonParts = useOnlyCommonParts;
    }

    public boolean equals(String o1, String o2) {
        return this.compare(o1, o2) == 0;
    }

    @Override
    public int compare(String o1, String o2) {
        String suffix2;
        long number2;
        VersionTokenizer tokenizer1 = new VersionTokenizer(o1);
        VersionTokenizer tokenizer2 = new VersionTokenizer(o2);
        while (tokenizer1.moveNext()) {
            String suffix1;
            long number1;
            if (!tokenizer2.moveNext()) {
                if (this.useOnlyCommonParts) {
                    return 0;
                }
                do {
                    number1 = tokenizer1.getNumber();
                    suffix1 = tokenizer1.getSuffix();
                    if (number1 == 0L && suffix1.isEmpty()) continue;
                    return 1;
                } while (tokenizer1.moveNext());
                return 0;
            }
            number1 = tokenizer1.getNumber();
            suffix1 = tokenizer1.getSuffix();
            number2 = tokenizer2.getNumber();
            suffix2 = tokenizer2.getSuffix();
            if (number1 < number2) {
                return -1;
            }
            if (number1 > number2) {
                return 1;
            }
            boolean empty1 = suffix1.isEmpty();
            boolean empty2 = suffix2.isEmpty();
            if (empty1 && empty2) continue;
            if (empty1) {
                return 1;
            }
            if (empty2) {
                return -1;
            }
            int result = suffix1.compareTo(suffix2);
            if (result == 0) continue;
            return result;
        }
        if (tokenizer2.moveNext()) {
            if (this.useOnlyCommonParts) {
                return 0;
            }
            do {
                number2 = tokenizer2.getNumber();
                suffix2 = tokenizer2.getSuffix();
                if (number2 == 0L && suffix2.isEmpty()) continue;
                return -1;
            } while (tokenizer2.moveNext());
            return 0;
        }
        return 0;
    }

    private static class VersionTokenizer {
        private final String _versionString;
        private final int _length;
        private int _position;
        private long _number;
        private String _suffix;
        private boolean _hasValue;

        public long getNumber() {
            return this._number;
        }

        public String getSuffix() {
            return this._suffix;
        }

        public boolean hasValue() {
            return this._hasValue;
        }

        public VersionTokenizer(String versionString) {
            if (versionString == null) {
                throw new IllegalArgumentException("versionString is null");
            }
            this._versionString = versionString;
            this._length = versionString.length();
        }

        public boolean moveNext() {
            char c;
            char c2;
            this._number = 0L;
            this._suffix = "";
            this._hasValue = false;
            if (this._position >= this._length) {
                return false;
            }
            this._hasValue = true;
            while (this._position < this._length && (c2 = this._versionString.charAt(this._position)) >= '0' && c2 <= '9') {
                this._number = this._number * 10L + (long)(c2 - 48);
                ++this._position;
            }
            int suffixStart = this._position;
            while (this._position < this._length && (c = this._versionString.charAt(this._position)) != '.') {
                ++this._position;
            }
            this._suffix = this._versionString.substring(suffixStart, this._position);
            if (this._position < this._length) {
                ++this._position;
            }
            return true;
        }
    }
}

