/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;

public class BooleanFilterAttribute
extends FilterAttribute {
    private final String booleanOperator;
    private final FilterAttribute leftOperand;
    private final FilterAttribute rightOperand;

    public BooleanFilterAttribute(List<Object> tokens) {
        int operatorIndex = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            if (!(tokens.get(i) instanceof String) || !((String)tokens.get(i)).matches("^(or|and|xor|nand|nor|xnor|implies)$")) continue;
            operatorIndex = i;
            break;
        }
        if (operatorIndex == -1) {
            throw new IllegalArgumentException("No boolean operator found in " + tokens);
        }
        this.booleanOperator = (String)tokens.get(operatorIndex);
        this.leftOperand = super.getFilterAttributeOrParse(tokens.subList(0, operatorIndex));
        this.rightOperand = super.getFilterAttributeOrParse(tokens.subList(operatorIndex + 1, tokens.size()));
    }

    @Override
    public Object evaluate(Vulnerability vulnerability) {
        Object leftValue = this.leftOperand.evaluate(vulnerability);
        Object rightValue = this.rightOperand.evaluate(vulnerability);
        return this.evaluate(leftValue, rightValue);
    }

    @Override
    @Deprecated
    public Object evaluate(VulnerabilityMetaData vulnerability) {
        Object leftValue = this.leftOperand.evaluate(vulnerability);
        Object rightValue = this.rightOperand.evaluate(vulnerability);
        return this.evaluate(leftValue, rightValue);
    }

    private Object evaluate(Object left, Object right) {
        switch (this.booleanOperator) {
            case "or": {
                return this.parseBoolean(left) || this.parseBoolean(right);
            }
            case "and": {
                return this.parseBoolean(left) && this.parseBoolean(right);
            }
            case "xor": {
                return this.parseBoolean(left) ^ this.parseBoolean(right);
            }
            case "nand": {
                return !this.parseBoolean(left) || !this.parseBoolean(right);
            }
            case "nor": {
                return !this.parseBoolean(left) && !this.parseBoolean(right);
            }
            case "xnor": {
                return this.parseBoolean(left) == this.parseBoolean(right);
            }
            case "implies": {
                return !this.parseBoolean(left) || this.parseBoolean(right);
            }
        }
        throw new IllegalArgumentException("Unknown boolean operator " + this.booleanOperator);
    }

    @Override
    public String toString() {
        return "<" + this.leftOperand + " " + this.booleanOperator + " " + this.rightOperand + ">";
    }
}

