/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;

public class CalculationFilterAttribute
extends FilterAttribute {
    private final String calculationOperator;
    private final FilterAttribute leftOperand;
    private final FilterAttribute rightOperand;

    public CalculationFilterAttribute(List<Object> tokens) {
        int operatorIndex = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            if (!(tokens.get(i) instanceof String) || !((String)tokens.get(i)).matches("^([+\\-*/%^])$")) continue;
            operatorIndex = i;
            break;
        }
        if (operatorIndex == -1) {
            throw new IllegalArgumentException("No calculation operator found in " + tokens);
        }
        this.calculationOperator = (String)tokens.get(operatorIndex);
        this.leftOperand = super.getFilterAttributeOrParse(tokens.subList(0, operatorIndex));
        this.rightOperand = super.getFilterAttributeOrParse(tokens.subList(operatorIndex + 1, tokens.size()));
    }

    @Override
    public Object evaluate(Vulnerability vulnerability) {
        Object leftValue = this.leftOperand.evaluate(vulnerability);
        Object rightValue = this.rightOperand.evaluate(vulnerability);
        return this.evaluate(leftValue, rightValue);
    }

    @Override
    @Deprecated
    public Object evaluate(VulnerabilityMetaData vulnerability) {
        Object leftValue = this.leftOperand.evaluate(vulnerability);
        Object rightValue = this.rightOperand.evaluate(vulnerability);
        return this.evaluate(leftValue, rightValue);
    }

    private Object evaluate(Object left, Object right) {
        switch (this.calculationOperator) {
            case "+": {
                return this.parseDouble(left) + this.parseDouble(right);
            }
            case "-": {
                return this.parseDouble(left) - this.parseDouble(right);
            }
            case "*": {
                return this.parseDouble(left) * this.parseDouble(right);
            }
            case "/": {
                return this.parseDouble(left) / this.parseDouble(right);
            }
            case "%": {
                return this.parseDouble(left) % this.parseDouble(right);
            }
            case "^": {
                return Math.pow(this.parseDouble(left), this.parseDouble(right));
            }
        }
        throw new IllegalArgumentException("Unknown calculation operator " + this.calculationOperator);
    }

    @Override
    public String toString() {
        return "<" + this.leftOperand + " " + this.calculationOperator + " " + this.rightOperand + ">";
    }
}

