/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.AmbDataClass;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.metaeffekt.core.security.cvss.v3.Cvss3P1;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionCallFilterAttribute
extends FilterAttribute {
    private static final Logger log = LoggerFactory.getLogger(FunctionCallFilterAttribute.class);
    public static final Function[] FUNCTIONS = new Function[]{new Function("attribute", 1), new Function("score", 3), new Function("time", 2), new Function("length", 1), new Function("advisor", 1)};
    private final String functionName;
    private final List<FilterAttribute> arguments;

    public FunctionCallFilterAttribute(List<Object> tokens) {
        this.functionName = (String)tokens.get(0);
        this.arguments = super.getFilterAttributesOrParse(tokens.subList(1, tokens.size()));
    }

    @Override
    public Object evaluate(Vulnerability vulnerability) {
        Object result = this.evaluate(vulnerability, FunctionCallFilterAttribute::valueProviderVulnerability);
        if (VulnerabilityStatus.LOG_MATCHING_CRITERIA) {
            log.info("FunctionCallFilterAttribute.evaluate(Vulnerability) - [{}] - [{}] --> [{}]", new Object[]{vulnerability.getId(), this, result});
        }
        return result;
    }

    @Override
    @Deprecated
    public Object evaluate(VulnerabilityMetaData vulnerability) {
        log.warn("FunctionCallFilterAttribute.evaluate(VulnerabilityMetaData) is deprecated. Use evaluate(Vulnerability) instead.");
        return this.evaluate(vulnerability, FunctionCallFilterAttribute::valueProviderVMD);
    }

    private Object evaluate(Object vulnerability, BiFunction<Object, String, Object> valueProvider) {
        switch (this.functionName) {
            case "attribute": {
                return valueProvider.apply(vulnerability, (String)this.callEvaluateFunction(this.arguments.get(0), vulnerability));
            }
            case "score": {
                String modifiedUnmodified = this.callEvaluateFunction(this.arguments.get(0), vulnerability).toString();
                String scoringMethod = this.callEvaluateFunction(this.arguments.get(1), vulnerability).toString();
                String vectorType = this.callEvaluateFunction(this.arguments.get(2), vulnerability).toString();
                Cvss2 cvss2 = (Cvss2)valueProvider.apply(vulnerability, "cvss-v2-" + modifiedUnmodified);
                Cvss3P1 cvss3 = (Cvss3P1)valueProvider.apply(vulnerability, "cvss-v3-" + modifiedUnmodified);
                Cvss4P0 cvss4 = (Cvss4P0)valueProvider.apply(vulnerability, "cvss-v4-" + modifiedUnmodified);
                double scoreV2 = -1.0;
                double scoreV3 = -1.0;
                double scoreV4 = -1.0;
                if (scoringMethod.contains("overall")) {
                    if (cvss2 != null) {
                        scoreV2 = cvss2.getOverallScore();
                    }
                    if (cvss3 != null) {
                        scoreV3 = cvss3.getOverallScore();
                    }
                    if (cvss4 != null) {
                        scoreV4 = cvss4.getOverallScore();
                    }
                } else if (scoringMethod.contains("base")) {
                    if (cvss2 != null) {
                        scoreV2 = cvss2.getBaseScore();
                    }
                    if (cvss3 != null) {
                        scoreV3 = cvss3.getBaseScore();
                    }
                    if (cvss4 != null) {
                        scoreV4 = cvss4.getBaseScore();
                    }
                } else if (scoringMethod.contains("temporal")) {
                    if (cvss2 != null) {
                        scoreV2 = cvss2.getTemporalScore();
                    }
                    if (cvss3 != null) {
                        scoreV3 = cvss3.getTemporalScore();
                    }
                } else if (scoringMethod.contains("environmental")) {
                    if (cvss2 != null) {
                        scoreV2 = cvss2.getEnvironmentalScore();
                    }
                    if (cvss3 != null) {
                        scoreV3 = cvss3.getEnvironmentalScore();
                    }
                } else {
                    throw new IllegalArgumentException("Unknown scoring method: " + scoringMethod);
                }
                if (vectorType.contains("v2")) {
                    return scoreV2;
                }
                if (vectorType.contains("v3")) {
                    return scoreV3;
                }
                if (vectorType.contains("v4")) {
                    return scoreV4;
                }
                if (vectorType.equals("max")) {
                    return Math.max(Math.max(scoreV2, scoreV3), scoreV4);
                }
                if (vectorType.equals("min")) {
                    return Math.min(Math.min(scoreV2, scoreV3), scoreV4);
                }
                if (vectorType.equals("latest")) {
                    if (scoreV4 >= 0.0) {
                        return scoreV4;
                    }
                    if (scoreV3 >= 0.0) {
                        return scoreV3;
                    }
                    if (scoreV2 >= 0.0) {
                        return scoreV2;
                    }
                    return -1;
                }
                throw new IllegalArgumentException("Unknown vector type: " + vectorType);
            }
            case "time": {
                double time = (Double)this.callEvaluateFunction(this.arguments.get(0), vulnerability);
                String unit = this.callEvaluateFunction(this.arguments.get(1), vulnerability).toString();
                return this.calculateTime(unit, time);
            }
            case "length": {
                String string = this.callEvaluateFunction(this.arguments.get(0), vulnerability).toString();
                if (StringUtils.isEmpty(string)) {
                    return 0;
                }
                return string.length();
            }
            case "advisor": {
                String infoType = this.callEvaluateFunction(this.arguments.get(0), vulnerability).toString();
                return valueProvider.apply(vulnerability, "advisor-" + infoType);
            }
        }
        throw new IllegalArgumentException("Unknown function: " + this.functionName);
    }

    public long calculateTime(String unit, double time) {
        long calculatedTime;
        switch (unit) {
            case "minutes": {
                calculatedTime = (long)(time * 60.0 * 1000.0);
                break;
            }
            case "hours": {
                calculatedTime = (long)(time * 60.0 * 60.0 * 1000.0);
                break;
            }
            case "days": {
                calculatedTime = (long)(time * 24.0 * 60.0 * 60.0 * 1000.0);
                break;
            }
            case "weeks": {
                calculatedTime = (long)(time * 7.0 * 24.0 * 60.0 * 60.0 * 1000.0);
                break;
            }
            case "months": {
                calculatedTime = (long)(time * 30.0 * 24.0 * 60.0 * 60.0 * 1000.0);
                break;
            }
            case "years": {
                calculatedTime = (long)(time * 365.0 * 24.0 * 60.0 * 60.0 * 1000.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown unit: " + unit);
            }
        }
        return calculatedTime;
    }

    private Object callEvaluateFunction(FilterAttribute filter, Object vulnerability) {
        if (vulnerability instanceof Vulnerability) {
            return filter.evaluate((Vulnerability)vulnerability);
        }
        if (vulnerability instanceof VulnerabilityMetaData) {
            return filter.evaluate((VulnerabilityMetaData)vulnerability);
        }
        throw new IllegalArgumentException("Unknown vulnerability type: " + vulnerability.getClass().getName());
    }

    public static Object valueProviderVulnerability(Object vuln, String valueProviderName) {
        Vulnerability vulnerability = (Vulnerability)vuln;
        switch (valueProviderName) {
            case "name": {
                return vulnerability.getId() != null ? vulnerability.getId() : "";
            }
            case "description": {
                return vulnerability.getDescription() != null ? vulnerability.getDescription() : "";
            }
            case "updated": {
                return vulnerability.getUpdateDate() != null ? vulnerability.getUpdateDate().getTime() : -1L;
            }
            case "created": {
                return vulnerability.getCreateDate() != null ? vulnerability.getCreateDate().getTime() : -1L;
            }
            case "cwe": {
                return String.join((CharSequence)", ", vulnerability.getCwes());
            }
            case "source": {
                return vulnerability.getDataSources().stream().map(ContentIdentifierStore.ContentIdentifier::getWellFormedName).collect(Collectors.joining(", "));
            }
            case "cvss-v4-unmodified": 
            case "cvss-v4-initial": {
                return vulnerability.getCvssSelectionResult().getInitialCvss4();
            }
            case "cvss-v3-unmodified": 
            case "cvss-v3-initial": {
                return vulnerability.getCvssSelectionResult().getInitialCvss3();
            }
            case "cvss-v2-unmodified": 
            case "cvss-v2-initial": {
                return vulnerability.getCvssSelectionResult().getInitialCvss2();
            }
            case "cvss-v4-modified": 
            case "cvss-v4-context": {
                return vulnerability.getCvssSelectionResult().getContextCvss4();
            }
            case "cvss-v3-modified": 
            case "cvss-v3-context": {
                return vulnerability.getCvssSelectionResult().getContextCvss3();
            }
            case "cvss-v2-modified": 
            case "cvss-v2-context": {
                return vulnerability.getCvssSelectionResult().getContextCvss2();
            }
            case "cvss-initial": {
                return vulnerability.getCvssSelectionResult().getSelectedInitialCvss();
            }
            case "cvss-context": {
                return vulnerability.getCvssSelectionResult().getSelectedContextCvss();
            }
            case "msrc-fixes": {
                return vulnerability.getAdditionalAttribute(InventoryAttribute.MS_FIXING_KB_IDENTIFIER) != null ? vulnerability.getAdditionalAttribute(InventoryAttribute.MS_FIXING_KB_IDENTIFIER) : "";
            }
            case "advisor-ids": {
                return vulnerability.getSecurityAdvisories().stream().map(AmbDataClass::getId).collect(Collectors.joining(", "));
            }
            case "advisor-providers": {
                return vulnerability.getRelatedAdvisorsTypes().stream().map(ContentIdentifierStore.ContentIdentifier::getWellFormedName).collect(Collectors.joining(", "));
            }
            case "advisor-types": {
                return vulnerability.getSecurityAdvisories().stream().map(AdvisoryEntry::getType).collect(Collectors.joining(", "));
            }
        }
        throw new IllegalArgumentException("Unknown value provider: " + valueProviderName);
    }

    @Deprecated
    public static Object valueProviderVMD(Object vuln, String valueProviderName) {
        log.warn("FunctionCallFilterAttribute.valueProviderVMD(Object, String) is deprecated. Use valueProviderVulnerability(Object, String) instead.");
        VulnerabilityMetaData vulnerability = (VulnerabilityMetaData)vuln;
        switch (valueProviderName) {
            case "name": {
                return vulnerability.get(VulnerabilityMetaData.Attribute.NAME) != null ? vulnerability.get(VulnerabilityMetaData.Attribute.NAME) : "";
            }
            case "description": {
                return vulnerability.get(InventoryAttribute.DESCRIPTION.getKey()) != null ? vulnerability.get(InventoryAttribute.DESCRIPTION.getKey()) : "";
            }
            case "updated": {
                return vulnerability.get(InventoryAttribute.VULNERABILITY_UPDATED_DATE_TIMESTAMP.getKey()) != null ? vulnerability.get(InventoryAttribute.VULNERABILITY_UPDATED_DATE_TIMESTAMP.getKey()) : Integer.valueOf(-1);
            }
            case "created": {
                return vulnerability.get(InventoryAttribute.VULNERABILITY_CREATED_DATE_TIMESTAMP.getKey()) != null ? vulnerability.get(InventoryAttribute.VULNERABILITY_CREATED_DATE_TIMESTAMP.getKey()) : Integer.valueOf(-1);
            }
            case "cwe": {
                return vulnerability.get(VulnerabilityMetaData.Attribute.WEAKNESS) != null ? vulnerability.get(VulnerabilityMetaData.Attribute.WEAKNESS) : "";
            }
            case "source": {
                return vulnerability.get((AbstractModelBase.Attribute)AdvisoryMetaData.Attribute.DATA_SOURCE) != null ? vulnerability.get((AbstractModelBase.Attribute)AdvisoryMetaData.Attribute.DATA_SOURCE) : "";
            }
            case "cvss-v4-unmodified": 
            case "cvss-v4-modified": 
            case "cvss-v4-initial": 
            case "cvss-v4-context": {
                String cvss4Unmodified = FunctionCallFilterAttribute.findFirstCvssVectorOnVmdLegacySupport(vulnerability, Cvss4P0.getVersionName());
                if (StringUtils.hasText(cvss4Unmodified)) {
                    return new Cvss4P0(cvss4Unmodified);
                }
                return null;
            }
            case "cvss-v3-unmodified": 
            case "cvss-v3-modified": 
            case "cvss-v3-initial": 
            case "cvss-v3-context": {
                String cvss3Unmodified = FunctionCallFilterAttribute.findFirstCvssVectorOnVmdLegacySupport(vulnerability, Cvss3P1.getVersionName());
                if (StringUtils.hasText(cvss3Unmodified)) {
                    return new Cvss3P1(cvss3Unmodified);
                }
                return null;
            }
            case "cvss-v2-unmodified": 
            case "cvss-v2-modified": 
            case "cvss-v2-initial": 
            case "cvss-v2-context": {
                String cvss2Unmodified = FunctionCallFilterAttribute.findFirstCvssVectorOnVmdLegacySupport(vulnerability, Cvss2.getVersionName());
                if (StringUtils.hasText(cvss2Unmodified)) {
                    return new Cvss2(cvss2Unmodified);
                }
                return null;
            }
            case "cvss-initial": 
            case "cvss-context": {
                String cvss4Initial = FunctionCallFilterAttribute.findFirstCvssVectorOnVmdLegacySupport(vulnerability, Cvss4P0.getVersionName());
                if (StringUtils.hasText(cvss4Initial)) {
                    return new Cvss4P0(cvss4Initial);
                }
                String cvss3Initial = FunctionCallFilterAttribute.findFirstCvssVectorOnVmdLegacySupport(vulnerability, Cvss3P1.getVersionName());
                if (StringUtils.hasText(cvss3Initial)) {
                    return new Cvss3P1(cvss3Initial);
                }
                String cvss2Initial = FunctionCallFilterAttribute.findFirstCvssVectorOnVmdLegacySupport(vulnerability, Cvss2.getVersionName());
                if (StringUtils.hasText(cvss2Initial)) {
                    return new Cvss2(cvss2Initial);
                }
                return null;
            }
            case "msrc-fixes": {
                return vulnerability.get(InventoryAttribute.MS_FIXING_KB_IDENTIFIER.getKey()) != null ? vulnerability.get(InventoryAttribute.MS_FIXING_KB_IDENTIFIER.getKey()) : "";
            }
            case "advisor-ids": {
                return FunctionCallFilterAttribute.findAdvisoryProvidersOnVmdLegacySupport(vulnerability).values().stream().flatMap(Collection::stream).collect(Collectors.joining(", "));
            }
            case "advisor-providers": {
                return String.join((CharSequence)", ", FunctionCallFilterAttribute.findAdvisoryProvidersOnVmdLegacySupport(vulnerability).keySet());
            }
            case "advisor-types": {
                return "unsupported";
            }
        }
        return vulnerability.get(valueProviderName);
    }

    private static Map<String, List<String>> findAdvisoryProvidersOnVmdLegacySupport(VulnerabilityMetaData vmd) {
        String referencedContentIds = vmd.get((AbstractModelBase.Attribute)InventoryAttribute.VULNERABILITY_REFERENCED_CONTENT_IDS);
        if (StringUtils.hasText(referencedContentIds)) {
            JSONObject providerTypesToIds = new JSONObject(referencedContentIds);
            return providerTypesToIds.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                JSONArray ids = (JSONArray)e.getValue();
                return ids.toList().stream().map(Object::toString).collect(Collectors.toList());
            }));
        }
        return Collections.emptyMap();
    }

    private static String findFirstCvssVectorOnVmdLegacySupport(VulnerabilityMetaData vmd, String version) {
        Map columnToCvssSourceMap = CvssSource.fromMultipleColumnHeaderStrings((Set)vmd.getAttributes());
        for (String column : columnToCvssSourceMap.keySet()) {
            if (!column.startsWith(version)) continue;
            return vmd.get(column);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.functionName + "(" + this.arguments.stream().map(Object::toString).collect(Collectors.joining(", ")) + ")";
    }

    public static class Function {
        public final String name;
        public final int arity;

        public Function(String name, int arity) {
            this.name = name;
            this.arity = arity;
        }
    }
}

