/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords;

import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.KeywordTokenList;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.VulnerabilityKeywords;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusConverter;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class KeywordSet
implements Comparable<KeywordSet> {
    private static final Logger LOG = LoggerFactory.getLogger(KeywordSet.class);
    private Double score;
    private String name;
    private String category;
    private String notes;
    private VulnerabilityStatus status;
    private final List<KeywordTokenList> mustContainAll = new ArrayList<KeywordTokenList>();
    private final List<KeywordTokenList> mustNotContain = new ArrayList<KeywordTokenList>();
    private final Map<List<KeywordTokenList>, Integer> minContain = new HashMap<List<KeywordTokenList>, Integer>();
    private final Map<List<KeywordTokenList>, Integer> maxContain = new HashMap<List<KeywordTokenList>, Integer>();
    public static final String KEY_NAME = "name";
    public static final String KEY_CATEGORY = "category";
    public static final String KEY_NOTES = "notes";
    public static final String KEY_SCORE = "score";
    private static final String KEY_MUST_CONTAIN_ALL = "all";
    private static final String KEY_MUST_NOT_CONTAIN = "none";
    private static final String KEY_MIN = "min";
    private static final String KEY_MAX = "max";
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_KEYWORDS = "keywords";
    private static final String KEY_COUNT = "count";
    private static final String KEY_STATUS = "status";
    private static final String KEY_KEYWORD_SETS = "sets";

    public KeywordSet(String name) {
        this.name = name;
    }

    public KeywordSet() {
    }

    public List<KeywordTokenList> getMustContainAll() {
        return this.mustContainAll;
    }

    public List<KeywordTokenList> getMustNotContain() {
        return this.mustNotContain;
    }

    public Map<List<KeywordTokenList>, Integer> getMaxContain() {
        return this.maxContain;
    }

    public Map<List<KeywordTokenList>, Integer> getMinContain() {
        return this.minContain;
    }

    public void putMaxContain(int count, String ... keywords) {
        this.maxContain.put(KeywordTokenList.fromMultipleStrings(keywords), count);
    }

    public void putMinContain(int count, String ... keywords) {
        this.minContain.put(KeywordTokenList.fromMultipleStrings(keywords), count);
    }

    public void addMustContainAll(String ... keywords) {
        this.mustContainAll.addAll(KeywordTokenList.fromMultipleStrings(keywords));
    }

    public void addMustNotContain(String ... keywords) {
        this.mustNotContain.addAll(KeywordTokenList.fromMultipleStrings(keywords));
    }

    public boolean matches(String text) {
        if (StringUtils.isEmpty(text)) {
            return false;
        }
        String effectiveText = text.toLowerCase(Locale.ROOT);
        KeywordTokenList effectiveTextTokenList = KeywordTokenList.fromString(effectiveText);
        return this.matches(effectiveTextTokenList);
    }

    public boolean matches(KeywordTokenList checkTokenList) {
        int actualCount;
        ArrayList<KeywordTokenList> mustNotContainCheck = new ArrayList<KeywordTokenList>(this.mustNotContain);
        mustNotContainCheck.removeIf(checkTokenList::containsInorder);
        if (mustNotContainCheck.size() != this.mustNotContain.size()) {
            return false;
        }
        ArrayList<KeywordTokenList> mustContainAllCheck = new ArrayList<KeywordTokenList>(this.mustContainAll);
        mustContainAllCheck.removeIf(checkTokenList::containsInorder);
        if (!mustContainAllCheck.isEmpty()) {
            return false;
        }
        HashMap<List<KeywordTokenList>, Integer> minContainCheck = new HashMap<List<KeywordTokenList>, Integer>();
        for (Map.Entry<List<KeywordTokenList>, Integer> entry : this.minContain.entrySet()) {
            actualCount = 0;
            for (KeywordTokenList keyword : entry.getKey()) {
                actualCount += checkTokenList.containsInorder(keyword) ? 1 : 0;
            }
            minContainCheck.put(entry.getKey(), actualCount);
        }
        for (Map.Entry<List<KeywordTokenList>, Integer> entry : this.minContain.entrySet()) {
            if ((Integer)minContainCheck.get(entry.getKey()) >= entry.getValue()) continue;
            return false;
        }
        HashMap<List<KeywordTokenList>, Integer> maxContainCheck = new HashMap<List<KeywordTokenList>, Integer>();
        for (Map.Entry<List<KeywordTokenList>, Integer> entry : this.maxContain.entrySet()) {
            actualCount = 0;
            for (KeywordTokenList keyword : entry.getKey()) {
                actualCount += checkTokenList.containsInorder(keyword) ? 1 : 0;
            }
            maxContainCheck.put(entry.getKey(), actualCount);
        }
        for (Map.Entry<List<KeywordTokenList>, Integer> entry : this.maxContain.entrySet()) {
            if ((Integer)maxContainCheck.get(entry.getKey()) <= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public Double getScore() {
        return this.score;
    }

    public boolean hasScore() {
        return this.score != null;
    }

    public String getNameScore() {
        if (this.score == null) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" (");
        if (this.score < 0.0) {
            sb.append("-");
        } else if (this.score > 0.0) {
            sb.append("+");
        }
        sb.append(this.score).append(")");
        return sb.toString();
    }

    public JSONObject toReducedInformationJson() {
        JSONObject exportJson = new JSONObject();
        if (this.score != null) {
            exportJson.put(KEY_SCORE, (Object)this.score);
        }
        if (this.name != null) {
            exportJson.put(KEY_NAME, (Object)this.name);
        }
        if (this.category != null) {
            exportJson.put(KEY_CATEGORY, (Object)this.category);
        }
        if (this.notes != null) {
            exportJson.put(KEY_NOTES, (Object)this.notes);
        }
        return exportJson;
    }

    public JSONObject toFullInformationJson() {
        JSONObject exportJson = this.toReducedInformationJson();
        exportJson.put(KEY_MUST_CONTAIN_ALL, (Object)this.mustContainAll.stream().map(KeywordTokenList::toJson).collect(CustomCollectors.toJsonArray()));
        exportJson.put(KEY_MUST_NOT_CONTAIN, (Object)this.mustNotContain.stream().map(KeywordTokenList::toJson).collect(CustomCollectors.toJsonArray()));
        JSONArray minJson = new JSONArray();
        for (Map.Entry<List<KeywordTokenList>, Integer> entry : this.minContain.entrySet()) {
            JSONObject minEntry = new JSONObject();
            minEntry.put(KEY_KEYWORDS, (Object)entry.getKey().stream().map(KeywordTokenList::toJson).collect(CustomCollectors.toJsonArray()));
            minEntry.put(KEY_COUNT, (Object)entry.getValue());
            minJson.put((Object)minEntry);
        }
        exportJson.put(KEY_MIN, (Object)minJson);
        JSONArray maxJson = new JSONArray();
        for (Map.Entry<List<KeywordTokenList>, Integer> entry : this.maxContain.entrySet()) {
            JSONObject maxEntry = new JSONObject();
            maxEntry.put(KEY_KEYWORDS, (Object)entry.getKey().stream().map(KeywordTokenList::toJson).collect(CustomCollectors.toJsonArray()));
            maxEntry.put(KEY_COUNT, (Object)entry.getValue());
            maxJson.put((Object)maxEntry);
        }
        exportJson.put(KEY_MAX, (Object)maxJson);
        return exportJson;
    }

    public static VulnerabilityKeywords fromJson(JSONArray json) {
        ArrayList<KeywordSet> keywordSets = new ArrayList<KeywordSet>();
        for (Object o : json) {
            if (!(o instanceof JSONObject)) continue;
            keywordSets.add(KeywordSet.fromJson((JSONObject)o));
        }
        return new VulnerabilityKeywords((List<KeywordSet>)keywordSets);
    }

    public static KeywordSet fromJson(JSONObject json) {
        return new KeywordSet().setProperties(json.toMap());
    }

    public static KeywordSet fromMap(Map<String, Object> properties) {
        return new KeywordSet().setProperties(properties);
    }

    public KeywordSet setProperties(Map<String, Object> properties) {
        if (this.notEmpty(properties.get(KEY_SCORE))) {
            Object scoreObject = properties.get(KEY_SCORE);
            if (scoreObject instanceof Number) {
                this.score = ((Number)scoreObject).doubleValue();
            } else if (scoreObject instanceof String) {
                try {
                    this.score = Double.parseDouble((String)scoreObject);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.notEmpty(properties.get(KEY_NAME))) {
            this.name = (String)properties.get(KEY_NAME);
        }
        if (this.notEmpty(properties.get(KEY_CATEGORY))) {
            this.category = (String)properties.get(KEY_CATEGORY);
        }
        if (this.notEmpty(properties.get(KEY_NOTES))) {
            this.notes = (String)properties.get(KEY_NOTES);
        }
        this.parseAllNoneTokensFromToJson(properties, KEY_MUST_CONTAIN_ALL, this.mustContainAll);
        this.parseAllNoneTokensFromToJson(properties, KEY_MUST_NOT_CONTAIN, this.mustNotContain);
        this.parseMinMaxTokensFromToJson(properties, KEY_MIN, this.minContain);
        this.parseMinMaxTokensFromToJson(properties, KEY_MAX, this.maxContain);
        return this;
    }

    private void parseAllNoneTokensFromToJson(Map<String, Object> properties, String keyMustContainAll, List<KeywordTokenList> mustContainAll) {
        Object mustContainAllObject;
        if (properties.containsKey(keyMustContainAll) && (mustContainAllObject = properties.get(keyMustContainAll)) instanceof List) {
            List mustContainAllList = (List)mustContainAllObject;
            for (Object entry : mustContainAllList) {
                if (!(entry instanceof List)) continue;
                List keywords = (List)entry;
                mustContainAll.add(new KeywordTokenList(keywords));
            }
        }
    }

    private void parseMinMaxTokensFromToJson(Map<String, Object> properties, String keyMax, Map<List<KeywordTokenList>, Integer> maxContain) {
        Object maxObject;
        if (properties.containsKey(keyMax) && (maxObject = properties.get(keyMax)) instanceof List) {
            List maxList = (List)maxObject;
            for (Object entry : maxList) {
                Map maxEntry;
                if (!(entry instanceof Map) || !(maxEntry = (Map)entry).containsKey(KEY_KEYWORDS) || !maxEntry.containsKey(KEY_COUNT)) continue;
                List keywords = (List)maxEntry.get(KEY_KEYWORDS);
                int count = Integer.parseInt(String.valueOf(maxEntry.get(KEY_COUNT)));
                ArrayList<KeywordTokenList> tokenList = new ArrayList<KeywordTokenList>();
                for (List keyword : keywords) {
                    tokenList.add(new KeywordTokenList(keyword));
                }
                maxContain.put(tokenList, count);
            }
        }
    }

    public VulnerabilityStatus getStatus() {
        return this.status;
    }

    @Override
    public int compareTo(KeywordSet o) {
        int cat = String.CASE_INSENSITIVE_ORDER.compare(o.category, this.category);
        if (cat != 0) {
            return cat;
        }
        if (o.score == null) {
            return 0;
        }
        return Double.compare(this.score, o.score);
    }

    private boolean notEmpty(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return StringUtils.notEmpty((String)o);
        }
        if (o instanceof Collection) {
            return !((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        return o instanceof Number;
    }

    public static JSONArray toReducedInformationJson(List<KeywordSet> keywordSets) {
        JSONArray exportJson = new JSONArray();
        for (KeywordSet keywordSet : keywordSets) {
            exportJson.put((Object)keywordSet.toReducedInformationJson());
        }
        return exportJson;
    }

    public static JSONArray toFullInformationJson(List<KeywordSet> keywordSets) {
        JSONArray exportJson = new JSONArray();
        for (KeywordSet keywordSet : keywordSets) {
            exportJson.put((Object)keywordSet.toFullInformationJson());
        }
        return exportJson;
    }

    public static List<KeywordSet> fromYamlFile(File file, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        if (file == null || !file.exists()) {
            LOG.warn("The vulnerability keywords file [{}] is null or does not exist", (Object)(file != null ? file.getAbsolutePath() : null));
            return new ArrayList<KeywordSet>();
        }
        if (file.isDirectory()) {
            ArrayList<KeywordSet> keywordSets = new ArrayList<KeywordSet>();
            for (File child : file.listFiles()) {
                if (!child.getName().endsWith(".yaml")) continue;
                keywordSets.addAll(KeywordSet.fromYamlFile(child, jsonSchemaValidationErrorsHandling));
            }
            return keywordSets;
        }
        if (!file.isFile()) {
            LOG.warn("The vulnerability keywords file [{}] is not a file", (Object)file.getAbsolutePath());
            return new ArrayList<KeywordSet>();
        }
        LOG.info("Reading keywords from file [{}]", (Object)file.getAbsolutePath());
        VulnerabilityKeywords.assertVulnerabilityKeywordsFileValid(file, jsonSchemaValidationErrorsHandling);
        try {
            Yaml yaml = new Yaml();
            LinkedHashMap mainKeywordStructure = (LinkedHashMap)yaml.load(Files.newInputStream(file.toPath(), new OpenOption[0]));
            if (mainKeywordStructure == null) {
                LOG.warn("Vulnerability keywords file content is empty [{}]", (Object)file.getAbsolutePath());
                return Collections.emptyList();
            }
            ArrayList<KeywordSet> parsedKeywordSets = new ArrayList<KeywordSet>();
            Object yamlSetsList = mainKeywordStructure.get(KEY_KEYWORD_SETS);
            if (yamlSetsList instanceof ArrayList) {
                ArrayList sets = (ArrayList)yamlSetsList;
                for (Object set : sets) {
                    if (!(set instanceof LinkedHashMap)) continue;
                    LinkedHashMap keywordSet = (LinkedHashMap)set;
                    parsedKeywordSets.add(KeywordSet.fromParsedYaml(keywordSet));
                }
            }
            return parsedKeywordSets;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading keyword file [" + file.getAbsolutePath() + "]", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse keywords from file [" + file.getAbsolutePath() + "]", e);
        }
    }

    public static KeywordSet fromParsedYaml(LinkedHashMap<String, Object> input) {
        List<KeywordTokenList> tokenList;
        List keywords;
        int amount;
        KeywordSet set = new KeywordSet();
        if (input.containsKey(KEY_SCORE)) {
            set.score = Double.parseDouble(input.get(KEY_SCORE) + "");
        }
        if (input.containsKey(KEY_NAME)) {
            set.name = input.get(KEY_NAME).toString();
        }
        if (input.containsKey(KEY_CATEGORY)) {
            set.category = input.get(KEY_CATEGORY).toString();
        }
        if (input.containsKey(KEY_NOTES)) {
            set.notes = input.get(KEY_NOTES).toString();
        }
        if (input.containsKey(KEY_MUST_CONTAIN_ALL)) {
            set.mustContainAll.addAll(KeywordTokenList.fromMultipleStrings((List)input.get(KEY_MUST_CONTAIN_ALL)));
        }
        if (input.containsKey(KEY_MUST_NOT_CONTAIN)) {
            set.mustNotContain.addAll(KeywordTokenList.fromMultipleStrings((List)input.get(KEY_MUST_NOT_CONTAIN)));
        }
        set.status = input.containsKey(KEY_STATUS) ? VulnerabilityStatusConverter.fromYaml((LinkedHashMap)input.get(KEY_STATUS)) : null;
        if (input.containsKey(KEY_MIN) && input.get(KEY_MIN) instanceof ArrayList) {
            ArrayList min = (ArrayList)input.get(KEY_MIN);
            for (Object minEntry : min) {
                LinkedHashMap minParameters;
                if (!(minEntry instanceof LinkedHashMap) || !(minParameters = (LinkedHashMap)minEntry).containsKey(KEY_AMOUNT) || !minParameters.containsKey(KEY_KEYWORDS)) continue;
                amount = Integer.parseInt(minParameters.get(KEY_AMOUNT) + "");
                keywords = (List)minParameters.get(KEY_KEYWORDS);
                tokenList = KeywordTokenList.fromMultipleStrings(keywords);
                set.minContain.put(tokenList, amount);
            }
        }
        if (input.containsKey(KEY_MAX) && input.get(KEY_MAX) instanceof ArrayList) {
            ArrayList max = (ArrayList)input.get(KEY_MAX);
            for (Object maxEntry : max) {
                LinkedHashMap maxParameters;
                if (!(maxEntry instanceof LinkedHashMap) || !(maxParameters = (LinkedHashMap)maxEntry).containsKey(KEY_AMOUNT) || !maxParameters.containsKey(KEY_KEYWORDS)) continue;
                amount = Integer.parseInt(maxParameters.get(KEY_AMOUNT) + "");
                keywords = (List)maxParameters.get(KEY_KEYWORDS);
                tokenList = KeywordTokenList.fromMultipleStrings(keywords);
                set.maxContain.put(tokenList, amount);
            }
        }
        return set;
    }

    public static List<KeywordSet> fromVulnerability(Vulnerability vulnerability) {
        ArrayList<KeywordSet> keywordSets = new ArrayList<KeywordSet>();
        String matchedKeywords = vulnerability.getAdditionalAttribute(InventoryAttribute.KEYWORDS);
        if (matchedKeywords != null) {
            try {
                JSONArray keywordsArray = new JSONArray(matchedKeywords);
                for (int i = 0; i < keywordsArray.length(); ++i) {
                    JSONObject keywordEntry = keywordsArray.optJSONObject(i);
                    if (keywordEntry == null) continue;
                    KeywordSet keywordSet = new KeywordSet();
                    keywordSet.setCategory(keywordEntry.optString(KEY_CATEGORY, null));
                    keywordSet.setScore(keywordEntry.has(KEY_SCORE) ? Double.valueOf(keywordEntry.optDouble(KEY_SCORE)) : null);
                    keywordSet.setName(keywordEntry.optString(KEY_NAME, null));
                    keywordSet.setNotes(keywordEntry.optString(KEY_NOTES, null));
                    keywordSets.add(keywordSet);
                }
            }
            catch (Exception e) {
                LOG.error("Unable to read keyword data: [{}]", (Object)matchedKeywords, (Object)e);
            }
        }
        return keywordSets;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setStatus(VulnerabilityStatus status) {
        this.status = status;
    }

    public String toString() {
        return "KeywordSet(score=" + this.getScore() + ", name=" + this.getName() + ", category=" + this.getCategory() + ", notes=" + this.getNotes() + ", status=" + this.getStatus() + ", mustContainAll=" + this.getMustContainAll() + ", mustNotContain=" + this.getMustNotContain() + ", minContain=" + this.getMinContain() + ", maxContain=" + this.getMaxContain() + ")";
    }
}

