/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.VulnerabilityKeywordTokenizerMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcher;
import org.json.JSONArray;

public class KeywordTokenList {
    public static final StringMatcher DEFAULT_TOKEN_MATCHER = new VulnerabilityKeywordTokenizerMatcher();
    private final String[] tokens;

    public KeywordTokenList(String[] tokens) {
        this.tokens = tokens;
    }

    public KeywordTokenList(Collection<String> tokens) {
        this.tokens = tokens.toArray(new String[0]);
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public boolean containsInorder(String text) {
        return this.containsInorder(KeywordTokenList.fromString(text));
    }

    public boolean containsInorder(KeywordTokenList checkTokens) {
        if (checkTokens == null || checkTokens.getTokens().length == 0) {
            return false;
        }
        int tokenIndex = 0;
        for (String token : this.tokens) {
            if (token.equals(checkTokens.getTokens()[tokenIndex])) {
                if (++tokenIndex != checkTokens.getTokens().length) continue;
                return true;
            }
            tokenIndex = 0;
        }
        return false;
    }

    public static KeywordTokenList fromString(String text) {
        return KeywordTokenList.fromString(text, DEFAULT_TOKEN_MATCHER);
    }

    public static KeywordTokenList fromString(String text, StringMatcher delim) {
        String effectiveText = text.toLowerCase(Locale.ROOT);
        StringTokenizer tokenizer = new StringTokenizer(effectiveText, delim);
        return new KeywordTokenList(tokenizer.getTokenArray());
    }

    public static List<KeywordTokenList> fromMultipleStrings(String ... strings) {
        return KeywordTokenList.fromMultipleStrings(Arrays.asList(strings));
    }

    public static List<KeywordTokenList> fromMultipleStrings(List<String> strings) {
        return KeywordTokenList.fromMultipleStrings(strings, DEFAULT_TOKEN_MATCHER);
    }

    public static List<KeywordTokenList> fromMultipleStrings(List<String> strings, StringMatcher delim) {
        return strings.stream().map(s -> KeywordTokenList.fromString(s, delim)).collect(Collectors.toList());
    }

    public String toString() {
        return "[" + String.join((CharSequence)", ", this.tokens) + "]";
    }

    public JSONArray toJson() {
        return new JSONArray(Arrays.asList(this.tokens));
    }

    public static KeywordTokenList fromJson(JSONArray jsonArray) {
        return new KeywordTokenList(jsonArray.toList().toArray(new String[0]));
    }
}

