/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords;

import com.metaeffekt.artifact.analysis.utils.JsonSchemaValidator;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.KeywordSet;
import com.networknt.schema.SpecVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilityKeywords {
    private final Logger LOG = LoggerFactory.getLogger(VulnerabilityKeywords.class);
    private final List<KeywordSet> keywordSets = new ArrayList<KeywordSet>();

    public VulnerabilityKeywords() {
    }

    public VulnerabilityKeywords(List<KeywordSet> keywords) {
        this.keywordSets.addAll(keywords);
    }

    public VulnerabilityKeywords(Collection<File> files) {
        files.forEach(file -> this.readFile((File)file, CentralSecurityPolicyConfiguration.JSON_SCHEMA_VALIDATION_ERRORS_DEFAULT));
    }

    public VulnerabilityKeywords(Collection<File> files, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        files.forEach(file -> this.readFile((File)file, jsonSchemaValidationErrorsHandling));
    }

    public void addKeywords(Collection<KeywordSet> keywords) {
        this.keywordSets.addAll(keywords);
    }

    public void addKeywords(KeywordSet ... keywords) {
        this.keywordSets.addAll(Arrays.asList(keywords));
    }

    public void readFile(File file, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        this.keywordSets.addAll(KeywordSet.fromYamlFile(file, jsonSchemaValidationErrorsHandling));
    }

    public static void assertVulnerabilityKeywordsFileValid(File file, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        JsonSchemaValidator.assertResourceSchemaAppliesToYamlFile(file, "specification/jsonschema/vulnerability-keywords.json", SpecVersion.VersionFlag.V201909, "Vulnerability Keywords YAML", jsonSchemaValidationErrorsHandling);
    }

    public List<KeywordSet> getMatching(String ... texts) {
        if (texts == null || texts.length == 0) {
            this.LOG.warn("No texts provided to check for matching keyword sets.");
            return new ArrayList<KeywordSet>();
        }
        ArrayList<KeywordSet> matchingKeywordSets = new ArrayList<KeywordSet>();
        String text = Arrays.stream(texts).filter(Objects::nonNull).collect(Collectors.joining(" "));
        for (KeywordSet checkKeywordSet : this.keywordSets) {
            if (!checkKeywordSet.matches(text)) continue;
            matchingKeywordSets.add(checkKeywordSet);
        }
        return matchingKeywordSets;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (KeywordSet keywordSet : this.keywordSets) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(keywordSet);
        }
        return stringBuilder.toString();
    }

    public Logger getLOG() {
        return this.LOG;
    }

    public List<KeywordSet> getKeywordSets() {
        return this.keywordSets;
    }
}

