/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import java.util.LinkedHashMap;
import java.util.List;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;

public class EolEnrichmentConfiguration
extends ProcessConfiguration {
    private int warningThresholdDaysSupport = 180;
    private int warningThresholdDaysExtendedSupport = 180;

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("warningThresholdDaysSupport", this.warningThresholdDaysSupport);
        properties.put("warningThresholdDaysExtendedSupport", this.warningThresholdDaysExtendedSupport);
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadIntegerProperty(properties, "warningThresholdDaysSupport", this::setWarningThresholdDaysSupport);
        super.loadIntegerProperty(properties, "warningThresholdDaysExtendedSupport", this::setWarningThresholdDaysExtendedSupport);
    }

    public EolEnrichmentConfiguration setWarningThresholdDaysSupport(int warningThresholdDaysSupport) {
        this.warningThresholdDaysSupport = warningThresholdDaysSupport;
        return this;
    }

    public int getWarningThresholdDaysSupport() {
        return this.warningThresholdDaysSupport;
    }

    public long getWarningThresholdMillisSupport() {
        return (long)this.warningThresholdDaysSupport * 24L * 60L * 60L * 1000L;
    }

    public EolEnrichmentConfiguration setWarningThresholdDaysExtendedSupport(int warningThresholdDaysExtendedSupport) {
        this.warningThresholdDaysExtendedSupport = warningThresholdDaysExtendedSupport;
        return this;
    }

    public int getWarningThresholdDaysExtendedSupport() {
        return this.warningThresholdDaysExtendedSupport;
    }

    public long getWarningThresholdMillisExtendedSupport() {
        return (long)this.warningThresholdDaysExtendedSupport * 24L * 60L * 60L * 1000L;
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        if (this.warningThresholdDaysSupport < 0) {
            misconfigurations.add(new ProcessMisconfiguration("warningThresholdDaysSupport", "must be >= 0"));
        }
        if (this.warningThresholdDaysExtendedSupport < 0) {
            misconfigurations.add(new ProcessMisconfiguration("warningThresholdDaysExtendedSupport", "must be >= 0"));
        }
    }
}

