/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaArtifactVulnerabilityMatcher;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaEcosystem;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers.NopGhsaMatcher;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;

public class GhsaVulnerabilitiesEnrichmentConfiguration
extends ProcessConfiguration {
    private boolean maven = false;
    private boolean packagist = false;
    private boolean rubygems = false;
    private boolean githubactions = false;
    private boolean pypi = false;
    private boolean purl_type_swift = false;
    private boolean go = false;
    private boolean hex = false;
    private boolean npm = false;
    private boolean crates_io = false;
    private boolean pub = false;
    private boolean nuget = false;
    private boolean githubReviewed = false;

    public boolean isMaven() {
        return this.maven;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setMaven(boolean maven) {
        this.maven = maven;
        return this;
    }

    public boolean isPackagist() {
        return this.packagist;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setPackagist(boolean packagist) {
        this.packagist = packagist;
        return this;
    }

    public boolean isRubygems() {
        return this.rubygems;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setRubygems(boolean rubygems) {
        this.rubygems = rubygems;
        return this;
    }

    public boolean isGithubactions() {
        return this.githubactions;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setGithubactions(boolean githubactions) {
        this.githubactions = githubactions;
        return this;
    }

    public boolean isPypi() {
        return this.pypi;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setPypi(boolean pypi) {
        this.pypi = pypi;
        return this;
    }

    public boolean isPurl_type_swift() {
        return this.purl_type_swift;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setPurl_type_swift(boolean purl_type_swift) {
        this.purl_type_swift = purl_type_swift;
        return this;
    }

    public boolean isGo() {
        return this.go;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setGo(boolean go) {
        this.go = go;
        return this;
    }

    public boolean isHex() {
        return this.hex;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setHex(boolean hex) {
        this.hex = hex;
        return this;
    }

    public boolean isNpm() {
        return this.npm;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setNpm(boolean npm) {
        this.npm = npm;
        return this;
    }

    public boolean isCrates_io() {
        return this.crates_io;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setCrates_io(boolean crates_io) {
        this.crates_io = crates_io;
        return this;
    }

    public boolean isPub() {
        return this.pub;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setPub(boolean pub) {
        this.pub = pub;
        return this;
    }

    public boolean isNuget() {
        return this.nuget;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setNuget(boolean nuget) {
        this.nuget = nuget;
        return this;
    }

    public boolean isGithubReviewed() {
        return this.githubReviewed;
    }

    public GhsaVulnerabilitiesEnrichmentConfiguration setGithubReviewed(boolean githubReviewed) {
        this.githubReviewed = githubReviewed;
        return this;
    }

    public List<GhsaEcosystem> getActivatedEcosystems() {
        ArrayList<GhsaEcosystem> activatedEcosystems = new ArrayList<GhsaEcosystem>();
        if (this.isMaven()) {
            activatedEcosystems.add(GhsaEcosystem.MAVEN);
        }
        if (this.isNpm()) {
            activatedEcosystems.add(GhsaEcosystem.NPM);
        }
        if (this.isPackagist()) {
            activatedEcosystems.add(GhsaEcosystem.PACKAGIST);
        }
        if (this.isRubygems()) {
            activatedEcosystems.add(GhsaEcosystem.RUBY_GEMS);
        }
        if (this.isGithubactions()) {
            activatedEcosystems.add(GhsaEcosystem.GIT_HUB_ACTIONS);
        }
        if (this.isPypi()) {
            activatedEcosystems.add(GhsaEcosystem.PY_PI);
        }
        if (this.isPurl_type_swift()) {
            activatedEcosystems.add(GhsaEcosystem.PURL_TYPE_SWIFT);
        }
        if (this.isGo()) {
            activatedEcosystems.add(GhsaEcosystem.GO);
        }
        if (this.isHex()) {
            activatedEcosystems.add(GhsaEcosystem.HEX);
        }
        if (this.isCrates_io()) {
            activatedEcosystems.add(GhsaEcosystem.CRATES_IO);
        }
        if (this.isPub()) {
            activatedEcosystems.add(GhsaEcosystem.PUB);
        }
        if (this.isNuget()) {
            activatedEcosystems.add(GhsaEcosystem.NU_GET);
        }
        return activatedEcosystems;
    }

    public List<GhsaArtifactVulnerabilityMatcher> buildMatchers(GhsaAdvisorIndexQuery ghsaQuery) {
        ArrayList<GhsaArtifactVulnerabilityMatcher> matchers = new ArrayList<GhsaArtifactVulnerabilityMatcher>();
        for (GhsaEcosystem ecosystem : this.getActivatedEcosystems()) {
            matchers.add((GhsaArtifactVulnerabilityMatcher)ecosystem.createInstance(ghsaQuery, this.githubReviewed));
        }
        return matchers;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("maven", this.maven);
        properties.put("packagist", this.packagist);
        properties.put("rubygems", this.rubygems);
        properties.put("githubactions", this.githubactions);
        properties.put("pypi", this.pypi);
        properties.put("purl_type_swift", this.purl_type_swift);
        properties.put("go", this.go);
        properties.put("hex", this.hex);
        properties.put("npm", this.npm);
        properties.put("crates_io", this.crates_io);
        properties.put("pub", this.pub);
        properties.put("nuget", this.nuget);
        properties.put("githubReviewed", this.githubReviewed);
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadBooleanProperty(properties, "maven", this::setMaven);
        super.loadBooleanProperty(properties, "packagist", this::setPackagist);
        super.loadBooleanProperty(properties, "rubygems", this::setRubygems);
        super.loadBooleanProperty(properties, "githubactions", this::setGithubactions);
        super.loadBooleanProperty(properties, "pypi", this::setPypi);
        super.loadBooleanProperty(properties, "purl_type_swift", this::setPurl_type_swift);
        super.loadBooleanProperty(properties, "go", this::setGo);
        super.loadBooleanProperty(properties, "hex", this::setHex);
        super.loadBooleanProperty(properties, "npm", this::setNpm);
        super.loadBooleanProperty(properties, "crates_io", this::setCrates_io);
        super.loadBooleanProperty(properties, "pub", this::setPub);
        super.loadBooleanProperty(properties, "nuget", this::setNuget);
        super.loadBooleanProperty(properties, "githubReviewed", this::setGithubReviewed);
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        for (GhsaEcosystem ecosystem : this.getActivatedEcosystems()) {
            if (ecosystem.getMatcherClass() != NopGhsaMatcher.class) continue;
            misconfigurations.add(new ProcessMisconfiguration("ecosystem", "[" + ecosystem.name() + "] ecosystem is not yet supported"));
        }
    }
}

