/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.details;

import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.details.DetailsFillingInventoryEnrichmentConfiguration;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DetailsFillingEnrichment<C extends DetailsFillingInventoryEnrichmentConfiguration<C>>
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(DetailsFillingEnrichment.class);
    protected C configuration;

    public C getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(C configuration) {
        this.configuration = configuration;
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        AtomicInteger appliedVulnerabilities = new AtomicInteger(0);
        AtomicInteger appliedAdvisories = new AtomicInteger(0);
        this.executor.setSize(16);
        for (Vulnerability vulnerability : vInventory.getShallowCopyVulnerabilities()) {
            if (!this.isApplicable(vulnerability)) continue;
            appliedVulnerabilities.incrementAndGet();
            this.executor.submit(() -> this.fillDetailsOnVulnerability(inventory, vInventory, vulnerability));
        }
        LOG.info("Starting vulnerability details filling on [{} / {}] vulnerabilities", (Object)appliedVulnerabilities.get(), (Object)vInventory.getVulnerabilities().size());
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for vulnerability details filling.", e);
        }
        for (AdvisoryEntry advisory : vInventory.getShallowCopySecurityAdvisories()) {
            if (!this.isApplicable(advisory)) continue;
            appliedAdvisories.incrementAndGet();
            this.executor.submit(() -> this.fillDetailsOnAdvisory(inventory, vInventory, advisory));
        }
        LOG.info("Starting advisory details filling on [{} / {}] advisories", (Object)appliedAdvisories.get(), (Object)vInventory.getSecurityAdvisories().size());
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for vulnerability details filling.", e);
        }
        vInventory.writeBack(true);
    }

    protected abstract boolean isApplicable(Vulnerability var1);

    protected abstract boolean isApplicable(AdvisoryEntry var1);

    protected abstract void fillDetailsOnVulnerability(Inventory var1, VulnerabilityContextInventory var2, Vulnerability var3);

    protected abstract void fillDetailsOnAdvisory(Inventory var1, VulnerabilityContextInventory var2, AdvisoryEntry var3);

    protected <T extends AdvisoryEntry> List<T> pickNonEmptyQueryResult(Supplier<T> selfInstanceSupplier, Supplier<List<T>> otherInstancesSupplier) {
        AdvisoryEntry selfInstance = (AdvisoryEntry)selfInstanceSupplier.get();
        if (selfInstance != null) {
            return Collections.singletonList(selfInstance);
        }
        List<T> otherInstances = otherInstancesSupplier.get();
        if (otherInstances == null || otherInstances.isEmpty()) {
            return Collections.emptyList();
        }
        return otherInstances;
    }
}

