/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.details;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.enrichment.configurations.details.DetailsFillingAdvisorCertFrInventoryEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.details.DetailsFillingEnrichment;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.advisory.CertFrAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.CertFrAdvisorIndexQuery;
import java.io.File;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="CERT-FR Advisor Details", phase=InventoryEnrichmentPhase.SECURITY_ADVISORY_MATCHING, intermediateFileSuffix="details-advisor-cert-fr", mavenPropertyName="certFrAdvisorEnrichment", explicitConfiguration=DetailsFillingAdvisorCertFrInventoryEnrichmentConfiguration.class)
public class DetailsFillingEnrichmentCertFr
extends DetailsFillingEnrichment<DetailsFillingAdvisorCertFrInventoryEnrichmentConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(DetailsFillingEnrichmentCertFr.class);
    private final LazySupplier<CertFrAdvisorIndexQuery> certFrAdvisorQuery = new LazySupplier<CertFrAdvisorIndexQuery>(() -> new CertFrAdvisorIndexQuery(baseMirrorDirectory));

    public DetailsFillingEnrichmentCertFr(File baseMirrorDirectory) {
        this.setConfiguration(new DetailsFillingAdvisorCertFrInventoryEnrichmentConfiguration());
    }

    @Override
    protected boolean isApplicable(Vulnerability vulnerability) {
        return !vulnerability.getRelatedAdvisorsTypes().contains(AdvisoryTypeStore.CERT_FR);
    }

    @Override
    protected boolean isApplicable(AdvisoryEntry advisory) {
        return advisory.getSourceIdentifier() == AdvisoryTypeStore.CERT_FR && StringUtils.isEmpty(advisory.getSummary()) && advisory.getDescription().isEmpty();
    }

    @Override
    protected void fillDetailsOnVulnerability(Inventory inventory, VulnerabilityContextInventory vInventory, Vulnerability queryVulnerability) {
        List advisorEntries = ((CertFrAdvisorIndexQuery)this.certFrAdvisorQuery.get()).findByReferencedId(queryVulnerability.getId());
        if (advisorEntries.isEmpty()) {
            return;
        }
        for (CertFrAdvisorEntry advisoryEntry : advisorEntries) {
            AdvisoryEntry constructedAdvisory = vInventory.findOrCreateAdvisoryEntryByName(advisoryEntry.getId(), CertFrAdvisorEntry::new);
            constructedAdvisory.addMatchingSource(DataSourceIndicator.vulnerability(queryVulnerability));
            queryVulnerability.addSecurityAdvisory(constructedAdvisory);
        }
    }

    @Override
    protected void fillDetailsOnAdvisory(Inventory inventory, VulnerabilityContextInventory vInventory, AdvisoryEntry queryAdvisory) {
        CertFrAdvisorEntry foundAdvisory = (CertFrAdvisorEntry)((CertFrAdvisorIndexQuery)this.certFrAdvisorQuery.get()).findById(queryAdvisory.getId());
        if (foundAdvisory != null) {
            queryAdvisory.appendFromDataClass(foundAdvisory);
        }
    }
}

