/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.details;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.enrichment.configurations.details.DetailsFillingAdvisorCertSeiInventoryEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.details.DetailsFillingEnrichment;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.advisory.CertSeiAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.CertSeiAdvisorIndexQuery;
import java.io.File;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="CERT-SEI Advisor Details", phase=InventoryEnrichmentPhase.SECURITY_ADVISORY_MATCHING, intermediateFileSuffix="details-advisor-cert-sei", mavenPropertyName="certSeiAdvisorEnrichment", explicitConfiguration=DetailsFillingAdvisorCertSeiInventoryEnrichmentConfiguration.class)
public class DetailsFillingEnrichmentCertSei
extends DetailsFillingEnrichment<DetailsFillingAdvisorCertSeiInventoryEnrichmentConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(DetailsFillingEnrichmentCertSei.class);
    private final LazySupplier<CertSeiAdvisorIndexQuery> certSeiAdvisorQuery = new LazySupplier<CertSeiAdvisorIndexQuery>(() -> new CertSeiAdvisorIndexQuery(baseMirrorDirectory));

    public DetailsFillingEnrichmentCertSei(File baseMirrorDirectory) {
        this.setConfiguration(new DetailsFillingAdvisorCertSeiInventoryEnrichmentConfiguration());
    }

    @Override
    protected boolean isApplicable(Vulnerability vulnerability) {
        return !vulnerability.getRelatedAdvisorsTypes().contains(AdvisoryTypeStore.CERT_SEI);
    }

    @Override
    protected boolean isApplicable(AdvisoryEntry advisory) {
        return advisory.getSourceIdentifier() == AdvisoryTypeStore.CERT_SEI && StringUtils.isEmpty(advisory.getSummary()) && advisory.getDescription().isEmpty();
    }

    @Override
    protected void fillDetailsOnVulnerability(Inventory inventory, VulnerabilityContextInventory vInventory, Vulnerability queryVulnerability) {
        List advisorEntries = ((CertSeiAdvisorIndexQuery)this.certSeiAdvisorQuery.get()).findByReferencedId(queryVulnerability.getId());
        if (advisorEntries.isEmpty()) {
            return;
        }
        for (CertSeiAdvisorEntry advisoryEntry : advisorEntries) {
            AdvisoryEntry constructedAdvisory = vInventory.findOrCreateAdvisoryEntryByName(advisoryEntry.getId(), CertSeiAdvisorEntry::new);
            constructedAdvisory.addMatchingSource(DataSourceIndicator.vulnerability(queryVulnerability));
            queryVulnerability.addSecurityAdvisory(constructedAdvisory);
        }
    }

    @Override
    protected void fillDetailsOnAdvisory(Inventory inventory, VulnerabilityContextInventory vInventory, AdvisoryEntry queryAdvisory) {
        CertSeiAdvisorEntry foundAdvisory = (CertSeiAdvisorEntry)((CertSeiAdvisorIndexQuery)this.certSeiAdvisorQuery.get()).findById(queryAdvisory.getId());
        if (foundAdvisory != null) {
            queryAdvisory.appendFromDataClass(foundAdvisory);
        }
    }
}

