/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.details;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.enrichment.configurations.CustomVulnerabilitiesDetailsFillingEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.details.DetailsFillingEnrichment;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.CustomVulnerabilityIndexQuery;
import java.io.File;
import java.util.Optional;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Custom Vulnerability Details", phase=InventoryEnrichmentPhase.VULNERABILITY_DETAILS_FILLING, intermediateFileSuffix="details-vulnerability-custom", mavenPropertyName="customVulnerabilitiesFillDetailsEnrichment", explicitConfiguration=CustomVulnerabilitiesDetailsFillingEnrichmentConfiguration.class)
public class DetailsFillingEnrichmentCustom
extends DetailsFillingEnrichment<CustomVulnerabilitiesDetailsFillingEnrichmentConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(DetailsFillingEnrichmentCustom.class);
    protected CustomVulnerabilityIndexQuery vulnerabilityQuery;
    private CustomVulnerabilitiesDetailsFillingEnrichmentConfiguration configuration = new CustomVulnerabilitiesDetailsFillingEnrichmentConfiguration();

    public DetailsFillingEnrichmentCustom(File baseMirrorDirectory) {
    }

    @Override
    public void performEnrichment(Inventory inventory) {
        this.vulnerabilityQuery = new CustomVulnerabilityIndexQuery(this.getConfiguration().getVulnerabilityFiles());
        super.performEnrichment(inventory);
    }

    @Override
    public void setConfiguration(CustomVulnerabilitiesDetailsFillingEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public CustomVulnerabilitiesDetailsFillingEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isApplicable(Vulnerability vulnerability) {
        return StringUtils.isEmpty(vulnerability.getDescription());
    }

    @Override
    protected boolean isApplicable(AdvisoryEntry advisory) {
        return false;
    }

    @Override
    protected void fillDetailsOnVulnerability(Inventory inventory, VulnerabilityContextInventory vInventory, Vulnerability queryVulnerability) {
        Optional<Vulnerability> potentialDbVulnerability = this.vulnerabilityQuery.findVulnerabilityByName(queryVulnerability.getId());
        if (!potentialDbVulnerability.isPresent()) {
            if (!String.valueOf(queryVulnerability.getId()).startsWith("ADV")) {
                LOG.warn("Custom Vulnerability [{}] not found", (Object)queryVulnerability.getId());
            }
        } else {
            Vulnerability dbVulnerability = potentialDbVulnerability.get();
            queryVulnerability.appendFromDataClass(dbVulnerability);
        }
    }

    @Override
    protected void fillDetailsOnAdvisory(Inventory inventory, VulnerabilityContextInventory vInventory, AdvisoryEntry queryAdvisory) {
    }
}

