/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.details;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.enrichment.configurations.details.DetailsFillingGhsaInventoryEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.details.DetailsFillingEnrichment;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.advisory.GhsaAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;
import java.io.File;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="GHSA Vulnerability Details", phase=InventoryEnrichmentPhase.SECURITY_ADVISORY_MATCHING, intermediateFileSuffix="details-vulnerability-ghsa", mavenPropertyName="ghsaAdvisorFillDetailsEnrichment", explicitConfiguration=DetailsFillingGhsaInventoryEnrichmentConfiguration.class)
public class DetailsFillingEnrichmentGhsa
extends DetailsFillingEnrichment<DetailsFillingGhsaInventoryEnrichmentConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(DetailsFillingEnrichmentGhsa.class);
    private final LazySupplier<GhsaAdvisorIndexQuery> ghsaAdvisorIndexQuery;

    public DetailsFillingEnrichmentGhsa(File baseMirrorDirectory) {
        this.setConfiguration(new DetailsFillingGhsaInventoryEnrichmentConfiguration());
        this.ghsaAdvisorIndexQuery = new LazySupplier<GhsaAdvisorIndexQuery>(() -> new GhsaAdvisorIndexQuery(baseMirrorDirectory));
    }

    @Override
    protected boolean isApplicable(Vulnerability vulnerability) {
        String name = vulnerability.getId();
        if (!AdvisoryTypeStore.GHSA.patternMatchesId(name) && !VulnerabilityTypeStore.CVE.patternMatchesId(name)) {
            return false;
        }
        return !vulnerability.getRelatedAdvisorsTypes().contains(AdvisoryTypeStore.GHSA);
    }

    @Override
    protected boolean isApplicable(AdvisoryEntry advisory) {
        return advisory.getSourceIdentifier() == AdvisoryTypeStore.GHSA && StringUtils.isEmpty(advisory.getSummary()) && advisory.getDescription().isEmpty();
    }

    @Override
    protected void fillDetailsOnVulnerability(Inventory inventory, VulnerabilityContextInventory vInventory, Vulnerability queryVulnerability) {
        List<GhsaAdvisorEntry> advisorEntries = super.pickNonEmptyQueryResult(() -> (GhsaAdvisorEntry)((GhsaAdvisorIndexQuery)this.ghsaAdvisorIndexQuery.get()).findById(queryVulnerability.getId()), () -> ((GhsaAdvisorIndexQuery)this.ghsaAdvisorIndexQuery.get()).findByReferencedId(queryVulnerability.getId()));
        if (advisorEntries.isEmpty()) {
            return;
        }
        for (GhsaAdvisorEntry advisoryEntry : advisorEntries) {
            AdvisoryEntry constructedAdvisory = vInventory.findOrCreateAdvisoryEntryByName(advisoryEntry.getId(), GhsaAdvisorEntry::new);
            constructedAdvisory.addMatchingSource(DataSourceIndicator.vulnerability(queryVulnerability));
            queryVulnerability.addSecurityAdvisory(constructedAdvisory);
        }
    }

    @Override
    protected void fillDetailsOnAdvisory(Inventory inventory, VulnerabilityContextInventory vInventory, AdvisoryEntry queryAdvisory) {
        GhsaAdvisorEntry foundAdvisory = (GhsaAdvisorEntry)((GhsaAdvisorIndexQuery)this.ghsaAdvisorIndexQuery.get()).findById(queryAdvisory.getId());
        if (foundAdvisory != null) {
            queryAdvisory.appendFromDataClass(foundAdvisory);
        }
    }
}

