/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.matching;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.enrichment.configurations.NvdFromCpeCveFromCpeEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.matching.VulnerabilitiesFromCpeEnrichment;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.NvdCveIndexQuery;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="NVD CVE from CPE", phase=InventoryEnrichmentPhase.VULNERABILITY_MATCHING, intermediateFileSuffix="nvd-cve-from-cpe", mavenPropertyName="nvdMatchCveFromCpeEnrichment")
public class NvdVulnerabilitiesFromCpeEnrichment
extends VulnerabilitiesFromCpeEnrichment {
    private static final Logger log = LoggerFactory.getLogger(NvdVulnerabilitiesFromCpeEnrichment.class);
    protected LazySupplier<NvdCveIndexQuery> vulnerabilityQuery = new LazySupplier<NvdCveIndexQuery>(() -> new NvdCveIndexQuery(baseMirrorDirectory));

    public NvdVulnerabilitiesFromCpeEnrichment(File baseMirrorDirectory) {
        super(new NvdFromCpeCveFromCpeEnrichmentConfiguration());
    }

    @Override
    public NvdFromCpeCveFromCpeEnrichmentConfiguration getConfiguration() {
        return (NvdFromCpeCveFromCpeEnrichmentConfiguration)this.configuration;
    }

    @Override
    protected NvdCveIndexQuery getVulnerabilityQuery() {
        return (NvdCveIndexQuery)this.vulnerabilityQuery.get();
    }

    @Override
    protected VulnerabilityTypeIdentifier<?> getVulnerabilitySource() {
        return VulnerabilityTypeStore.CVE;
    }

    @Override
    @DocRelevantMethods(value={"VulnerabilitiesFromCpeEnrichment#enrichVulnerabilitiesForCpe", "VulnerabilitiesFromCpeEnrichment#queryVulnerabilitiesForArtifact"})
    protected void performEnrichment(Inventory inventory) {
        AtomicInteger progress = new AtomicInteger(0);
        List artifacts = inventory.getArtifacts();
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        for (Artifact artifact : artifacts) {
            this.executor.submit(() -> {
                int currentElement = progress.incrementAndGet();
                if (currentElement % 100 == 0 && currentElement > 0) {
                    log.info("Collecting CVE from CPE for artifact [{} / {}]", (Object)currentElement, (Object)inventory.getArtifacts().size());
                }
                super.enrichVulnerabilitiesForCpe(vInventory, artifact);
            });
        }
        this.executor.setSize(16);
        this.executor.setLogEveryPercent(10);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to join executor while waiting for NVD CVE from CPE enrichment to finish.", e);
        }
        vInventory.writeBack();
    }
}

