/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.EolEnrichmentConfiguration;
import com.metaeffekt.mirror.contents.eol.EolCycle;
import com.metaeffekt.mirror.contents.eol.EolLifecycle;
import com.metaeffekt.mirror.contents.eol.export.CycleStateScenario;
import com.metaeffekt.mirror.contents.eol.export.ExportedCycleState;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.EolIndexQuery;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONArray;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="EOL Date", phase=InventoryEnrichmentPhase.VULNERABILITY_PRIORITIZATION, intermediateFileSuffix="eol-date", mavenPropertyName="eolEnrichment")
public class EolEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(EolEnrichment.class);
    private EolEnrichmentConfiguration configuration = new EolEnrichmentConfiguration();
    private final EolIndexQuery eolIndexQuery;

    public EolEnrichment(File baseMirrorDirectory) {
        this.eolIndexQuery = new EolIndexQuery(baseMirrorDirectory);
    }

    @Override
    public EolEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @DocRelevantMethods(value={"EolEnrichment#performEnrichmentOnSingleArtifact"})
    protected void performEnrichment(Inventory inventory) {
        int count = 0;
        HashMap<String, Set<EolCycle>> matchedEolCyclesTracker = new HashMap<String, Set<EolCycle>>();
        for (Artifact artifact : inventory.getArtifacts()) {
            Map<String, Set<EolCycle>> result = this.performEnrichmentOnSingleArtifact(artifact);
            if (result == null) continue;
            matchedEolCyclesTracker.putAll(result);
            ++count;
        }
        LOG.info("Added EOL Information to [{}] artifacts for products: {}", (Object)count, (Object)matchedEolCyclesTracker.entrySet().stream().map(e -> (String)e.getKey() + " (" + ((Set)e.getValue()).stream().map(EolCycle::getCycle).collect(Collectors.joining(", ")) + ")").collect(Collectors.joining(", ")));
    }

    public Map<String, Set<EolCycle>> performEnrichmentOnSingleArtifact(Artifact artifact) {
        if (!artifact.has(InventoryAttribute.EOL_ID.getKey())) {
            return null;
        }
        String[] eolIds = artifact.get(InventoryAttribute.EOL_ID.getKey()).split(", ");
        HashMap<String, Set<EolCycle>> matchedEolCyclesTracker = new HashMap<String, Set<EolCycle>>();
        for (String eolId : eolIds) {
            EolLifecycle lifecycle = this.eolIndexQuery.findCyclesByProduct(eolId);
            if (lifecycle == null || lifecycle.getCycles().isEmpty()) {
                LOG.warn("No EOL information found for product: {}", (Object)eolId);
                continue;
            }
            String cycleQueryVersion = (String)ObjectUtils.firstNonNull((Object[])new String[]{artifact.get((AbstractModelBase.Attribute)InventoryAttribute.EOL_OVERWRITE_CYCLE_QUERY_VERSION), artifact.get(Artifact.Attribute.VERSION)});
            String latestVersionQueryVersion = (String)ObjectUtils.firstNonNull((Object[])new String[]{artifact.get((AbstractModelBase.Attribute)InventoryAttribute.EOL_OVERWRITE_LATEST_VERSION_QUERY_VERSION), artifact.get(Artifact.Attribute.VERSION)});
            EolCycle currentCycle = lifecycle.findCycleFromVersion(cycleQueryVersion);
            if (currentCycle == null) {
                if (cycleQueryVersion == null) {
                    LOG.warn("Lifecycle found for product [{}], artifact query version [{}] [{}] is null on artifact [{}]", new Object[]{eolId, cycleQueryVersion, latestVersionQueryVersion, artifact.get(Artifact.Attribute.ID)});
                    continue;
                }
                LOG.warn("Lifecycle found for product [{}], artifact query version [{}] [{}] on artifact [{}] cannot be found in cycle data", new Object[]{eolId, cycleQueryVersion, latestVersionQueryVersion, artifact.get(Artifact.Attribute.ID)});
                continue;
            }
            this.performEnrichmentOnArtifactAndCycle(lifecycle, artifact, currentCycle, latestVersionQueryVersion);
            matchedEolCyclesTracker.computeIfAbsent(eolId, k -> new HashSet()).add(currentCycle);
        }
        return matchedEolCyclesTracker;
    }

    private void performEnrichmentOnArtifactAndCycle(EolLifecycle lifecycle, Artifact artifact, EolCycle cycle, String latestVersionQueryVersion) {
        ExportedCycleState state = ExportedCycleState.from(cycle, artifact, latestVersionQueryVersion, lifecycle, this.configuration.getWarningThresholdMillisSupport(), this.configuration.getWarningThresholdMillisExtendedSupport());
        if (StringUtils.isEmpty(artifact.get(InventoryAttribute.EOL_FULL_STATE.getKey()))) {
            artifact.set(InventoryAttribute.EOL_FULL_STATE.getKey(), new JSONArray().put((Object)state.toJson()).toString());
        } else {
            JSONArray existing = new JSONArray(artifact.get(InventoryAttribute.EOL_FULL_STATE.getKey()));
            existing.put((Object)state.toJson());
            artifact.set(InventoryAttribute.EOL_FULL_STATE.getKey(), existing.toString());
        }
        artifact.set(InventoryAttribute.EOL_RECOMMENDED_CYCLE_VERSION.getKey(), state.getLatestCycleVersion());
        artifact.set(InventoryAttribute.EOL_RECOMMENDED_LIFECYCLE_VERSION.getKey(), state.getLatestLifecycleVersion());
        artifact.set(InventoryAttribute.EOL_RECOMMENDED_NEXT_SUPPORTED_VERSION.getKey(), state.getNextSupportedVersion());
        artifact.set(InventoryAttribute.EOL_RECOMMENDED_NEXT_SUPPORTED_EXTENDED_VERSION.getKey(), state.getNextSupportedExtendedVersion());
        artifact.set(InventoryAttribute.EOL_RECOMMENDED_CLOSEST_SUPPORTED_LTS_VERSION.getKey(), state.getClosestActiveLtsVersion());
        artifact.set(InventoryAttribute.EOL_RECOMMENDED_LATEST_SUPPORTED_LTS_VERSION.getKey(), state.getLatestActiveLtsVersion());
        artifact.set(InventoryAttribute.EOL_IS_EOL.getKey(), String.valueOf(state.isEol()));
        artifact.set(InventoryAttribute.EOL_IS_SUPPORTED.getKey(), String.valueOf(state.isSupport()));
        artifact.set(InventoryAttribute.EOL_IS_SUPPORTED_EXTENDED.getKey(), String.valueOf(state.isExtendedSupport()));
        artifact.set(InventoryAttribute.EOL_RATING.getKey(), String.valueOf(state.getCycleStateScenario() == CycleStateScenario.EXTENDED_SUPPORT_NOT_PRESENT ? state.getCycleStateExtendedSupportUnavailable().getRating().getRating() : state.getCycleStateExtendedSupportAvailable().getRating().getRating()));
    }

    public void setConfiguration(EolEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }
}

