/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.validation.validators;

import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.validation.VulnerabilityInventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.reason.InventoryValidationReason;
import com.metaeffekt.artifact.enrichment.validation.reason.ReasonIdentifier;
import com.metaeffekt.mirror.query.NvdCpeApiIndexQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

public class ArtifactAndCpeVersionsDifferGreatlyInventoryValidator
extends VulnerabilityInventoryValidator {
    private static final Logger log = LoggerFactory.getLogger(ArtifactAndCpeVersionsDifferGreatlyInventoryValidator.class);
    private NvdCpeApiIndexQuery nvdCpeApiIndexQuery;

    @Override
    public void beforeValidation(File baseMirrorDirectory) {
        super.beforeValidation(baseMirrorDirectory);
        this.nvdCpeApiIndexQuery = new NvdCpeApiIndexQuery(baseMirrorDirectory);
    }

    @Override
    public List<InventoryValidationReason> validate(Inventory inventory, VulnerabilityMetaData vmd) {
        ArrayList<InventoryValidationReason> validationFailReasons = new ArrayList<InventoryValidationReason>();
        if (this.nvdCpeApiIndexQuery == null) {
            log.warn("NVD CPE API index query is not initialized, will use only the versions known on the data.");
        }
        List<Artifact> artifacts = this.getArtifacts(inventory, vmd);
        List<Cpe> cpes = CommonEnumerationUtil.parseCpe((AbstractModelBase)vmd, VulnerabilityMetaData.Attribute.PRODUCT_URIS.getKey());
        HashMap<Cpe, List> allCpeVersions = new HashMap<Cpe, List>();
        for (Cpe cpe2 : cpes) {
            List<Cpe> versionedCpes = this.nvdCpeApiIndexQuery == null ? Collections.singletonList(cpe2) : this.nvdCpeApiIndexQuery.findByCpeUri(cpe2);
            Set cpeVersions = versionedCpes.stream().map(Cpe::getVersion).collect(Collectors.toSet());
            List cpeMajorVersions = cpeVersions.stream().map(this::extractMajorVersion).filter(Objects::nonNull).sorted(this::majorVersionComparator).distinct().collect(Collectors.toList());
            allCpeVersions.computeIfAbsent(this.buildCacheCpe(cpe2), k -> new ArrayList()).addAll(cpeMajorVersions);
        }
        for (Artifact artifact : artifacts) {
            String artifactVersion = artifact.getVersion();
            String artifactMajorVersion = this.extractMajorVersion(artifactVersion);
            if (artifactMajorVersion == null) continue;
            List<Cpe> artifactCpes = CommonEnumerationUtil.parseCpe((AbstractModelBase)artifact, InventoryAttribute.MATCHED_CPES.getKey());
            LinkedHashSet<String> failedArtifactVersions = new LinkedHashSet<String>();
            LinkedHashSet<Cpe> failedArtifactCpes = new LinkedHashSet<Cpe>();
            for (Cpe cpe3 : cpes) {
                boolean artifactCpeContainsCpe = false;
                for (Cpe artifactCpe : artifactCpes) {
                    if (!Objects.equals(artifactCpe.getVendor(), cpe3.getVendor()) || !Objects.equals(artifactCpe.getProduct(), cpe3.getProduct()) || !Objects.equals(artifactCpe.getPart(), cpe3.getPart())) continue;
                    artifactCpeContainsCpe = true;
                    break;
                }
                if (!artifactCpeContainsCpe) continue;
                List cpeMajorVersions = (List)allCpeVersions.get(this.buildCacheCpe(cpe3));
                if (cpeMajorVersions == null) {
                    log.warn("No CPE major versions found for CPE [{}], even though it was matched by artifact [{}] with major version [{}]", new Object[]{cpe3, artifact.getId(), artifactMajorVersion});
                    continue;
                }
                if (cpeMajorVersions.contains(artifactMajorVersion) || cpeMajorVersions.size() == 1 && cpeMajorVersions.contains("*")) continue;
                failedArtifactVersions.add(artifactMajorVersion);
                failedArtifactCpes.add(cpe3);
            }
            if (failedArtifactVersions.isEmpty()) continue;
            String failedArtifactCpesString = failedArtifactCpes.stream().map(cpe -> CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(cpe) + " " + allCpeVersions.get(cpe)).collect(Collectors.joining(", "));
            validationFailReasons.add(new InventoryValidationReason((AbstractModelBase)vmd, ReasonIdentifier.ARTIFACT_AND_CPE_VERSIONS_DIFFER_GREATLY, "Artifact [" + artifact.getId() + "] with major version [" + artifactMajorVersion + "] is not present in any CPE major version: " + failedArtifactCpesString));
        }
        return validationFailReasons;
    }

    private Cpe buildCacheCpe(Cpe cpe) {
        try {
            return CommonEnumerationUtil.builder().from(cpe).keepOnlyPartVendorProduct().build();
        }
        catch (CpeValidationException e) {
            log.warn("Failed to build key CPE for CPE [{}], using itself instead of part:v:p-only CPE: {}", (Object)cpe, (Object)e.getMessage());
            return cpe;
        }
    }

    private int majorVersionComparator(String cpe1, String cpe2) {
        int cpe1Int = this.numericalCompareVersion(cpe1);
        int cpe2Int = this.numericalCompareVersion(cpe2);
        return Integer.compare(cpe1Int, cpe2Int);
    }

    private int numericalCompareVersion(String cpe2) {
        if (cpe2.equals("*")) {
            return Integer.MIN_VALUE;
        }
        if (cpe2.equals("-")) {
            return -2147483647;
        }
        try {
            return Integer.parseInt(cpe2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private List<Artifact> getArtifacts(Inventory inventory, VulnerabilityMetaData vmd) {
        return inventory.getArtifacts().stream().filter(artifact -> InventoryEnricher.splitVulnerabilitiesCsv(artifact.getVulnerability()).contains(vmd.get(VulnerabilityMetaData.Attribute.NAME))).collect(Collectors.toList());
    }

    private String extractMajorVersion(String version) {
        return version != null ? version.split("\\.")[0] : null;
    }

    @Override
    public String getValidatorName() {
        return "Artifact and CPE versions differ greatly";
    }

    @Override
    public LinkedHashMap<String, Object> getProperties() {
        return super.getProperties();
    }

    @Override
    public void setProperties(LinkedHashMap<String, Object> properties) {
    }
}

