/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.validation.validators;

import com.metaeffekt.artifact.enrichment.validation.VulnerabilityInventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.reason.InventoryValidationReason;
import com.metaeffekt.artifact.enrichment.validation.reason.ReasonIdentifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;

public class VulnerabilityInvalidNameValidator
extends VulnerabilityInventoryValidator {
    @Override
    public List<InventoryValidationReason> validate(Inventory inventory, VulnerabilityMetaData vmd) {
        ArrayList<InventoryValidationReason> reasons = new ArrayList<InventoryValidationReason>();
        if (this.containsIllegalCharacter(vmd.get(VulnerabilityMetaData.Attribute.NAME))) {
            reasons.add(new InventoryValidationReason(ReasonIdentifier.VULNERABILITY_CONTAINS_ILLEGAL_CHARACTER, "Vulnerability [" + vmd.get(VulnerabilityMetaData.Attribute.NAME) + "] contains illegal character"));
        }
        return reasons;
    }

    private boolean containsIllegalCharacter(String name) {
        return name.contains(" ");
    }

    @Override
    public String getValidatorName() {
        return "Vulnerability invalid name";
    }

    @Override
    public void setProperties(LinkedHashMap<String, Object> properties) {
    }
}

