/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.KeywordSet;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.VulnerabilityKeywords;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.VulnerabilityKeywordsEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.other.vad.VulnerabilityAssessmentDashboard;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Vulnerability Keywords", phase=InventoryEnrichmentPhase.ASSESSMENTS, intermediateFileSuffix="vulnerability-keywords", mavenPropertyName="vulnerabilityKeywordsEnrichment")
public class VulnerabilityKeywordsEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityKeywordsEnrichment.class);
    private VulnerabilityKeywordsEnrichmentConfiguration configuration = new VulnerabilityKeywordsEnrichmentConfiguration();

    public void setConfiguration(VulnerabilityKeywordsEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public VulnerabilityKeywordsEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        LOG.info("Performing enrichment using [{}] yaml file{}", (Object)this.configuration.getYamlFiles().size(), (Object)(this.configuration.getYamlFiles().size() == 1 ? "" : "s"));
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        VulnerabilityKeywords keywords = this.configuration.makeKeywords(super.getSecurityPolicyConfiguration().getJsonSchemaValidationErrorsHandling());
        for (Vulnerability vulnerability : vInventory.getVulnerabilities()) {
            List<KeywordSet> matchingKeywords = keywords.getMatching(vulnerability.getDescription(), String.join((CharSequence)", ", vulnerability.getCwes()));
            if (matchingKeywords.isEmpty()) continue;
            LOG.debug("[{}] matches [{}] keyword(s): {}", new Object[]{vulnerability.getId(), matchingKeywords.size(), matchingKeywords.stream().map(KeywordSet::getNameScore).collect(Collectors.joining(", "))});
            boolean anyKeywordSetHasScore = matchingKeywords.stream().anyMatch(KeywordSet::hasScore);
            Double totalKeywordsScore = anyKeywordSetHasScore ? Double.valueOf(matchingKeywords.stream().filter(KeywordSet::hasScore).mapToDouble(KeywordSet::getScore).sum()) : null;
            vulnerability.setAdditionalAttribute(InventoryAttribute.KEYWORDS_SCORE, totalKeywordsScore != null ? String.valueOf(VulnerabilityAssessmentDashboard.roundOneDecimal(totalKeywordsScore)) : null);
            JSONArray keywordsArray = KeywordSet.toFullInformationJson(matchingKeywords);
            vulnerability.setAdditionalAttribute(InventoryAttribute.KEYWORDS, keywordsArray.toString());
            VulnerabilityStatus status = this.findApplicableStatusFromKeywordSets(matchingKeywords);
            if (status == null) continue;
            status.appendToVulnerabilityStatus(vulnerability.getOrCreateNewVulnerabilityStatus(), this.configuration.getActiveLabels());
            vulnerability.getVulnerabilityStatus().applyToVulnerability(vulnerability);
        }
        vInventory.writeBack(true);
    }

    private VulnerabilityStatus findApplicableStatusFromKeywordSets(List<KeywordSet> keywords) {
        VulnerabilityStatus status;
        List keywordsWithStatus = keywords.stream().filter(e -> e.getStatus() != null).collect(Collectors.toList());
        if (keywordsWithStatus.size() > 1) {
            status = keywordsWithStatus.stream().map(KeywordSet::getStatus).findFirst().orElse(null);
            LOG.warn("Matched keywords contain [{}] vulnerability statuses, picking random entry [{}]", (Object)keywordsWithStatus.size(), (Object)status);
        } else {
            status = keywordsWithStatus.size() == 1 ? ((KeywordSet)keywordsWithStatus.get(0)).getStatus() : null;
        }
        return status;
    }
}

