/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability;

import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.VulnerabilityStatusEnrichmentConfiguration;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.InventoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Vulnerability Status", phase=InventoryEnrichmentPhase.ASSESSMENTS, intermediateFileSuffix="status", mavenPropertyName="vulnerabilityStatusEnrichment")
public class VulnerabilityStatusEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityStatusEnrichment.class);
    private VulnerabilityStatusEnrichmentConfiguration configuration = new VulnerabilityStatusEnrichmentConfiguration();

    public void setConfiguration(VulnerabilityStatusEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public VulnerabilityStatusEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performEnrichment(Inventory inventory) {
        boolean logMatchingCriteriaPreviousValue = VulnerabilityStatus.LOG_MATCHING_CRITERIA;
        VulnerabilityStatus.LOG_MATCHING_CRITERIA = this.configuration.isDebugMatchingCriteria();
        try {
            Set<VulnerabilityStatus> anyScopeStatus;
            LOG.info("");
            if (!this.configuration.getStatusFiles().isEmpty()) {
                LOG.info("Adding data from status files from:");
                this.configuration.getStatusFiles().stream().map(File::getAbsolutePath).map(f -> " - " + f).forEach(arg_0 -> ((Logger)LOG).info(arg_0));
            }
            if (!this.configuration.getAdditionalStatus().isEmpty()) {
                LOG.info("Adding data from [{}] additional status entries added programmatically", (Object)this.configuration.getAdditionalStatus().size());
            }
            if ((anyScopeStatus = this.configuration.readVulnerabilityStatusEntries(super.getSecurityPolicyConfiguration().getJsonSchemaValidationErrorsHandling())).isEmpty()) {
                LOG.info("No status files found in provided directories");
            } else {
                Map<String, List<VulnerabilityStatus>> scopeStatusMap = anyScopeStatus.stream().collect(Collectors.groupingBy(s -> s.getOriginYamlFile() == null ? "programmatic" : s.getOriginYamlFile().getAbsolutePath()));
                for (Map.Entry<String, List<VulnerabilityStatus>> entry : scopeStatusMap.entrySet()) {
                    List<VulnerabilityStatus> statuses = entry.getValue();
                    String filePath = entry.getKey();
                    LOG.info("Found [{}] ({}) status file{} in file: {}", new Object[]{statuses.size(), statuses.stream().map(VulnerabilityStatus::getScope).distinct().map(Enum::toString).collect(Collectors.joining(", ")), statuses.size() == 1 ? "" : "s", filePath});
                }
            }
            LOG.info("");
            VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
            int vulnerabilityCountBefore = vInventory.getVulnerabilities().size();
            List<VulnerabilityStatus> inventoryScopeStatus = anyScopeStatus.stream().filter(s -> s.isScope(VulnerabilityStatus.Scope.INVENTORY)).collect(Collectors.toList());
            List<VulnerabilityStatus> artifactScopeStatus = anyScopeStatus.stream().filter(s -> s.isScope(VulnerabilityStatus.Scope.ARTIFACT)).collect(Collectors.toList());
            if (!inventoryScopeStatus.isEmpty()) {
                LOG.info("Found [{}] status file{} with scope [{}]", new Object[]{inventoryScopeStatus.size(), inventoryScopeStatus.size() == 1 ? "" : "s", VulnerabilityStatus.Scope.INVENTORY});
                for (Vulnerability vulnerability : vInventory.getVulnerabilities()) {
                    this.addStatusEntriesForVulnerability(vInventory, inventoryScopeStatus, vulnerability, false);
                }
                InventoryInfo info = vInventory.getInventory().findOrCreateInventoryInfo("vulnerability-status");
                Iterator<Object> statusJson = inventoryScopeStatus.stream().map(VulnerabilityStatus::toJson).collect(CustomCollectors.toJsonArray());
                if (info.has("Vulnerability Inventory Status")) {
                    JSONArray jSONArray = new JSONArray(info.get("Vulnerability Inventory Status"));
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        statusJson.put(jSONArray.get(i));
                    }
                }
                info.set("Vulnerability Inventory Status", statusJson.toString());
            }
            HashMap<Vulnerability, File> createdVulnerabilitySources = new HashMap<Vulnerability, File>();
            for (VulnerabilityStatus vulnerabilityStatus : anyScopeStatus) {
                for (String name : vulnerabilityStatus.getAffectedVulnerabilitiesWithoutWildcards()) {
                    if (vInventory.findVulnerabilityByName(name).isPresent()) continue;
                    Vulnerability vulnerability = vInventory.findOrCreateVulnerabilityByName(name);
                    VulnerabilityTypeStore.get().inferSourceIdentifierFromIdIfAbsent(vulnerability);
                    createdVulnerabilitySources.put(vulnerability, vulnerabilityStatus.getOriginYamlFile());
                }
            }
            for (Map.Entry entry : createdVulnerabilitySources.entrySet()) {
                Vulnerability vulnerability = (Vulnerability)entry.getKey();
                File file = (File)entry.getValue();
                vulnerability.addMatchingSource(DataSourceIndicator.assessmentStatus(file));
            }
            int vulnerabilityCountAfter = vInventory.getVulnerabilities().size();
            LOG.info("Found [{}] status files with a total of [{}] affected vulnerabilities, applying to an inventory with [{}] vulnerabilities (merged & deduplicated total: [{}])", new Object[]{anyScopeStatus.size(), vulnerabilityCountAfter - vulnerabilityCountBefore, vulnerabilityCountBefore, vulnerabilityCountAfter});
            for (Vulnerability vulnerability : vInventory.getVulnerabilities()) {
                this.addStatusEntriesForVulnerability(vInventory, artifactScopeStatus, vulnerability, createdVulnerabilitySources.containsKey(vulnerability));
            }
            vInventory.writeBack(true);
        }
        finally {
            VulnerabilityStatus.LOG_MATCHING_CRITERIA = logMatchingCriteriaPreviousValue;
        }
    }

    private void addStatusEntriesForVulnerability(VulnerabilityContextInventory vInventory, Collection<VulnerabilityStatus> allVulnerabilityStatuses, Vulnerability vulnerability, boolean vulnerabilityHasBeenCreatedByStatus) {
        VulnerabilityTypeStore.get().inferSourceIdentifierFromIdIfAbsent(vulnerability);
        if (vulnerabilityHasBeenCreatedByStatus) {
            vulnerability.addTag("added by status");
            LOG.info("Added [{}] to the inventory via status file", (Object)vulnerability);
        }
        Map<VulnerabilityStatus.MatchType, List<VulnerabilityStatus>> vulnerabilityStatuses = VulnerabilityStatus.findAffectedEntriesRetainMatchingCondition(allVulnerabilityStatuses, vulnerability);
        List<VulnerabilityStatus> highestPriorityStatuses = VulnerabilityStatus.MatchType.findHighestPriority(vulnerabilityStatuses);
        VulnerabilityStatusEnrichment.modifyVulnerabilityStatusHistoryEntryDateBasedOnMatchType(vulnerabilityStatuses, true);
        List<String> activeLabels = Arrays.asList(this.configuration.getActiveLabels());
        if (!vulnerabilityStatuses.isEmpty()) {
            for (Map.Entry<VulnerabilityStatus.MatchType, List<VulnerabilityStatus>> match : vulnerabilityStatuses.entrySet()) {
                VulnerabilityStatus.MatchType matchType = match.getKey();
                List<VulnerabilityStatus> affectedStatusEntries = match.getValue();
                boolean isHighestPriorityStatusEntries = highestPriorityStatuses == affectedStatusEntries;
                affectedStatusEntries.forEach(affectedStatusEntry -> affectedStatusEntry.checkValidation(vInventory.getInventory(), vulnerability, this.configuration.isFailOnValidationErrors()));
                for (VulnerabilityStatus affectedStatusEntry2 : affectedStatusEntries) {
                    if (vulnerabilityHasBeenCreatedByStatus) {
                        affectedStatusEntry2.addHistoryEntry(VulnerabilityStatusHistoryEntry.VOID);
                    }
                    affectedStatusEntry2.appendStatusHistoryOnlyToVulnerabilityStatus(vulnerability.getOrCreateNewVulnerabilityStatus(), activeLabels);
                    if (!vulnerabilityHasBeenCreatedByStatus) continue;
                    affectedStatusEntry2.removeHistoryEntry(VulnerabilityStatusHistoryEntry.VOID);
                }
                if (!isHighestPriorityStatusEntries) continue;
                if (affectedStatusEntries.size() != 1) {
                    LOG.warn("Multiple status entries match for [{}] on criteria level [{}], picking arbitrary: [{}]. Please check file(s) [{}]", new Object[]{vulnerability.getId(), matchType, affectedStatusEntries.get(0).getOriginYamlFile().getAbsolutePath(), affectedStatusEntries.stream().map(VulnerabilityStatus::getOriginYamlFile).filter(Objects::nonNull).map(File::getAbsolutePath).collect(Collectors.joining(", "))});
                    if (this.configuration.isFailOnAmbiguousMatchingInformation()) {
                        throw new IllegalStateException("[failOnAmbiguousMatchingInformation] Ambiguous assessment matching information found for vulnerability [" + vulnerability.getId() + "] on criteria level [" + (Object)((Object)matchType) + "] from files:\n - " + affectedStatusEntries.stream().map(VulnerabilityStatus::getOriginYamlFile).filter(Objects::nonNull).map(File::getAbsolutePath).collect(Collectors.joining("\n - ")));
                    }
                }
                affectedStatusEntries.get(0).appendAllExceptStatusHistoryToVulnerabilityStatus(vulnerability.getOrCreateNewVulnerabilityStatus());
            }
        } else if (vulnerabilityHasBeenCreatedByStatus) {
            VulnerabilityStatus voidStatus = new VulnerabilityStatus();
            voidStatus.addHistoryEntry(VulnerabilityStatusHistoryEntry.VOID);
            voidStatus.appendToVulnerabilityStatus(vulnerability.getOrCreateNewVulnerabilityStatus(), activeLabels);
        }
        if (vulnerability.getVulnerabilityStatus() != null) {
            vulnerability.getVulnerabilityStatus().applyToVulnerability(vulnerability);
        }
        VulnerabilityStatusEnrichment.modifyVulnerabilityStatusHistoryEntryDateBasedOnMatchType(vulnerabilityStatuses, false);
    }

    private static void modifyVulnerabilityStatusHistoryEntryDateBasedOnMatchType(Map<VulnerabilityStatus.MatchType, List<VulnerabilityStatus>> vulnerabilityStatuses, boolean add) {
        for (Map.Entry<VulnerabilityStatus.MatchType, List<VulnerabilityStatus>> match : vulnerabilityStatuses.entrySet()) {
            VulnerabilityStatus.MatchType matchType = match.getKey();
            int addition = VulnerabilityStatus.MatchType.values().length - matchType.ordinal();
            for (VulnerabilityStatus status : match.getValue()) {
                for (VulnerabilityStatusHistoryEntry historyEntry : status.getStatusHistory()) {
                    if (historyEntry.getDate() == null) continue;
                    historyEntry.setDate(new Date(historyEntry.getDate().getTime() + (long)(add ? addition : -addition)));
                }
            }
        }
    }
}

