/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.VulnerabilityStatusPostProcessingEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.vulnerability.VulnerabilityStatusPostProcessor;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;
import com.metaeffekt.mirror.query.MsrcProductIndexQuery;
import java.io.File;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Vulnerability Status Post Processing", phase=InventoryEnrichmentPhase.INVENTORY_POST_PROCESSING, intermediateFileSuffix="status-post-processed", mavenPropertyName="vulnerabilityStatusPostProcessingEnrichment")
public class VulnerabilityStatusPostProcessingEnrichment
extends InventoryEnricher {
    private static final Logger log = LoggerFactory.getLogger(VulnerabilityStatusPostProcessingEnrichment.class);
    private VulnerabilityStatusPostProcessingEnrichmentConfiguration configuration = new VulnerabilityStatusPostProcessingEnrichmentConfiguration();
    private final LazySupplier<MsrcProductIndexQuery> msrcProductIndexQuery = new LazySupplier<MsrcProductIndexQuery>(() -> new MsrcProductIndexQuery(baseMirrorDirectory));
    private final LazySupplier<GhsaAdvisorIndexQuery> ghsaAdvisorIndexQuery = new LazySupplier<GhsaAdvisorIndexQuery>(() -> new GhsaAdvisorIndexQuery(baseMirrorDirectory));

    public VulnerabilityStatusPostProcessingEnrichment(File baseMirrorDirectory) {
    }

    @Override
    public VulnerabilityStatusPostProcessingEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        VulnerabilityStatusPostProcessor processor = new VulnerabilityStatusPostProcessor();
        processor.setMsrcProductIndexQuery(this.msrcProductIndexQuery);
        processor.setGhsaAdvisorIndexQuery(this.ghsaAdvisorIndexQuery);
        for (Vulnerability vulnerability : vInventory.getVulnerabilities()) {
            VulnerabilityStatus assessmentStatus = vulnerability.getVulnerabilityStatus();
            if (assessmentStatus == null) continue;
            for (VulnerabilityStatusHistoryEntry historyEntry : assessmentStatus.getStatusHistory()) {
                processor.resolveVariablesHandler(vInventory, vulnerability, historyEntry.getMeasures(), historyEntry::setMeasures);
                processor.resolveVariablesHandler(vInventory, vulnerability, historyEntry.getRisk(), historyEntry::setRisk);
                processor.resolveVariablesHandler(vInventory, vulnerability, historyEntry.getRationale(), historyEntry::setRationale);
                processor.resolveVariablesHandler(vInventory, vulnerability, historyEntry.getAuthor(), historyEntry::setAuthor);
            }
            processor.resolveVariablesHandler(vInventory, vulnerability, assessmentStatus.getReportedDate(), assessmentStatus::setReportedDate);
        }
        vInventory.writeBack(true);
    }

    public void setConfiguration(VulnerabilityStatusPostProcessingEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }
}

