/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms.model;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringStats;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.FileSegment;
import com.metaeffekt.artifact.terms.model.MatchPreprocessor;
import com.metaeffekt.artifact.terms.model.MatchSequence;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSegmentation {
    private static final Logger LOG = LoggerFactory.getLogger(FileSegmentation.class);
    final List<FileSegment> fileSegments = new ArrayList<FileSegment>();
    private final MatchPreprocessor matchPreprocessor;

    public FileSegmentation(String fileContent, NormalizationMetaData normalizationMetaData) {
        this.matchPreprocessor = new MatchPreprocessor(normalizationMetaData);
        String markedFileContent = FileSegmentation.preprocessForSegmentation(fileContent, this.matchPreprocessor);
        try {
            List<String> markedFileSegments = this.matchPreprocessor.applySegments(markedFileContent);
            for (String markedSegmentContent : markedFileSegments) {
                this.fileSegments.add(new FileSegment(markedSegmentContent, this.matchPreprocessor));
            }
        }
        catch (Throwable e) {
            LOG.info("Cannot apply segments.");
        }
        try {
            this.postProcessSegments(this.matchPreprocessor, normalizationMetaData);
        }
        catch (Throwable e) {
            LOG.info("Cannot post-process segments.", e);
        }
    }

    public static String preprocessForSegmentation(String fileContent, MatchPreprocessor matchPreprocessor) {
        try {
            fileContent = matchPreprocessor.getNormalizationMetaData().applyMappings(fileContent);
        }
        catch (Throwable e) {
            LOG.info("Cannot apply mappings.");
        }
        return fileContent;
    }

    protected void postProcessSegments(MatchPreprocessor matchPreprocessor, NormalizationMetaData normalizationMetaData) {
        this.fileSegments.removeIf(segment -> StringUtils.isEmpty(segment.getNormalizedContent().getNormalizedString()));
        block0: for (int i = 0; i < this.fileSegments.size() - 1; ++i) {
            if (this.fileSegments.get(i).getNormalizedContent().getNormalizedString().trim().isEmpty()) continue;
            FileSegment currentFileSegment = this.fileSegments.get(i);
            FileSegment nextFileSegment = this.fileSegments.get(i + 1);
            StringStats current = currentFileSegment.getNormalizedContent();
            StringStats next = nextFileSegment.getNormalizedContent();
            boolean merged = false;
            for (TermsMetaData lmd : normalizationMetaData.getLicenseMetaDataMap().values()) {
                if (lmd.getSegmentation() != null) {
                    for (MatchSequence ms : lmd.getSegmentation().getRevert()) {
                        boolean matchMatched = false;
                        boolean matchNextMatched = false;
                        if (ms.getMatch() == null) {
                            matchMatched = true;
                        } else {
                            for (int match : this.matches(ms.getMatch(), current)) {
                                StringStats matchStats = StringStats.normalize(ms.getMatch(), false);
                                if (match != current.getNormalizedString().length() - matchStats.getNormalizedString().length()) continue;
                                matchMatched = true;
                                break;
                            }
                        }
                        if (ms.getMatchNext() == null) {
                            matchNextMatched = true;
                        } else {
                            for (int match : this.matches(ms.getMatchNext(), next)) {
                                if (match != 0) continue;
                                matchNextMatched = true;
                                break;
                            }
                        }
                        if (!matchMatched || !matchNextMatched) continue;
                        FileSegment mergedFileSegment = new FileSegment(currentFileSegment.getMarkedContent().trim() + " " + nextFileSegment.getMarkedContent().trim(), matchPreprocessor);
                        this.fileSegments.set(i, mergedFileSegment);
                        this.fileSegments.remove(i + 1);
                        --i;
                        merged = true;
                        break;
                    }
                }
                if (!merged) continue;
                continue block0;
            }
        }
    }

    protected int[] matches(String match, StringStats content) {
        return content.allMatches(StringStats.normalize(match, true));
    }

    public FileSegment getFileSegment(int index) {
        return this.fileSegments.get(index);
    }

    public int getSegmentCount() {
        return this.fileSegments.size();
    }

    public StringBuilder getSegmentsString() {
        StringBuilder sb = new StringBuilder();
        for (FileSegment fileSegment : this.fileSegments) {
            sb.append(String.format("SEGMENT-START-----------------------------%n", new Object[0]));
            sb.append(fileSegment.getContent());
            sb.append(String.format("%nSEGMENT-END-------------------------------%n", new Object[0]));
        }
        return sb;
    }

    public StringBuilder getMarkedSegmentsString() {
        StringBuilder sb = new StringBuilder();
        for (FileSegment fileSegment : this.fileSegments) {
            sb.append(String.format("SEGMENT-START-----------------------------%n", new Object[0]));
            sb.append(fileSegment.getMarkedContent());
            sb.append(String.format("%nSEGMENT-END-------------------------------%n", new Object[0]));
        }
        return sb;
    }

    public List<FileSegment> combineSegmentsAndWriteFoldersForScancode(File targetFolder) throws IOException {
        int i = 0;
        List<FileSegment> fileSegments = this.combineSegments();
        for (FileSegment fileSegment : fileSegments) {
            String fileName = "segment-" + i + ".txt";
            File file = new File(targetFolder, fileName);
            FileUtils.write((File)file, (CharSequence)fileSegment.getContent(), (Charset)StandardCharsets.UTF_8);
            ++i;
        }
        return fileSegments;
    }

    private List<FileSegment> combineSegments() {
        ArrayList<FileSegment> combinedFileSegments = new ArrayList<FileSegment>();
        ArrayList<FileSegment> temporaryFileSegments = new ArrayList<FileSegment>();
        for (FileSegment fileSegment : this.fileSegments) {
            if (fileSegment.getNormalizedSRP().getMatchedTerms().isEmpty()) {
                temporaryFileSegments.add(fileSegment);
                continue;
            }
            combinedFileSegments.add(this.mergeFileSegments(temporaryFileSegments));
            temporaryFileSegments.clear();
            combinedFileSegments.add(fileSegment);
        }
        combinedFileSegments.add(this.mergeFileSegments(temporaryFileSegments));
        combinedFileSegments.removeIf(combinedFileSegment -> combinedFileSegment.getContent().isEmpty());
        return combinedFileSegments;
    }

    private FileSegment mergeFileSegments(List<FileSegment> temporaryFileSegments) {
        StringBuilder content = new StringBuilder();
        for (FileSegment fileSegment : temporaryFileSegments) {
            content.append(" ").append(fileSegment.getContent());
        }
        return new FileSegment(content.toString(), this.matchPreprocessor);
    }

    public StringStats mergeSegmentedText() {
        StringBuilder orig = new StringBuilder();
        StringBuilder normalized = new StringBuilder();
        for (FileSegment fileSegment : this.fileSegments) {
            orig.append(fileSegment.getMarkedContent());
            orig.append("SEGMENT-MARKER");
            normalized.append(fileSegment.getNormalizedContent().getNormalizedString());
        }
        StringStats result = StringStats.normalize(orig.toString(), false);
        result.update(normalized.toString().replaceAll("\\s+", " "));
        return result;
    }

    public List<FileSegment> getFileSegments() {
        return this.fileSegments;
    }
}

