/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms.model;

import com.metaeffekt.artifact.analysis.preprocess.filter.wordlist.WordlistGenerator;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringStats;
import com.metaeffekt.artifact.terms.model.Reference;
import com.metaeffekt.artifact.terms.model.ScanResultPart;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.LicenseData;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class NormalizationMetaData
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(NormalizationMetaData.class);
    public static final String STRING_WHITESPACE = " ";
    public static final String PREFIX_LICENSE_REF = "LicenseRef-";
    public static final String ORDER_DEFAULT = "999";
    private final Map<String, String> licenseNameMap = new HashMap<String, String>();
    private final Map<String, String> categoryNameMap = new HashMap<String, String>();
    private final Map<String, TermsMetaData> licenseMetaDataMap = new HashMap<String, TermsMetaData>();
    private transient Map<String, TermsMetaData> shortNameMap = new HashMap<String, TermsMetaData>();
    private transient Map<String, TermsMetaData> spdxIdentifierMap = new HashMap<String, TermsMetaData>();
    private transient Map<String, Map<Pattern, String>> mappingMap;
    private transient Map<String, String> historicalCanonicalNameMap = null;
    private transient Set<String> normalizedMasks = null;
    public static final NormalizationMetaData EMPTY_NORMALIZATION_METADATA = new NormalizationMetaData();
    private List<String> wordlist = new ArrayList<String>();

    public NormalizationMetaData(File baseDir) {
        LOG.info("Reading Terms Database [" + this.getCanonicalPath(baseDir) + "]...");
        this.readFromFileSystem(baseDir);
        this.processExternalMetaData(baseDir);
        this.preprocess();
        LOG.info("Reading Terms Database [" + this.getCanonicalPath(baseDir) + "] completed.");
    }

    private NormalizationMetaData() {
    }

    private String getCanonicalPath(File baseDir) {
        try {
            return baseDir.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            return baseDir.getAbsolutePath();
        }
    }

    public void generateAndSetWordlist() {
        HashMap<String, TermsMetaData> filteredTermsMetaDataMap = new HashMap<String, TermsMetaData>(this.getLicenseMetaDataMap());
        for (Map.Entry<String, TermsMetaData> e : this.getLicenseMetaDataMap().entrySet()) {
            if (!e.getValue().isCustomerMetaData()) continue;
            filteredTermsMetaDataMap.remove(e.getKey());
        }
        try {
            this.wordlist = WordlistGenerator.createWordlist(filteredTermsMetaDataMap);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to generate wordlist for termsMetaData.");
        }
    }

    private void processExternalMetaData(File baseDir) {
        File openCodeConfigDir = new File(baseDir, "_external/opencode");
        if (openCodeConfigDir.exists()) {
            this.processOpenCoDEApprovedInputFile(new File(openCodeConfigDir, "approved-licenses.txt"), false);
            this.processOpenCoDEApprovedInputFile(new File(openCodeConfigDir, "approved-licenses_pwc.txt"), true);
            this.processOpenCoDEApprovedInputFile(new File(openCodeConfigDir, "approved-licenses_ae.txt"), true);
            this.processOpenCoDENotApprovedInputFile(new File(openCodeConfigDir, "not-approved-licenses.txt"));
        }
        for (TermsMetaData tmd : this.licenseMetaDataMap.values()) {
            TermsMetaData representedAsTmd;
            String baseTerms = tmd.getBaseTerms();
            if (baseTerms == null || tmd.getOpenCoDEStatus() != null || (representedAsTmd = this.findTermsMetaData(baseTerms)) == null) continue;
            tmd.setOpenCoDEStatus(representedAsTmd.getOpenCoDEStatus());
        }
        File osiConfigDir = new File(baseDir, "_external/osi");
        if (osiConfigDir.exists()) {
            File osiLicenseStatus = new File(osiConfigDir, "osi-license-status.xls");
            if (osiLicenseStatus.exists()) {
                try {
                    this.processOsiLicenseStatus(osiLicenseStatus);
                }
                catch (IOException exception) {
                    LOG.error("Cannot parse OSI license status information.", (Throwable)exception);
                }
            } else {
                LOG.warn("Cannot parse OSI license status information. File [{}] does not exist.", (Object)osiLicenseStatus);
            }
        }
    }

    private void processOpenCoDENotApprovedInputFile(File openCodeNotApprovedLicenses) {
        if (openCodeNotApprovedLicenses.exists()) {
            try {
                this.processOpenCoDENotApproved(openCodeNotApprovedLicenses);
            }
            catch (IOException exception) {
                LOG.error("Cannot parse Open CoDE not approved licenses.", (Throwable)exception);
            }
        } else {
            LOG.warn("Cannot parse Open CoDE not approved licenses. File [{}] does not exist.", (Object)openCodeNotApprovedLicenses);
        }
    }

    private void processOpenCoDEApprovedInputFile(File openCodeApprovedLicenses, boolean similarLicenseMapping) {
        if (openCodeApprovedLicenses.exists()) {
            try {
                this.processOpenCoDEApproved(openCodeApprovedLicenses, similarLicenseMapping);
            }
            catch (IOException exception) {
                LOG.error("Cannot parse Open CoDE approved licenses.", (Throwable)exception);
            }
        } else {
            LOG.warn("Cannot parse Open CoDE approved licenses. File [{}] does not exist.", (Object)openCodeApprovedLicenses);
        }
    }

    private void processOsiLicenseStatus(File osiLicenseStatus) throws IOException {
        Inventory inventory = new InventoryReader().readInventory(osiLicenseStatus);
        for (LicenseData licenseData : inventory.getLicenseData()) {
            String canonicalName = licenseData.get(LicenseData.Attribute.CANONICAL_NAME);
            TermsMetaData termsMetaData = this.getTermsMetaData(canonicalName);
            if (termsMetaData == null) {
                if ("x".equalsIgnoreCase(licenseData.get("License Missing"))) continue;
                LOG.warn("Cannot find TermsMetaData for [" + canonicalName + "].");
                continue;
            }
            String osiLicenseId = licenseData.get("OSI License Id");
            String osiSupersededBy = licenseData.get("OSI Superseded-by Id");
            String osiStatus = licenseData.get("OSI Status");
            String osiCategory = licenseData.get("OSI Category");
            String osiRationale = licenseData.get("OSI Rationale");
            String tmdOsiId = termsMetaData.getOtherId("osi");
            if (com.metaeffekt.artifact.analysis.utils.StringUtils.notEmpty(tmdOsiId) && !tmdOsiId.equals(osiLicenseId)) {
                LOG.warn("OSI license ids inconsistent for [" + canonicalName + "].");
            }
            if ("approved".equalsIgnoreCase(osiStatus) && com.metaeffekt.artifact.analysis.utils.StringUtils.isEmpty(tmdOsiId)) {
                LOG.warn("Approved OSI licenses must carry an OSI id. Check [" + canonicalName + "].");
            }
            termsMetaData.setOsiStatus(osiStatus);
            termsMetaData.setOsiRationale(osiRationale);
            termsMetaData.setOsiCategory(osiCategory);
            termsMetaData.setOsiSupersededBy(osiSupersededBy);
        }
    }

    private void processOpenCoDEApproved(File openCodeApprovedLicenses, boolean similarLicenseMapping) throws IOException {
        List lines = FileUtils.readLines((File)openCodeApprovedLicenses, (String)"UTF-8");
        for (String line : lines) {
            TermsMetaData termsMetaData;
            String licenseShortId;
            String licenseName;
            if (line.startsWith("#")) continue;
            String[] split = line.split("\t");
            if (!similarLicenseMapping) {
                if (split.length == 4) {
                    licenseName = split[0];
                    licenseShortId = split[1];
                    termsMetaData = this.findByOpenCodeLicenseId(licenseShortId);
                    if (termsMetaData != null) {
                        termsMetaData.setOpenCoDEStatus("approved");
                        continue;
                    }
                    LOG.warn("No terms metadata for Open CoDE license ['{}' ({})].", (Object)licenseName, (Object)licenseShortId);
                    continue;
                }
                LOG.error("Cannot parse Open CoDE license data: " + line);
                continue;
            }
            if (split.length == 2) {
                licenseName = split[0];
                licenseShortId = split[1];
                termsMetaData = this.getTermsMetaData(licenseName);
                if (termsMetaData != null) {
                    TermsMetaData similarTmd = this.findByOpenCodeLicenseId(licenseShortId);
                    if (similarTmd == null) {
                        LOG.warn("Cannot find similar license [{}].", (Object)licenseShortId);
                    }
                    if (com.metaeffekt.artifact.analysis.utils.StringUtils.hasText(termsMetaData.getOpenCoDEStatus())) continue;
                    termsMetaData.setOpenCoDEStatus("(approved)");
                    termsMetaData.setOpenCoDESimilarLicenseId(licenseShortId);
                    if (similarTmd.isOpenCodeApproved()) continue;
                    LOG.warn("Inconsistency detected. Using similar license to derive implicit Open CoDE approval for [{}], but similar license [{}] not approved.", (Object)licenseName, (Object)licenseShortId);
                    continue;
                }
                LOG.warn("No terms metadata for canonical names [{}].", (Object)licenseName);
                continue;
            }
            LOG.error("Cannot parse Open CoDE license data: " + line);
        }
    }

    private TermsMetaData findByOpenCodeLicenseId(String openCodeLicenseId) {
        if (openCodeLicenseId.startsWith(PREFIX_LICENSE_REF)) {
            String otherId = openCodeLicenseId.replace(PREFIX_LICENSE_REF, "").replaceFirst("-", ":");
            return this.findByOtherId(otherId);
        }
        TermsMetaData termsMetaData = this.findBySpdxIdentifier(openCodeLicenseId);
        if (termsMetaData == null) {
            termsMetaData = this.findByShortName(openCodeLicenseId);
        }
        return termsMetaData;
    }

    private TermsMetaData findByOtherId(String otherId) {
        TermsMetaData tmd = null;
        for (TermsMetaData termsMetaData : this.licenseMetaDataMap.values()) {
            List<String> otherIds = termsMetaData.getOtherIds();
            if (otherIds == null || !otherIds.contains(otherId)) continue;
            tmd = termsMetaData;
            break;
        }
        return tmd;
    }

    public void processOpenCoDENotApproved(File openCodeNotApprovedLicenses) throws IOException {
        List lines = FileUtils.readLines((File)openCodeNotApprovedLicenses, (String)"UTF-8");
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            String[] split = line.split("\t");
            if (split.length == 4) {
                String licenseName = split[0];
                String licenseShortId = split[1];
                TermsMetaData termsMetaData = this.findByOpenCodeLicenseId(licenseShortId);
                if (termsMetaData != null) {
                    termsMetaData.setOpenCoDEStatus("not approved");
                    continue;
                }
                LOG.warn("No terms metadata for Open CoDE license [{} ({})].", (Object)licenseName, (Object)licenseShortId);
                continue;
            }
            LOG.error("Cannot parse Open CoDE license data: " + line);
        }
    }

    private void preprocess() {
        for (TermsMetaData licenseMetaData : this.licenseMetaDataMap.values()) {
            Map<String, Reference> references = licenseMetaData.getReferences();
            if (references == null) continue;
            for (String licenseReference : references.keySet()) {
                for (TermsMetaData candidate : this.licenseMetaDataMap.values()) {
                    if (!candidate.getCategory().equals(licenseReference) && !candidate.getCanonicalName().equals(licenseReference)) continue;
                    Reference reference = references.get(licenseReference);
                    candidate.addReference(reference);
                }
            }
        }
    }

    private void readFromFileSystem(File baseDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        scanner.setIncludes(new String[]{"**/license.meta.yaml"});
        scanner.setExcludes(new String[]{"**/.meta/**/*"});
        scanner.scan();
        for (String path : scanner.getIncludedFiles()) {
            File file = new File(baseDir, path);
            try {
                File readmeDir;
                String yamlContent = FileUtils.readFileToString((File)file, (String)"UTF-8");
                Yaml yaml = new Yaml();
                TermsMetaData licenseMetaData = (TermsMetaData)yaml.loadAs(yamlContent, TermsMetaData.class);
                licenseMetaData.setNormalizationMetaData(this);
                licenseMetaData.setFile(file);
                licenseMetaData.mergeExternalMetaData();
                licenseMetaData.readPartialMatches();
                licenseMetaData.readMatchedMarkers();
                File licenseDir = new File(file.getParentFile(), "license");
                if (licenseDir.exists()) {
                    String[] licenses = FileUtils.scanDirectoryForFiles(licenseDir, true, "*.*");
                    if (licenses.length == 1) {
                        licenseMetaData.setLicenseFile(new File(licenseDir, licenses[0]).getAbsolutePath());
                    } else if (licenses.length > 1) {
                        throw new IllegalStateException(String.format("%s: more that one license file detected." + Arrays.asList(licenses), licenseMetaData.getCanonicalName()));
                    }
                }
                if ((readmeDir = new File(file.getParentFile(), "readme")).exists()) {
                    String[] files = FileUtils.scanDirectoryForFiles(readmeDir, true, "*.*");
                    if (files.length == 1) {
                        licenseMetaData.setReadmeFile(new File(readmeDir, files[0]).getAbsolutePath());
                    } else if (files.length > 1) {
                        throw new IllegalStateException(String.format("%s: more that one readme file supported." + Arrays.asList(files), licenseMetaData.getCanonicalName()));
                    }
                }
                if (this.licenseMetaDataMap.containsKey(licenseMetaData.getCanonicalName())) {
                    throw new IllegalStateException("Canonical name " + licenseMetaData.getCanonicalName() + " already registered. Duplicate use detected in " + path);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Registering license meta data [{}].", (Object)licenseMetaData.getCanonicalName());
                }
                this.licenseMetaDataMap.put(licenseMetaData.getCanonicalName(), licenseMetaData);
                if (licenseMetaData.getShortName() != null) {
                    this.shortNameMap.put(licenseMetaData.getShortName(), licenseMetaData);
                }
                if (licenseMetaData.getAlternativeShortNames() != null) {
                    licenseMetaData.getAlternativeShortNames().stream().forEach(s -> this.shortNameMap.putIfAbsent((String)s, licenseMetaData));
                }
                if (licenseMetaData.getSpdxIdentifier() != null) {
                    this.shortNameMap.putIfAbsent(licenseMetaData.getSpdxIdentifier(), licenseMetaData);
                    this.spdxIdentifierMap.put(licenseMetaData.getSpdxIdentifier(), licenseMetaData);
                }
                List<String> alternativeNames = licenseMetaData.getAlternativeNames();
                String canonicalName = licenseMetaData.getCanonicalName();
                String category = licenseMetaData.getCategory();
                if (canonicalName != null && alternativeNames != null) {
                    canonicalName = canonicalName.trim();
                    category = category.trim();
                    for (String alternativeName : alternativeNames) {
                        this.checkAlternativeName(alternativeName);
                    }
                    this.checkAlternativeName(canonicalName);
                    for (String alternativeName : alternativeNames) {
                        this.addAlternativeNameToMap(canonicalName, category, alternativeName);
                    }
                    this.addAlternativeNameToMap(canonicalName, category, canonicalName);
                    if (licenseMetaData.getSpdxIdentifier() != null) {
                        this.addAlternativeNameToMap(canonicalName, category, licenseMetaData.getSpdxIdentifier());
                    }
                } else {
                    throw new IllegalStateException("License without a name.");
                }
                licenseMetaData.consolidateAlternativeNames();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot read license " + file.getAbsolutePath(), e);
            }
        }
    }

    private void addAlternativeNameToMap(String canonicalName, String category, String alternativeName) {
        String trim = String.valueOf(alternativeName).trim();
        if (StringUtils.hasText((String)trim) && !"[]".equals(trim)) {
            if (StringUtils.hasText((String)canonicalName) && !"[]".equals(canonicalName)) {
                this.licenseNameMap.put(trim, canonicalName);
            }
            if (StringUtils.hasText((String)category) && !"[]".equals(category)) {
                this.categoryNameMap.put(trim, category);
            }
        }
    }

    private void checkAlternativeName(String alternativeName) {
        String trim = String.valueOf(alternativeName).trim().toLowerCase();
        if (this.licenseNameMap.containsKey(trim)) {
            LOG.warn("License '" + alternativeName + "' already covered.");
        }
    }

    public List<String> analyze(String licenseText) {
        StringStats licenseTextStats = StringStats.normalize(licenseText, false);
        return this.analyze(licenseTextStats, true, true);
    }

    public List<String> analyze(StringStats licenseTextStats, boolean enableCombine, boolean enableIgnore) {
        ScanResultPart scanResultPart = this.doAnalyze(licenseTextStats, enableCombine, enableIgnore);
        return scanResultPart.getMatchedTerms();
    }

    public ScanResultPart doAnalyze(StringStats licenseTextStats) {
        ScanResultPart scanResult = new ScanResultPart();
        for (TermsMetaData licenseMetaData : this.licenseMetaDataMap.values()) {
            scanResult.merge(licenseMetaData.analyze(licenseTextStats));
        }
        return scanResult;
    }

    public ScanResultPart doAnalyze(StringStats licenseTextStats, boolean enableCombine, boolean enableIgnore) {
        ScanResultPart scanResultPart = new ScanResultPart();
        this.licenseMetaDataMap.values().stream().map(tmd -> tmd.analyze(licenseTextStats)).forEach(r -> scanResultPart.merge((ScanResultPart)r));
        scanResultPart.process(this, enableIgnore, enableCombine);
        return scanResultPart;
    }

    public Map<String, String> getCategoryNameMap() {
        return this.categoryNameMap;
    }

    public Map<String, String> getLicenseNameMap() {
        return this.licenseNameMap;
    }

    public TermsMetaData getTermsMetaData(String canonicalName) {
        return this.licenseMetaDataMap.get(canonicalName);
    }

    public TermsMetaData findTermsMetaData(String name) {
        TermsMetaData termsMetaData = this.getTermsMetaData(name);
        if (termsMetaData != null) {
            return termsMetaData;
        }
        String mappedName = this.licenseNameMap.get(name);
        if (mappedName == null) {
            mappedName = name;
        }
        return this.getTermsMetaData(mappedName);
    }

    public Map<String, TermsMetaData> getLicenseMetaDataMap() {
        return this.licenseMetaDataMap;
    }

    public void applyMasks(StringStats licenseTextStats) {
        String normalizedLicenseString = licenseTextStats.getNormalizedString();
        for (String normalizedMask : this.getNormalizedMasks()) {
            int normalizedStringLength;
            while ((normalizedStringLength = normalizedLicenseString.length()) != (normalizedLicenseString = normalizedLicenseString.replace(normalizedMask, STRING_WHITESPACE)).length()) {
            }
        }
        licenseTextStats.update(normalizedLicenseString);
    }

    public Map<Pattern, String> compilePatternList(TermsMetaData termsMetaData) {
        LinkedHashMap<Pattern, String> patterns = new LinkedHashMap<Pattern, String>();
        for (Map.Entry<String, String> mappings : termsMetaData.getMappings().entrySet()) {
            patterns.put(Pattern.compile(mappings.getKey()), mappings.getValue());
        }
        return patterns;
    }

    public String applyMappings(String text) {
        if (this.mappingMap == null) {
            TreeMap<String, Map<Pattern, String>> mappingMap = new TreeMap<String, Map<Pattern, String>>();
            for (TermsMetaData termsMetaData : this.getLicenseMetaDataMap().values()) {
                if (termsMetaData.getMappings() == null) continue;
                List<String> mappingOrder = termsMetaData.getMappingOrder();
                if (mappingOrder != null) {
                    for (String order : mappingOrder) {
                        Map<Pattern, String> compiledPatternList = this.compilePatternList(termsMetaData);
                        mappingMap.computeIfAbsent(order, a -> new LinkedHashMap()).putAll(compiledPatternList);
                    }
                    continue;
                }
                Map<Pattern, String> compiledPatternList = this.compilePatternList(termsMetaData);
                mappingMap.computeIfAbsent(ORDER_DEFAULT, a -> new LinkedHashMap()).putAll(compiledPatternList);
            }
            this.mappingMap = mappingMap;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping: {}", (Object)text);
        }
        for (Map.Entry<String, Map<Pattern, String>> entry : this.mappingMap.entrySet()) {
            for (Map.Entry<Pattern, String> patternEntry : entry.getValue().entrySet()) {
                if (LOG.isDebugEnabled()) {
                    String previousText = text;
                    if ((text = NormalizationMetaData.replace(text, patternEntry)).equals(previousText)) continue;
                    LOG.debug("  Effective mapping: ");
                    LOG.debug("  pattern: " + patternEntry.getKey().pattern());
                    LOG.debug("  replacement: " + patternEntry.getValue());
                    LOG.debug(text);
                    continue;
                }
                text = NormalizationMetaData.replace(text, patternEntry);
            }
        }
        return text;
    }

    private static String replace(String text, Map.Entry<Pattern, String> patternEntry) {
        Pattern key = patternEntry.getKey();
        String value = patternEntry.getValue();
        Matcher matcher = key.matcher(text);
        return matcher.replaceAll(value);
    }

    public List<TermsMetaData> convert(List<String> canonicalTermNames) {
        ArrayList<TermsMetaData> termsList = new ArrayList<TermsMetaData>();
        if (canonicalTermNames != null) {
            for (String canonicalName : canonicalTermNames) {
                TermsMetaData termsMetaData = this.getTermsMetaData(canonicalName);
                if (termsMetaData == null) {
                    termsMetaData = new TermsMetaData();
                    termsMetaData.setCanonicalName(canonicalName);
                    termsMetaData.setRequiresAnnexNotice(true);
                }
                termsList.add(termsMetaData);
            }
        }
        return termsList;
    }

    public void remove(TermsMetaData tmd) {
        LOG.info("Removing term metadata: " + tmd.getCanonicalName());
        for (Map.Entry<String, String> entry : new HashSet<Map.Entry<String, String>>(this.licenseNameMap.entrySet())) {
            if (!tmd.getCanonicalName().equals(entry.getValue())) continue;
            LOG.info("Removing alternative name: " + entry.getKey());
            this.licenseNameMap.remove(entry.getKey());
        }
        for (Map.Entry<String, String> entry : new HashSet<Map.Entry<String, String>>(this.categoryNameMap.entrySet())) {
            if (!tmd.getCategory().equals(entry.getValue())) continue;
            LOG.info("  Removing category: " + tmd.getCategory());
            this.categoryNameMap.remove(entry.getKey());
        }
        this.licenseMetaDataMap.remove(tmd.getCanonicalName());
        for (TermsMetaData otherTmd : this.licenseMetaDataMap.values()) {
            boolean remove;
            List<String> excludedMatches;
            boolean remove2;
            List<String> partialMatches = otherTmd.getPartialMatches();
            if (partialMatches != null && (remove2 = partialMatches.remove(tmd.getCanonicalName()))) {
                LOG.info("  Removing partial match registered for: " + tmd.getCanonicalName());
            }
            if ((excludedMatches = otherTmd.getExcludedMatches()) == null || !(remove = excludedMatches.remove(tmd.getCanonicalName()))) continue;
            LOG.info("  Removing excluded match registered for: " + tmd.getCanonicalName());
        }
    }

    public TermsMetaData findByShortName(String licenseId) {
        return this.shortNameMap.get(licenseId);
    }

    public TermsMetaData findBySpdxIdentifier(String licenseId) {
        return this.spdxIdentifierMap.get(licenseId);
    }

    public TermsMetaData findUsingCanonicalNameInHistory(String license) {
        String canonicalName = this.getUpdatedCanonicalName(license);
        if (license.equals(canonicalName)) {
            return null;
        }
        return this.getTermsMetaData(canonicalName);
    }

    public String getUpdatedCanonicalName(String license) {
        String licenseCheck;
        String canonicalName = this.findCanonicalNameInHistory(license);
        if (canonicalName.equals(license)) {
            return canonicalName;
        }
        String firstFinding = canonicalName;
        int count = 0;
        do {
            licenseCheck = canonicalName;
            canonicalName = this.findCanonicalNameInHistory(canonicalName);
            ++count;
        } while (!licenseCheck.equals(canonicalName) && !canonicalName.equals(firstFinding));
        if (canonicalName.equals(firstFinding) && count > 1) {
            throw new IllegalStateException("Circular reference detected while processing " + license + ".");
        }
        return canonicalName;
    }

    private String findCanonicalNameInHistory(String license) {
        for (TermsMetaData tmd : this.getLicenseMetaDataMap().values()) {
            if (tmd == null || tmd.getCanonicalNameHistory() == null) continue;
            for (String historicalName : tmd.getCanonicalNameHistory()) {
                if (!historicalName.equals(license)) continue;
                return tmd.getCanonicalName();
            }
        }
        return license;
    }

    public synchronized Map<String, String> getHistoricalCanonicalNameMap() {
        if (this.historicalCanonicalNameMap == null) {
            this.historicalCanonicalNameMap = new HashMap<String, String>();
            for (TermsMetaData tmd : this.getLicenseMetaDataMap().values()) {
                if (tmd.getCanonicalNameHistory() == null) continue;
                for (String s : tmd.getCanonicalNameHistory()) {
                    this.historicalCanonicalNameMap.put(s, this.getUpdatedCanonicalName(s));
                }
            }
        }
        return this.historicalCanonicalNameMap;
    }

    private synchronized Set<String> getNormalizedMasks() {
        if (this.normalizedMasks == null) {
            this.normalizedMasks = new LinkedHashSet<String>();
            for (TermsMetaData lmd : this.licenseMetaDataMap.values()) {
                if (lmd.getMasks() == null) continue;
                for (String mask : lmd.getMasks().getMatches()) {
                    if (mask.isEmpty()) {
                        throw new IllegalStateException("Mask matches must be longer than 1 character.");
                    }
                    StringStats normalizedMask = StringStats.normalize(mask, false);
                    this.normalizedMasks.add(normalizedMask.getNormalizedString());
                }
            }
        }
        return this.normalizedMasks;
    }

    public Collection<String> getWordlist() {
        return this.wordlist;
    }

    public TermsMetaData resolveTermsMetaData(String canonicalName) {
        TermsMetaData termsMetaData = this.resolveTermsMetaDataCurrentAndHistory(canonicalName);
        if (termsMetaData == null) {
            String modulatedLicense = canonicalName.replace(" (or any later version)", "");
            termsMetaData = this.resolveTermsMetaDataCurrentAndHistory(modulatedLicense);
        }
        return termsMetaData;
    }

    public TermsMetaData resolveTermsMetaDataCurrentAndHistory(String canonicalName) {
        TermsMetaData termsMetaData = this.findTermsMetaData(canonicalName);
        if (termsMetaData == null) {
            termsMetaData = this.findUsingCanonicalNameInHistory(canonicalName);
        }
        return termsMetaData;
    }
}

