/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.advisory;

import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.mirror.contents.advisory.GhsaAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DescriptionParagraph;
import com.metaeffekt.mirror.contents.base.MatchableDetailsAmbDataClass;
import com.metaeffekt.mirror.contents.base.Reference;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.security.cvss.processor.CvssVectorSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdvisoryEntry
extends MatchableDetailsAmbDataClass<AdvisoryMetaData, AdvisoryEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(AdvisoryEntry.class);
    protected static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(MatchableDetailsAmbDataClass.CONVERSION_KEYS_AMB){
        {
            this.addAll(Arrays.asList(AdvisoryMetaData.Attribute.NAME.getKey(), AdvisoryMetaData.Attribute.SOURCE.getKey(), AdvisoryMetaData.Attribute.SOURCE_IMPLEMENTATION.getKey(), AdvisoryMetaData.Attribute.URL.getKey(), AdvisoryMetaData.Attribute.TYPE.getKey(), AdvisoryMetaData.Attribute.SUMMARY.getKey(), AdvisoryMetaData.Attribute.DESCRIPTION.getKey(), AdvisoryMetaData.Attribute.THREAT.getKey(), AdvisoryMetaData.Attribute.RECOMMENDATIONS.getKey(), AdvisoryMetaData.Attribute.WORKAROUNDS.getKey(), AdvisoryMetaData.Attribute.ACKNOWLEDGEMENTS.getKey(), AdvisoryMetaData.Attribute.REFERENCES.getKey(), AdvisoryMetaData.Attribute.KEYWORDS.getKey(), AdvisoryMetaData.Attribute.CREATE_DATE.getKey(), AdvisoryMetaData.Attribute.CREATE_DATE_FORMATTED.getKey(), AdvisoryMetaData.Attribute.UPDATE_DATE.getKey(), AdvisoryMetaData.Attribute.UPDATE_DATE_FORMATTED.getKey(), AdvisoryMetaData.Attribute.MATCHING_SOURCE.getKey(), AdvisoryMetaData.Attribute.DATA_SOURCE.getKey(), AdvisoryMetaData.Attribute.CVSS_VECTORS.getKey()));
        }
    };
    protected static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(MatchableDetailsAmbDataClass.CONVERSION_KEYS_MAP){
        {
            this.addAll(Arrays.asList("id", "url", "summary", "description", "threat", "recommendations", "workarounds", "references", "acknowledgements", "keywords", "createDate", "updateDate", "cvss"));
        }
    };
    protected AdvisoryTypeIdentifier<?> sourceIdentifier;
    protected String summary;
    protected final List<DescriptionParagraph> description = new ArrayList<DescriptionParagraph>();
    protected String threat;
    protected String recommendations;
    protected String workarounds;
    protected final Set<String> acknowledgements = new LinkedHashSet<String>();
    protected final Set<Reference> references = new LinkedHashSet<Reference>();
    protected final Set<String> keywords = new LinkedHashSet<String>();
    protected Date createDate;
    protected Date updateDate;
    private final CvssVectorSet cvssVectors = new CvssVectorSet();
    public static final Comparator<AdvisoryEntry> UPDATE_CREATE_TIME_COMPARATOR = Comparator.comparing(AdvisoryEntry::getUpdateDate).thenComparing(AdvisoryEntry::getCreateDate);
    public static final String DOCUMENT_ARRAY_DELIMITER = ";;";

    public AdvisoryEntry(AdvisoryTypeIdentifier<?> source) {
        if (source == null) {
            throw new IllegalArgumentException("Advisory source must not be null");
        }
        this.sourceIdentifier = source;
    }

    public AdvisoryEntry(AdvisoryTypeIdentifier<?> source, String id) {
        this(source);
        this.id = id;
    }

    public void setSourceIdentifier(AdvisoryTypeIdentifier<?> source) {
        if (source == null) {
            throw new IllegalArgumentException("Advisory source must not be null");
        }
        if (LOG.isDebugEnabled() && source != this.sourceIdentifier) {
            LOG.warn("Explicitly assigned source differs from originally assigned [{}] --> [{}]", (Object)this.sourceIdentifier.toExtendedString(), (Object)source.toExtendedString());
        }
        this.sourceIdentifier = source;
    }

    @Override
    public AdvisoryTypeIdentifier<?> getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public AdvisoryEntry setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public void setDescription(DescriptionParagraph paragraph) {
        this.description.clear();
        if (paragraph.isEmpty()) {
            return;
        }
        this.description.add(paragraph);
    }

    public void addDescription(String title, String content) {
        if (StringUtils.hasText(content)) {
            this.addDescription(new DescriptionParagraph(title, content));
        }
    }

    public void addDescription(DescriptionParagraph paragraph) {
        if (paragraph.isEmpty()) {
            return;
        }
        this.description.add(paragraph);
    }

    public void addDescription(List<DescriptionParagraph> paragraphs) {
        paragraphs.stream().filter(p -> !p.isEmpty()).forEach(this::addDescription);
    }

    public void clearDescription() {
        this.description.clear();
    }

    public void addReference(Reference reference) {
        if (StringUtils.hasText(reference.getUrl())) {
            this.references.add(reference);
        }
    }

    public void addReferences(Collection<Reference> references) {
        references.forEach(this::addReference);
    }

    public void removeReference(String reference) {
        this.references.removeIf(r -> r.getUrl().equals(reference));
        this.references.removeIf(r -> r.getTitle().equals(reference));
    }

    public void removeReference(Reference reference) {
        this.references.remove(reference);
    }

    public void addAcknowledgement(String author) {
        if (StringUtils.hasText(author)) {
            this.acknowledgements.add(author);
        }
    }

    public void addAcknowledgements(Collection<String> authors) {
        authors.forEach(this::addAcknowledgement);
    }

    public void removeAcknowledgement(String author) {
        this.acknowledgements.remove(author);
    }

    public void addKeyword(String keyword) {
        if (StringUtils.hasText(keyword)) {
            this.keywords.add(keyword);
        }
    }

    public void addKeywords(Collection<String> keywords) {
        keywords.forEach(this::addKeyword);
    }

    public void removeKeyword(String keyword) {
        this.keywords.remove(keyword);
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
        this.setCorrectUpdateCreateDateOrder();
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
        this.setCorrectUpdateCreateDateOrder();
    }

    private void setCorrectUpdateCreateDateOrder() {
        if (this.updateDate != null && this.createDate != null && this.updateDate.before(this.createDate)) {
            Date tmp = this.updateDate;
            this.updateDate = this.createDate;
            this.createDate = tmp;
        }
    }

    public void setCreateDate(long creationDate) {
        this.setCreateDate(new Date(creationDate));
    }

    public void setUpdateDate(long lastModifiedDate) {
        this.setUpdateDate(new Date(lastModifiedDate));
    }

    public String getTextDescription() {
        return this.description.stream().map(DescriptionParagraph::toString).collect(Collectors.joining("\n\n"));
    }

    public DescriptionParagraph getDescription(String title) {
        return this.description.stream().filter(p -> p.getHeader().equals(title)).findFirst().orElse(null);
    }

    public String getDescriptionContent(String title) {
        DescriptionParagraph paragraph = this.getDescription(title);
        return paragraph != null ? paragraph.getContent() : null;
    }

    public boolean hasBeenUpdatedSince(long timestamp) {
        Date date = this.updateDate != null ? this.updateDate : this.createDate;
        return date != null && date.getTime() > timestamp;
    }

    public boolean hasBeenUpdatedBefore(long timestamp) {
        Date date = this.updateDate != null ? this.updateDate : this.createDate;
        return date != null && date.getTime() < timestamp;
    }

    public abstract String getUrl();

    public abstract String getType();

    @Override
    public AdvisoryMetaData constructBaseModel() {
        return new AdvisoryMetaData();
    }

    public static <T extends AdvisoryEntry> T fromAdvisoryMetaData(AdvisoryMetaData amd, Supplier<T> constructor) {
        if (amd == null) {
            return null;
        }
        return (T)((AdvisoryEntry)constructor.get()).performAction(v -> v.appendFromBaseModel(amd));
    }

    public static AdvisoryEntry fromAdvisoryMetaData(AdvisoryMetaData amd) {
        AdvisoryTypeIdentifier<?> foundType = AdvisoryTypeStore.get().fromAdvisoryMetaData(amd).getIdentifier();
        return AdvisoryEntry.fromAdvisoryMetaData(amd, foundType.getAdvisoryFactory());
    }

    public static <T extends AdvisoryEntry> T fromInputMap(Map<String, Object> map, Supplier<T> constructor) {
        if (map == null) {
            return null;
        }
        return (T)((AdvisoryEntry)constructor.get()).performAction(v -> v.appendFromMap(map));
    }

    public static <T extends AdvisoryEntry> T fromJson(JSONObject json, Supplier<T> constructor) {
        if (json == null) {
            return null;
        }
        return AdvisoryEntry.fromInputMap(json.toMap(), constructor);
    }

    public static <T extends AdvisoryEntry> T fromJson(File file, Supplier<T> constructor) throws IOException {
        if (file == null) {
            return null;
        }
        String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        JSONObject json = new JSONObject(content);
        return AdvisoryEntry.fromJson(json, constructor);
    }

    public static AdvisoryEntry fromJson(JSONObject json) {
        ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>> foundType = AdvisoryTypeStore.get().fromJsonNameAndImplementation(json);
        return AdvisoryEntry.fromJson(json, foundType.getIdentifier().getAdvisoryFactory());
    }

    public static <T extends AdvisoryEntry> T fromDocument(Document document, Supplier<T> constructor) {
        if (document == null) {
            return null;
        }
        return (T)((AdvisoryEntry)constructor.get()).performAction(v -> v.appendFromDocument(document));
    }

    @Override
    public void appendFromBaseModel(AdvisoryMetaData advisoryMetaData) {
        String referencesString;
        int i;
        super.appendFromBaseModel(advisoryMetaData);
        this.setId(advisoryMetaData.get(AdvisoryMetaData.Attribute.NAME));
        String source = advisoryMetaData.get(AdvisoryMetaData.Attribute.SOURCE);
        String sourceImplementation = advisoryMetaData.get(AdvisoryMetaData.Attribute.SOURCE_IMPLEMENTATION);
        if (StringUtils.hasText(source) || StringUtils.hasText(sourceImplementation)) {
            this.setSourceIdentifier((AdvisoryTypeIdentifier)AdvisoryTypeStore.get().fromNameAndImplementation(source, sourceImplementation));
        } else {
            AdvisoryTypeStore.get().inferSourceIdentifierFromIdIfAbsent(this);
        }
        this.setSummary(advisoryMetaData.get(AdvisoryMetaData.Attribute.SUMMARY));
        if (StringUtils.hasText(advisoryMetaData.get(AdvisoryMetaData.Attribute.DESCRIPTION))) {
            this.addDescription(DescriptionParagraph.fromJson(new JSONArray(advisoryMetaData.get(AdvisoryMetaData.Attribute.DESCRIPTION))));
        }
        this.setThreat(advisoryMetaData.get(AdvisoryMetaData.Attribute.THREAT));
        this.setRecommendations(advisoryMetaData.get(AdvisoryMetaData.Attribute.RECOMMENDATIONS));
        this.setWorkarounds(advisoryMetaData.get(AdvisoryMetaData.Attribute.WORKAROUNDS));
        if (StringUtils.hasText(advisoryMetaData.get(AdvisoryMetaData.Attribute.ACKNOWLEDGEMENTS))) {
            JSONArray acknowledgements = new JSONArray(advisoryMetaData.get(AdvisoryMetaData.Attribute.ACKNOWLEDGEMENTS));
            for (i = 0; i < acknowledgements.length(); ++i) {
                this.addAcknowledgement(acknowledgements.optString(i));
            }
        }
        if (StringUtils.hasText(advisoryMetaData.get(AdvisoryMetaData.Attribute.KEYWORDS))) {
            JSONArray keywords = new JSONArray(advisoryMetaData.get(AdvisoryMetaData.Attribute.KEYWORDS));
            for (i = 0; i < keywords.length(); ++i) {
                this.addKeyword(keywords.optString(i));
            }
        }
        if (StringUtils.hasText(referencesString = advisoryMetaData.get(AdvisoryMetaData.Attribute.REFERENCES))) {
            JSONArray references = new JSONArray(referencesString);
            for (int i2 = 0; i2 < references.length(); ++i2) {
                this.addReference(Reference.fromJson(references.optJSONObject(i2)));
            }
        }
        this.setCreateDate(TimeUtils.tryParse(advisoryMetaData.get(AdvisoryMetaData.Attribute.CREATE_DATE)));
        this.setUpdateDate(TimeUtils.tryParse(advisoryMetaData.get(AdvisoryMetaData.Attribute.UPDATE_DATE)));
        if (StringUtils.hasText(advisoryMetaData.get(AdvisoryMetaData.Attribute.CVSS_VECTORS))) {
            String cvssVectors = advisoryMetaData.get(AdvisoryMetaData.Attribute.CVSS_VECTORS);
            this.cvssVectors.addAllCvssVectors(CvssVectorSet.fromJson((JSONArray)new JSONArray(cvssVectors)));
        }
    }

    @Override
    public void appendToBaseModel(AdvisoryMetaData amd) {
        super.appendToBaseModel(amd);
        amd.set(AdvisoryMetaData.Attribute.NAME, this.id);
        amd.set(AdvisoryMetaData.Attribute.URL, this.getUrl());
        amd.set(AdvisoryMetaData.Attribute.TYPE, this.getType());
        amd.set(AdvisoryMetaData.Attribute.SUMMARY, this.summary);
        if (!this.description.isEmpty()) {
            amd.set(AdvisoryMetaData.Attribute.DESCRIPTION, this.description.stream().map(DescriptionParagraph::toJson).collect(CustomCollectors.toJsonArray()).toString());
        }
        if (this.threat != null) {
            amd.set(AdvisoryMetaData.Attribute.THREAT, this.threat);
        }
        if (this.recommendations != null) {
            amd.set(AdvisoryMetaData.Attribute.RECOMMENDATIONS, this.recommendations);
        }
        if (this.workarounds != null) {
            amd.set(AdvisoryMetaData.Attribute.WORKAROUNDS, this.workarounds);
        }
        if (!this.acknowledgements.isEmpty()) {
            amd.set(AdvisoryMetaData.Attribute.ACKNOWLEDGEMENTS, new JSONArray(this.acknowledgements).toString());
        }
        if (!this.references.isEmpty()) {
            amd.set(AdvisoryMetaData.Attribute.REFERENCES, this.references.stream().map(Reference::toJson).collect(CustomCollectors.toJsonArray()).toString());
        }
        if (!this.keywords.isEmpty()) {
            amd.set(AdvisoryMetaData.Attribute.KEYWORDS, new JSONArray(this.keywords).toString());
        }
        if (this.createDate != null) {
            amd.set(AdvisoryMetaData.Attribute.CREATE_DATE, Long.toString(this.createDate.getTime()));
            amd.set(AdvisoryMetaData.Attribute.CREATE_DATE_FORMATTED, TimeUtils.formatNormalizedDate(this.createDate));
        }
        if (this.updateDate != null) {
            amd.set(AdvisoryMetaData.Attribute.UPDATE_DATE, Long.toString(this.updateDate.getTime()));
            amd.set(AdvisoryMetaData.Attribute.UPDATE_DATE_FORMATTED, TimeUtils.formatNormalizedDate(this.updateDate));
        }
        if (!this.cvssVectors.isEmpty()) {
            amd.set(AdvisoryMetaData.Attribute.CVSS_VECTORS, this.cvssVectors.toJson().toString());
        }
    }

    public Vulnerability toVulnerability() {
        Vulnerability vulnerability = new Vulnerability(this.id);
        vulnerability.setUrl(this.getUrl());
        vulnerability.setDescription(AdvisoryEntry.firstNonEmpty(this.summary, this.getTextDescription()));
        vulnerability.setCreateDate(this.createDate);
        vulnerability.setUpdateDate(this.updateDate);
        vulnerability.addReferences(new ArrayList<Reference>(this.references));
        vulnerability.addReference(Reference.fromTitleAndUrl("Advisor URL", this.getUrl()));
        vulnerability.addReferencedVulnerabilities(this.referencedVulnerabilities);
        vulnerability.addReferencedSecurityAdvisories(this.referencedSecurityAdvisories);
        vulnerability.getCvssVectors().addAllCvssVectors(this.cvssVectors);
        return vulnerability;
    }

    @Override
    public void appendFromDataClass(AdvisoryEntry dataClass) {
        super.appendFromDataClass(dataClass);
        if (StringUtils.hasText(dataClass.getSummary())) {
            this.setSummary(dataClass.getSummary());
        }
        if (!dataClass.getDescription().isEmpty()) {
            this.addDescription(dataClass.getDescription());
        }
        if (StringUtils.hasText(dataClass.getThreat())) {
            this.setThreat(dataClass.getThreat());
        }
        if (StringUtils.hasText(dataClass.getRecommendations())) {
            this.setRecommendations(dataClass.getRecommendations());
        }
        if (StringUtils.hasText(dataClass.getWorkarounds())) {
            this.setWorkarounds(dataClass.getWorkarounds());
        }
        if (!dataClass.getReferences().isEmpty()) {
            this.addReferences(dataClass.getReferences());
        }
        if (!dataClass.getAcknowledgements().isEmpty()) {
            this.addAcknowledgements(dataClass.getAcknowledgements());
        }
        if (!dataClass.getKeywords().isEmpty()) {
            this.addKeywords(dataClass.getKeywords());
        }
        if (dataClass.getCreateDate() != null) {
            this.setCreateDate(dataClass.getCreateDate());
        }
        if (dataClass.getUpdateDate() != null) {
            this.setUpdateDate(dataClass.getUpdateDate());
        }
        if (!dataClass.getCvssVectors().isEmpty()) {
            this.cvssVectors.addAllCvssVectors(dataClass.getCvssVectors());
        }
    }

    @Override
    public void appendFromMap(Map<String, Object> input) {
        super.appendFromMap(input);
        if (input.containsKey("id")) {
            this.setId(String.valueOf(input.get("id")));
        }
        String source = input.getOrDefault("source", null);
        String sourceImplementation = input.getOrDefault("sourceImplementation", null);
        if (source != null || sourceImplementation != null) {
            this.setSourceIdentifier((AdvisoryTypeIdentifier)AdvisoryTypeStore.get().fromNameAndImplementation(source, sourceImplementation));
        }
        this.setSummary(input.getOrDefault("summary", null));
        ArrayList inputDescriptionParagraphs = input.getOrDefault("description", new ArrayList());
        if (inputDescriptionParagraphs instanceof List) {
            List preTypedDescriptionParagraphs = inputDescriptionParagraphs;
            if (!preTypedDescriptionParagraphs.isEmpty()) {
                Object descriptionParagraph;
                Iterator iterator;
                Object descriptionParagraphs;
                if (preTypedDescriptionParagraphs.get(0) instanceof DescriptionParagraph) {
                    descriptionParagraphs = inputDescriptionParagraphs;
                    iterator = descriptionParagraphs.iterator();
                    while (iterator.hasNext()) {
                        descriptionParagraph = (DescriptionParagraph)iterator.next();
                        this.addDescription((DescriptionParagraph)descriptionParagraph);
                    }
                } else if (preTypedDescriptionParagraphs.get(0) instanceof Map) {
                    descriptionParagraphs = inputDescriptionParagraphs;
                    iterator = descriptionParagraphs.iterator();
                    while (iterator.hasNext()) {
                        descriptionParagraph = (Map)iterator.next();
                        this.addDescription(DescriptionParagraph.fromJson(new JSONObject((Map)descriptionParagraph)));
                    }
                } else {
                    LOG.warn("Could not parse description paragraphs for [{}] [{}] from input: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), inputDescriptionParagraphs});
                }
            }
        } else if (inputDescriptionParagraphs instanceof String) {
            String descriptionParagraphs = (String)((Object)inputDescriptionParagraphs);
            this.addDescription(DescriptionParagraph.fromContent(descriptionParagraphs));
        }
        this.setThreat(input.getOrDefault("threat", null));
        this.setRecommendations(input.getOrDefault("recommendations", null));
        this.setWorkarounds(input.getOrDefault("workarounds", null));
        List references = input.getOrDefault("references", new ArrayList());
        for (Object referenceMap : references) {
            this.addReference(Reference.fromMap((Map<String, Object>)referenceMap));
        }
        List acknowledgements = input.getOrDefault("acknowledgements", new ArrayList());
        for (Object acknowledgement : acknowledgements) {
            this.addAcknowledgement((String)acknowledgement);
        }
        List keywords = input.getOrDefault("keywords", new ArrayList());
        for (String keyword : keywords) {
            this.addKeyword(keyword);
        }
        this.setCreateDate(TimeUtils.tryParse(String.valueOf(input.getOrDefault("createDate", null))));
        this.setUpdateDate(TimeUtils.tryParse(String.valueOf(input.getOrDefault("updateDate", null))));
        Object cvss = input.get("cvss");
        if (cvss != null) {
            if (cvss instanceof List) {
                JSONArray json = new JSONArray((Collection)((List)cvss));
                this.cvssVectors.addAllCvssVectors(CvssVectorSet.fromJson((JSONArray)json));
            } else {
                LOG.warn("Could not parse CVSS vectors for [{}] [{}] from input: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), cvss});
            }
        }
    }

    @Override
    public void appendToJson(JSONObject json) {
        super.appendToJson(json);
        json.put("id", (Object)this.id);
        json.put("url", (Object)this.getUrl());
        json.put("summary", (Object)this.summary);
        json.put("description", (Object)this.description.stream().map(DescriptionParagraph::toJson).collect(CustomCollectors.toJsonArray()));
        json.put("threat", (Object)this.threat);
        json.put("recommendations", (Object)this.recommendations);
        json.put("workarounds", (Object)this.workarounds);
        json.put("references", this.references);
        json.put("acknowledgements", this.acknowledgements);
        json.put("keywords", this.keywords);
        if (this.createDate != null) {
            json.put("createDate", this.createDate.getTime());
        }
        if (this.updateDate != null) {
            json.put("updateDate", this.updateDate.getTime());
        }
        json.put("cvss", (Object)this.cvssVectors.toJson());
    }

    @Override
    public void appendFromDocument(Document document) {
        super.appendFromDocument(document);
        this.setId(document.get("id"));
        this.setSummary(document.get("summary"));
        this.addDescription(DescriptionParagraph.fromJson(new JSONArray(document.get("description"))));
        this.setThreat(document.get("threat"));
        this.setRecommendations(document.get("recommendations"));
        this.setWorkarounds(document.get("workarounds"));
        String referencesString = document.get("references");
        if (StringUtils.hasText(referencesString)) {
            JSONArray references = new JSONArray(referencesString);
            for (int i = 0; i < references.length(); ++i) {
                this.addReference(Reference.fromJson(references.optJSONObject(i)));
            }
        }
        this.addAcknowledgements(AdvisoryEntry.splitDocumentArray(document.get("acknowledgements")));
        this.addKeywords(AdvisoryEntry.splitDocumentArray(document.get("keywords")));
        if (document.get("createDate") != null) {
            this.setCreateDate(new Date(Long.parseLong(document.get("createDate"))));
        }
        if (document.get("updateDate") != null) {
            this.setUpdateDate(new Date(Long.parseLong(document.get("updateDate"))));
        }
        if (document.get("cvss") != null) {
            String cvssVectors = document.get("cvss");
            this.cvssVectors.addAllCvssVectors(CvssVectorSet.fromJson((JSONArray)new JSONArray(cvssVectors)));
        }
    }

    @Override
    public void appendToDocument(Document doc) {
        super.appendToDocument(doc);
        if (this.id != null && this instanceof GhsaAdvisorEntry) {
            this.addToDocumentAsTextFieldIfNotEmpty(doc, "id", this.id.toLowerCase(Locale.US));
        } else {
            this.addToDocumentAsTextFieldIfNotEmpty(doc, "id", this.id);
        }
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "url", this.getUrl());
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "summary", this.summary);
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "description", this.description.stream().map(DescriptionParagraph::toJson).collect(CustomCollectors.toJsonArray()).toString());
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "threat", this.threat);
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "recommendations", this.recommendations);
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "workarounds", this.workarounds);
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "references", this.references.stream().map(Reference::toJson).collect(CustomCollectors.toJsonArray()).toString());
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "acknowledgements", String.join((CharSequence)DOCUMENT_ARRAY_DELIMITER, this.acknowledgements));
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "keywords", String.join((CharSequence)DOCUMENT_ARRAY_DELIMITER, this.keywords));
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "createDate", this.createDate == null ? null : Long.toString(this.createDate.getTime()));
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "updateDate", this.updateDate == null ? null : Long.toString(this.updateDate.getTime()));
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "cvss", this.cvssVectors.isEmpty() ? null : this.cvssVectors.toJson().toString());
    }

    protected void addToDocumentAsTextFieldIfNotEmpty(Document doc, String fieldName, String value) {
        if (StringUtils.hasText(value)) {
            doc.add((IndexableField)new TextField(fieldName, value, Field.Store.YES));
        }
    }

    public String toString() {
        return "{" + this.id + (this.summary == null ? "" : ": " + this.summary) + "}";
    }

    protected static void extractReferenceIdsFromStringIfPresent(String string, AdvisoryEntry entry, AdvisoryTypeIdentifier<?> contentIdentifier) {
        if (StringUtils.hasText(string)) {
            entry.addReferencedSecurityAdvisories(Collections.singletonMap(contentIdentifier, contentIdentifier.fromFreeText(string)));
        }
    }

    protected static void extractReferenceIdsFromStringIfPresent(String string, AdvisoryEntry entry, VulnerabilityTypeIdentifier<?> contentIdentifier) {
        if (StringUtils.hasText(string)) {
            entry.addReferencedVulnerabilities(Collections.singletonMap(contentIdentifier, contentIdentifier.fromFreeText(string)));
        }
    }

    protected static String trimNewlines(String s) {
        return s.replaceAll("(^\\s*)|(\\s*$)", "");
    }

    protected static List<String> splitDocumentArray(String array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array.split(DOCUMENT_ARRAY_DELIMITER));
    }

    protected static String firstNonEmpty(String ... items) {
        return Arrays.stream(items).filter(Objects::nonNull).filter(i -> !i.isEmpty()).findFirst().orElse(null);
    }

    protected static String longestNonEmpty(String ... items) {
        return Arrays.stream(items).filter(Objects::nonNull).filter(i -> !i.isEmpty()).max(Comparator.comparingInt(String::length)).orElse(null);
    }

    public String getSummary() {
        return this.summary;
    }

    public List<DescriptionParagraph> getDescription() {
        return this.description;
    }

    public String getThreat() {
        return this.threat;
    }

    public void setThreat(String threat) {
        this.threat = threat;
    }

    public String getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(String recommendations) {
        this.recommendations = recommendations;
    }

    public String getWorkarounds() {
        return this.workarounds;
    }

    public void setWorkarounds(String workarounds) {
        this.workarounds = workarounds;
    }

    public Set<String> getAcknowledgements() {
        return this.acknowledgements;
    }

    public Set<Reference> getReferences() {
        return this.references;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public CvssVectorSet getCvssVectors() {
        return this.cvssVectors;
    }
}

