/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.advisory;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.DescriptionParagraph;
import com.metaeffekt.mirror.contents.base.Reference;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.lucene.document.Document;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.report.model.AdvisoryUtils;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.KnownCvssEntities;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertSeiAdvisorEntry
extends AdvisoryEntry {
    private static final Logger LOG = LoggerFactory.getLogger(CertSeiAdvisorEntry.class);
    protected static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_AMB){};
    protected static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_MAP){};
    private static final String[][] CERT_SEI_OVERVIEW_HEADERS_ALTERNATE_NAMES = new String[][]{{"Overview"}, {"Description"}, {"Impact"}, {"Solution"}, {"Acknowledgements"}, {"Workarounds", "Workaround", "Possible Workarounds", "Apply a workaround"}};

    public CertSeiAdvisorEntry() {
        super(AdvisoryTypeStore.CERT_SEI);
    }

    public CertSeiAdvisorEntry(String id) {
        super(AdvisoryTypeStore.CERT_SEI, id);
    }

    @Override
    public String getUrl() {
        return "https://kb.cert.org/vuls/id/" + this.id.replace("VU#", "");
    }

    @Override
    public String getType() {
        return AdvisoryUtils.normalizeType((String)"alert");
    }

    @Override
    protected Set<String> conversionKeysAmb() {
        return CONVERSION_KEYS_AMB;
    }

    @Override
    protected Set<String> conversionKeysMap() {
        return CONVERSION_KEYS_MAP;
    }

    @Override
    public CertSeiAdvisorEntry constructDataClass() {
        return new CertSeiAdvisorEntry();
    }

    public static CertSeiAdvisorEntry fromAdvisoryMetaData(AdvisoryMetaData amd) {
        return AdvisoryEntry.fromAdvisoryMetaData(amd, CertSeiAdvisorEntry::new);
    }

    public static CertSeiAdvisorEntry fromInputMap(Map<String, Object> map) {
        return AdvisoryEntry.fromInputMap(map, CertSeiAdvisorEntry::new);
    }

    public static CertSeiAdvisorEntry fromJson(JSONObject json) {
        return AdvisoryEntry.fromJson(json, CertSeiAdvisorEntry::new);
    }

    public static CertSeiAdvisorEntry fromDocument(Document document) {
        return AdvisoryEntry.fromDocument(document, CertSeiAdvisorEntry::new);
    }

    @Override
    public void appendFromBaseModel(AdvisoryMetaData amd) {
        super.appendFromBaseModel(amd);
    }

    @Override
    public void appendToBaseModel(AdvisoryMetaData amd) {
        super.appendToBaseModel(amd);
    }

    @Override
    public void appendFromMap(Map<String, Object> map) {
        super.appendFromMap(map);
    }

    @Override
    public void appendToJson(JSONObject json) {
        super.appendToJson(json);
    }

    @Override
    public void appendFromDocument(Document document) {
        super.appendFromDocument(document);
    }

    @Override
    public void appendToDocument(Document document) {
        super.appendToDocument(document);
    }

    public static CertSeiAdvisorEntry fromDownloadJson(JSONObject json) {
        Cvss2 vector;
        JSONArray keywordsJson;
        CertSeiAdvisorEntry entry = new CertSeiAdvisorEntry();
        entry.setId(CertSeiAdvisorEntry.firstNonEmpty(json.optString("vuid", null), json.optString("idnumber", null), json.optString("id", null), "unknown").toUpperCase(Locale.ENGLISH).replaceAll("[-\u2013_ ]+", "-").replaceAll("\\D*(\\d+)\\D*", "VU#$1"));
        entry.setCreateDate(TimeUtils.tryParse(CertSeiAdvisorEntry.firstNonEmpty(json.optString("datecreated", null), json.optString("datefirstpublished", null), json.optString("publicdate", null), json.optString("dateupdated", null))));
        entry.setUpdateDate(TimeUtils.tryParse(CertSeiAdvisorEntry.firstNonEmpty(json.optString("dateupdated", null), json.optString("datecreated", null), json.optString("datefirstpublished", null), json.optString("publicdate", null))));
        JSONArray referencesJson = json.optJSONArray("public");
        if (referencesJson != null) {
            StringBuilder brokenUrlCollector = new StringBuilder();
            for (int i = 0; i < referencesJson.length(); ++i) {
                if (!StringUtils.hasText(referencesJson.optString(i))) continue;
                if (referencesJson.getString(i).length() == 1) {
                    brokenUrlCollector.append(referencesJson.getString(i));
                    continue;
                }
                entry.addReference(Reference.fromUrl(referencesJson.optString(i)));
            }
            if (brokenUrlCollector.length() > 0) {
                entry.addReference(Reference.fromUrl(brokenUrlCollector.toString()));
            }
        }
        if ((keywordsJson = json.optJSONArray("keywords")) != null) {
            for (int i = 0; i < keywordsJson.length(); ++i) {
                entry.addKeyword(keywordsJson.optString(i));
            }
        }
        HashMap<String, String> overviewMap = new HashMap<String, String>();
        if (json.optJSONObject("overview") != null) {
            LOG.info("overview is JSON on {}", (Object)entry.getId());
            json.optJSONObject("overview").toMap().forEach((key, value) -> overviewMap.put((String)key, String.valueOf(value)));
        } else if (json.has("overview")) {
            String[] lines;
            String overviewString = String.valueOf(json.opt("overview"));
            String currentTitle = "";
            StringJoiner currentLines = new StringJoiner("\n");
            for (String line : lines = overviewString.split("\r?\n")) {
                String normalizedTitle = CertSeiAdvisorEntry.certSeiNormalizeTitleIfAvailable(line);
                if (normalizedTitle != null) {
                    if (currentLines.length() > 0) {
                        overviewMap.put(currentTitle, CertSeiAdvisorEntry.trimNewlines(currentLines.toString()));
                        currentLines = new StringJoiner("\n");
                    }
                    currentTitle = normalizedTitle;
                    continue;
                }
                currentLines.add(line);
            }
            if (currentLines.length() > 0) {
                overviewMap.put(currentTitle, CertSeiAdvisorEntry.trimNewlines(currentLines.toString()));
            }
        }
        String cleanDescription = json.optString("clean_desc", null);
        String impact = json.optString("impact", null);
        String resolution = json.optString("resolution", null);
        String workarounds = json.optString("workarounds", null);
        String name = json.optString("name", null);
        entry.setSummary(CertSeiAdvisorEntry.firstNonEmpty(name, (String)overviewMap.get("Overview"), cleanDescription));
        entry.addDescription(DescriptionParagraph.fromContent(CertSeiAdvisorEntry.longestNonEmpty((String)overviewMap.get("Description"), (String)overviewMap.get(""), cleanDescription)));
        entry.setThreat(CertSeiAdvisorEntry.firstNonEmpty((String)overviewMap.get("Impact"), impact));
        entry.setRecommendations(CertSeiAdvisorEntry.firstNonEmpty((String)overviewMap.get("Solution"), resolution));
        entry.setWorkarounds(CertSeiAdvisorEntry.firstNonEmpty((String)overviewMap.get("Workarounds"), workarounds));
        entry.addAcknowledgements(Arrays.asList(json.optString("author", "").split("(,|\n\n)")));
        entry.addAcknowledgements(Arrays.asList(json.optString("thanks", "").split("(,|\n\n)")));
        entry.addAcknowledgements(Arrays.asList(overviewMap.getOrDefault("Acknowledgements", "").split("(,|\n\n)")));
        JSONArray referencedCves = json.optJSONArray("cveids");
        if (referencedCves != null && !referencedCves.isEmpty()) {
            for (int i = 0; i < referencedCves.length(); ++i) {
                String id = referencedCves.optString(i, null);
                if (!StringUtils.hasText(id)) continue;
                if (id.contains(" ")) {
                    entry.addReferencedVulnerabilities(VulnerabilityTypeStore.CVE, Arrays.asList(referencedCves.optString(i).split(" ?,? ")));
                    continue;
                }
                entry.addReferencedVulnerability(VulnerabilityTypeStore.CVE, referencedCves.optString(i));
            }
        }
        if (entry.getReferencedVulnerabilities(VulnerabilityTypeStore.CVE).isEmpty()) {
            CertSeiAdvisorEntry.extractReferenceIdsFromStringIfPresent(entry.getSummary(), (AdvisoryEntry)entry, VulnerabilityTypeStore.CVE);
            CertSeiAdvisorEntry.extractReferenceIdsFromStringIfPresent(entry.getTextDescription(), (AdvisoryEntry)entry, VulnerabilityTypeStore.CVE);
            CertSeiAdvisorEntry.extractReferenceIdsFromStringIfPresent(entry.getThreat(), (AdvisoryEntry)entry, VulnerabilityTypeStore.CVE);
            CertSeiAdvisorEntry.extractReferenceIdsFromStringIfPresent(entry.getRecommendations(), (AdvisoryEntry)entry, VulnerabilityTypeStore.CVE);
            CertSeiAdvisorEntry.extractReferenceIdsFromStringIfPresent(entry.getWorkarounds(), (AdvisoryEntry)entry, VulnerabilityTypeStore.CVE);
        }
        if (entry.getReferencedVulnerabilities(VulnerabilityTypeStore.CVE).isEmpty()) {
            LOG.debug("No referenced CVEs found for [{}], which makes it impossible for this advisory to be found during our enrichment.", (Object)entry.getId());
        }
        String cvss2Base = json.optString("cvss_basevector", null);
        String cvss2Environmental = json.optString("cvss_environmentalvector", null);
        StringJoiner cvss2Joiner = new StringJoiner("/");
        if (StringUtils.hasText(cvss2Base) && !cvss2Base.equals("N/A") && !cvss2Base.contains("--")) {
            cvss2Joiner.add(cvss2Base);
        }
        if (StringUtils.hasText(cvss2Environmental) && !cvss2Environmental.equals("N/A") && !cvss2Environmental.contains("--")) {
            cvss2Joiner.add(cvss2Environmental);
        }
        if (!cvss2Joiner.toString().trim().isEmpty() && ((vector = new Cvss2(cvss2Joiner.toString(), new CvssSource(KnownCvssEntities.CERT_SEI, Cvss2.class))).isAnyBaseDefined() || vector.isAnyEnvironmentalDefined() || vector.isAnyTemporalDefined())) {
            entry.getCvssVectors().addCvssVector((CvssVector)vector);
        }
        return entry;
    }

    private static String certSeiNormalizeTitleIfAvailable(String title) {
        if (title.startsWith("### ") || title.startsWith("#### ")) {
            title = title.replace("#### ", "").replace(" ####", "").replace("### ", "").replace(" ###", "").trim();
            String[][] stringArray = CERT_SEI_OVERVIEW_HEADERS_ALTERNATE_NAMES;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] validTitles;
                for (String validTitle : validTitles = stringArray[i]) {
                    if (!validTitle.equals(title)) continue;
                    return validTitles[0];
                }
            }
        }
        return null;
    }
}

