/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.advisory;

import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.report.model.AdvisoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralAdvisorEntry
extends AdvisoryEntry {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralAdvisorEntry.class);
    protected static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_AMB){};
    protected static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_MAP){};
    private String url;
    private String type = "alert";

    public GeneralAdvisorEntry() {
        super((AdvisoryTypeIdentifier)AdvisoryTypeStore.get().fromNameAndImplementation("UNKNOWN", "UNKNOWN"));
    }

    public GeneralAdvisorEntry(String id) {
        super((AdvisoryTypeIdentifier)AdvisoryTypeStore.get().fromNameAndImplementation("UNKNOWN", "UNKNOWN"), id);
    }

    public GeneralAdvisorEntry(AdvisoryTypeIdentifier<?> source) {
        super(source);
    }

    public GeneralAdvisorEntry(AdvisoryTypeIdentifier<?> source, String id) {
        super(source, id);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getType() {
        return AdvisoryUtils.normalizeType((String)this.type);
    }

    @Override
    protected Set<String> conversionKeysAmb() {
        return CONVERSION_KEYS_AMB;
    }

    @Override
    protected Set<String> conversionKeysMap() {
        return CONVERSION_KEYS_MAP;
    }

    @Override
    public GeneralAdvisorEntry constructDataClass() {
        return new GeneralAdvisorEntry();
    }

    public static GeneralAdvisorEntry fromAdvisoryMetaData(AdvisoryMetaData amd) {
        return AdvisoryEntry.fromAdvisoryMetaData(amd, GeneralAdvisorEntry::new);
    }

    public static GeneralAdvisorEntry fromInputMap(Map<String, Object> map) {
        return AdvisoryEntry.fromInputMap(map, GeneralAdvisorEntry::new);
    }

    public static GeneralAdvisorEntry fromJson(JSONObject json) {
        return AdvisoryEntry.fromJson(json, GeneralAdvisorEntry::new);
    }

    public static GeneralAdvisorEntry fromDocument(Document document) {
        return AdvisoryEntry.fromDocument(document, GeneralAdvisorEntry::new);
    }

    protected static String stringOrNull(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public void appendFromBaseModel(AdvisoryMetaData amd) {
        super.appendFromBaseModel(amd);
        this.url = GeneralAdvisorEntry.stringOrNull(amd.get(AdvisoryMetaData.Attribute.URL));
        if (StringUtils.isNotEmpty((CharSequence)amd.get(AdvisoryMetaData.Attribute.TYPE))) {
            this.type = String.valueOf(amd.get(AdvisoryMetaData.Attribute.TYPE));
        }
    }

    @Override
    public void appendToBaseModel(AdvisoryMetaData amd) {
        super.appendToBaseModel(amd);
    }

    @Override
    public void appendFromMap(Map<String, Object> map) {
        super.appendFromMap(map);
        this.url = GeneralAdvisorEntry.stringOrNull(map.get("url"));
        if (StringUtils.isNotEmpty((CharSequence)String.valueOf(map.get("type")))) {
            this.type = String.valueOf(map.get("type"));
        }
    }

    @Override
    public void appendToJson(JSONObject json) {
        super.appendToJson(json);
    }

    @Override
    public void appendFromDocument(Document document) {
        super.appendFromDocument(document);
    }

    @Override
    public void appendToDocument(Document document) {
        super.appendToDocument(document);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setType(String type) {
        this.type = type;
    }
}

