/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.base;

import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.mirror.contents.msrcdata.MsrcProduct;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.store.OtherTypeIdentifier;
import com.metaeffekt.mirror.contents.store.OtherTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

public class DataSourceIndicator {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceIndicator.class);
    private final ContentIdentifierStore.ContentIdentifier dataSource;
    private final Reason matchReason;

    public DataSourceIndicator(ContentIdentifierStore.ContentIdentifier dataSource, Reason matchReason) {
        this.dataSource = dataSource;
        this.matchReason = matchReason;
    }

    public JSONObject toJson() {
        return new JSONObject().put("source", (Object)this.dataSource.name()).put("implementation", (Object)this.dataSource.getImplementation()).put("matches", (Object)this.matchReason.toJson());
    }

    public static DataSourceIndicator fromJson(JSONObject json) {
        String source = json.getString("source");
        String implementation = json.optString("implementation", null);
        ContentIdentifierStore.ContentIdentifier parsedSource = DataSourceIndicator.sourceFromSourceAndImplementation(source, implementation);
        return new DataSourceIndicator(parsedSource, Reason.fromJson(json.getJSONObject("matches")));
    }

    public static List<DataSourceIndicator> fromJson(JSONArray json) {
        ArrayList<DataSourceIndicator> result = new ArrayList<DataSourceIndicator>();
        for (int i = 0; i < json.length(); ++i) {
            Object o = json.get(i);
            if (o instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)o;
                DataSourceIndicator fromJson = DataSourceIndicator.fromJson(jsonObject);
                result.add(fromJson);
                continue;
            }
            LOG.warn("Unexpected JSON object in array on [{}#fromJson(JSONArray)]: {}", DataSourceIndicator.class, o);
        }
        return result;
    }

    public static JSONArray toJson(Collection<DataSourceIndicator> indicators) {
        if (indicators == null || indicators.isEmpty()) {
            return new JSONArray();
        }
        try {
            return new JSONArray((Collection)indicators.stream().filter(Objects::nonNull).map(DataSourceIndicator::toJson).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOG.error("Failed to convert indicators to JSON: {}", indicators, (Object)e);
            return new JSONArray();
        }
    }

    public String toString() {
        return "DataSourceIndicator[" + this.dataSource + " --> " + (this.matchReason == null ? "unspecified" : this.matchReason.toJson()) + "]";
    }

    public static DataSourceIndicator msrcProduct(Artifact artifact, MsrcProduct msrcProduct, String ... kbIds) {
        return new DataSourceIndicator(AdvisoryTypeStore.MSRC, new MsrcProductReason(artifact, msrcProduct.getId(), kbIds));
    }

    public static DataSourceIndicator msrcProduct(Artifact artifact, MsrcProduct msrcProduct, Collection<String> kbIds) {
        return DataSourceIndicator.msrcProduct(artifact, msrcProduct, kbIds.toArray(new String[0]));
    }

    public static DataSourceIndicator cpe(Artifact artifact, ContentIdentifierStore.ContentIdentifier source, Cpe matchingCpe, String configuration) {
        return new DataSourceIndicator(source, new ArtifactCpeReason(artifact, CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(matchingCpe), configuration));
    }

    public static DataSourceIndicator vulnerability(Vulnerability vulnerability) {
        return new DataSourceIndicator(VulnerabilityTypeStore.CVE, new VulnerabilityReason(vulnerability));
    }

    public static DataSourceIndicator ghsa(Artifact artifact, String coordinates) {
        return new DataSourceIndicator(AdvisoryTypeStore.GHSA, new ArtifactGhsaReason(artifact, coordinates));
    }

    public static DataSourceIndicator assessmentStatus(File originFile) {
        return new DataSourceIndicator(OtherTypeStore.ASSESSMENT_STATUS, new AssessmentStatusReason(originFile == null ? "no-file" : originFile.getAbsolutePath()));
    }

    public static DataSourceIndicator sourcedArtifact(Artifact artifact, String reason) {
        return new DataSourceIndicator(VulnerabilityTypeStore.CVE, new AnyArtifactOverwriteSourceReason(artifact, reason));
    }

    private static ContentIdentifierStore.ContentIdentifier sourceFromSourceAndImplementation(String source, String implementation) {
        AdvisoryTypeIdentifier advisoryTypeIdentifier = (AdvisoryTypeIdentifier)AdvisoryTypeStore.get().fromNameAndImplementationWithoutCreation(source, implementation);
        if (advisoryTypeIdentifier != null) {
            return advisoryTypeIdentifier;
        }
        VulnerabilityTypeIdentifier vulnerabilityTypeIdentifier = (VulnerabilityTypeIdentifier)VulnerabilityTypeStore.get().fromNameAndImplementationWithoutCreation(source, implementation);
        if (vulnerabilityTypeIdentifier != null) {
            return vulnerabilityTypeIdentifier;
        }
        OtherTypeIdentifier otherTypeIdentifier = (OtherTypeIdentifier)OtherTypeStore.get().fromNameAndImplementationWithoutCreation(source, implementation);
        if (otherTypeIdentifier != null) {
            return otherTypeIdentifier;
        }
        return AdvisoryTypeStore.get().fromNameAndImplementationWithoutCreation(source, implementation);
    }

    public ContentIdentifierStore.ContentIdentifier getDataSource() {
        return this.dataSource;
    }

    public Reason getMatchReason() {
        return this.matchReason;
    }

    public static abstract class Reason {
        protected final String type;

        protected Reason(String type) {
            this.type = type;
        }

        public JSONObject toJson() {
            return new JSONObject().put("type", (Object)this.type);
        }

        public String overwriteSource() {
            return null;
        }

        public String toString() {
            return this.toJson().toString();
        }

        public static Reason fromJson(JSONObject json) {
            String type;
            if (!json.has("type")) {
                throw new IllegalArgumentException("Missing type attribute in reason JSON: " + json);
            }
            switch (type = json.getString("type")) {
                case "vulnerability": {
                    return new VulnerabilityReason(json.getString("id"));
                }
                case "artifact-cpe": {
                    return new ArtifactCpeReason(json, json.optString("cpe", null), json.optString("configuration", null));
                }
                case "msrc-product": {
                    return new MsrcProductReason(json, json.optString("msrcProductId", null), (String[])json.getJSONArray("kbIds").toList().stream().map(Object::toString).toArray(String[]::new));
                }
                case "artifact-ghsa": {
                    return new ArtifactGhsaReason(json, json.optString("coordinates", null));
                }
                case "any": {
                    return new AnyReason(json.optString("description", null));
                }
                case "any-artifact": {
                    return new AnyArtifactReason(json);
                }
                case "assessment-status": {
                    return new AssessmentStatusReason(json.optString("originFile", null));
                }
                case "any-artifact-overwrite-source": {
                    return new AnyArtifactOverwriteSourceReason(json);
                }
            }
            throw new IllegalArgumentException("Unknown reason type: " + type + "\nIn reason JSON:" + json);
        }

        public String getType() {
            return this.type;
        }
    }

    public static abstract class ArtifactReason
    extends Reason {
        protected final Artifact artifact;
        protected final String artifactId;
        protected final String artifactComponent;
        protected final String artifactVersion;

        protected ArtifactReason(String type, Artifact artifact) {
            super(type);
            if (artifact == null) {
                LOG.warn("Artifact is null in [{}#ArtifactReason(String, Artifact)], using empty artifact", DataSourceIndicator.class);
                artifact = new Artifact();
            }
            this.artifact = artifact;
            this.artifactId = artifact.getId();
            this.artifactComponent = artifact.getComponent();
            this.artifactVersion = artifact.getVersion();
        }

        protected ArtifactReason(String type, JSONObject artifactData) {
            super(type);
            this.artifact = null;
            this.artifactId = artifactData.optString("artifactId", null);
            this.artifactComponent = artifactData.optString("artifactComponent", null);
            this.artifactVersion = artifactData.optString("artifactVersion", null);
        }

        public boolean hasArtifact() {
            return this.artifact != null;
        }

        @Override
        public JSONObject toJson() {
            return super.toJson().put("artifactId", (Object)this.artifactId).put("artifactComponent", (Object)this.artifactComponent).put("artifactVersion", (Object)this.artifactVersion);
        }

        public Artifact findArtifact(Set<Artifact> artifacts) {
            if (this.artifact != null) {
                return this.artifact;
            }
            return artifacts.stream().filter(this::isArtifact).findFirst().orElse(null);
        }

        public boolean isArtifact(Artifact artifact) {
            if (artifact == null) {
                return false;
            }
            if (this.artifact != null) {
                return this.artifact.equals(artifact);
            }
            return Objects.equals(this.artifactId, artifact.getId()) && Objects.equals(this.artifactComponent, artifact.getComponent()) && Objects.equals(this.artifactVersion, artifact.getVersion());
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getArtifactComponent() {
            return this.artifactComponent;
        }

        public String getArtifactVersion() {
            return this.artifactVersion;
        }
    }

    public static class AnyArtifactReason
    extends ArtifactReason {
        public static final String TYPE = "any-artifact";

        public AnyArtifactReason(Artifact artifact) {
            super(TYPE, artifact);
        }

        protected AnyArtifactReason(JSONObject artifactData) {
            super(TYPE, artifactData);
        }

        @Override
        public JSONObject toJson() {
            return super.toJson();
        }
    }

    public static class AnyArtifactOverwriteSourceReason
    extends ArtifactReason {
        public static final String TYPE = "any-artifact-overwrite-source";
        private final String source;

        public AnyArtifactOverwriteSourceReason(Artifact artifact, String source) {
            super(TYPE, artifact);
            this.source = source;
        }

        protected AnyArtifactOverwriteSourceReason(JSONObject artifactData) {
            super(TYPE, artifactData);
            this.source = artifactData.optString("source", null);
        }

        @Override
        public String overwriteSource() {
            return this.source;
        }

        @Override
        public JSONObject toJson() {
            return super.toJson().put("source", (Object)this.source);
        }

        public String getSource() {
            return this.source;
        }
    }

    public static class AnyReason
    extends Reason {
        public static final String TYPE = "any";
        private final String description;

        public AnyReason(String description) {
            super(TYPE);
            this.description = description;
        }

        @Override
        public JSONObject toJson() {
            return super.toJson().put("description", (Object)this.description);
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class MsrcProductReason
    extends ArtifactReason {
        public static final String TYPE = "msrc-product";
        private final String msrcProductId;
        private final String[] kbIds;

        public MsrcProductReason(Artifact artifact, String msrcProductId, String[] kbIds) {
            super(TYPE, artifact);
            this.msrcProductId = msrcProductId;
            this.kbIds = kbIds;
        }

        protected MsrcProductReason(JSONObject artifactData, String msrcProductId, String[] kbIds) {
            super(TYPE, artifactData);
            this.msrcProductId = msrcProductId;
            this.kbIds = kbIds;
        }

        @Override
        public JSONObject toJson() {
            return super.toJson().put("msrcProductId", (Object)this.msrcProductId).put("kbIds", (Object)this.kbIds);
        }

        public String getMsrcProductId() {
            return this.msrcProductId;
        }

        public String[] getKbIds() {
            return this.kbIds;
        }
    }

    public static class ArtifactCpeReason
    extends ArtifactReason {
        public static final String TYPE = "artifact-cpe";
        private final String cpe;
        private final String configuration;

        public ArtifactCpeReason(Artifact artifact, String cpe) {
            super(TYPE, artifact);
            this.cpe = cpe;
            this.configuration = null;
        }

        protected ArtifactCpeReason(JSONObject artifactData, String cpe) {
            super(TYPE, artifactData);
            this.cpe = cpe;
            this.configuration = null;
        }

        public ArtifactCpeReason(Artifact artifact, String cpe, String configuration) {
            super(TYPE, artifact);
            this.cpe = cpe;
            this.configuration = configuration;
        }

        protected ArtifactCpeReason(JSONObject artifactData, String cpe, String configuration) {
            super(TYPE, artifactData);
            this.cpe = cpe;
            this.configuration = configuration;
        }

        @Override
        public JSONObject toJson() {
            return super.toJson().put("cpe", (Object)this.cpe).put("configuration", (Object)this.configuration);
        }

        public String getCpe() {
            return this.cpe;
        }

        public String getConfiguration() {
            return this.configuration;
        }
    }

    public static class ArtifactGhsaReason
    extends ArtifactReason {
        public static final String TYPE = "artifact-ghsa";
        private final String coordinates;

        public ArtifactGhsaReason(Artifact artifact, String coordinates) {
            super(TYPE, artifact);
            this.coordinates = coordinates;
        }

        protected ArtifactGhsaReason(JSONObject artifactData, String coordinates) {
            super(TYPE, artifactData);
            this.coordinates = coordinates;
        }

        @Override
        public JSONObject toJson() {
            return super.toJson().put("coordinates", (Object)this.coordinates);
        }

        public String getCoordinates() {
            return this.coordinates;
        }
    }

    public static class VulnerabilityReason
    extends Reason {
        public static final String TYPE = "vulnerability";
        private final String id;

        public VulnerabilityReason(String id) {
            super(TYPE);
            this.id = id;
        }

        public VulnerabilityReason(Vulnerability vulnerability) {
            super(TYPE);
            this.id = vulnerability.getId();
        }

        @Override
        public JSONObject toJson() {
            return super.toJson().put("id", (Object)this.id);
        }

        public String getId() {
            return this.id;
        }
    }

    public static class AssessmentStatusReason
    extends Reason {
        public static final String TYPE = "assessment-status";
        private final String originFile;

        public AssessmentStatusReason(String originFile) {
            super(TYPE);
            this.originFile = originFile;
        }

        public String getOriginFileName() {
            if (this.originFile == null || this.originFile.isEmpty() || this.originFile.equals("no-file")) {
                return "no-file";
            }
            return new File(this.originFile).getName();
        }

        @Override
        public JSONObject toJson() {
            return super.toJson().put("originFile", (Object)this.originFile);
        }

        public String getOriginFile() {
            return this.originFile;
        }
    }
}

