/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.base;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarnings;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.AmbDataClass;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.MatchableDetailsAmbDataClass;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.json.JSONArray;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.metaeffekt.core.inventory.processor.writer.InventoryWriter;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.processor.CvssSelectionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilityContextInventory {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityContextInventory.class);
    private final Inventory inventory;
    private final String vulnerabilityContextName;
    private final Set<Vulnerability> vulnerabilities = new LinkedHashSet<Vulnerability>();
    private final Set<AdvisoryEntry> securityAdvisories = new LinkedHashSet<AdvisoryEntry>();
    private final Map<String, Vulnerability> vulnerabilityByName = new HashMap<String, Vulnerability>();
    private final Map<String, AdvisoryEntry> advisoryByName = new HashMap<String, AdvisoryEntry>();
    private boolean reAssociateAdvisories = true;
    private boolean reAssociateVulnerabilities = true;

    protected VulnerabilityContextInventory(Inventory inventory, String vulnerabilityContextName) {
        this.inventory = inventory;
        this.vulnerabilityContextName = vulnerabilityContextName;
    }

    protected VulnerabilityContextInventory(Inventory inventory) {
        this(inventory, "default");
    }

    public void pauseReAssociation() {
        this.reAssociateAdvisories = false;
        this.reAssociateVulnerabilities = false;
    }

    public void resumeReAssociation() {
        this.reAssociateAdvisories = true;
        this.reAssociateVulnerabilities = true;
        this.reAssociateAdvisories();
        this.reAssociateVulnerabilities();
    }

    public InventoryWarnings getInventoryWarnings() {
        return InventoryWarnings.fromInventory(this.inventory);
    }

    public Set<Vulnerability> getShallowCopyVulnerabilities() {
        return new LinkedHashSet<Vulnerability>(this.vulnerabilities);
    }

    public List<Vulnerability> getSortedVulnerabilities() {
        ArrayList<Vulnerability> sortedVulnerabilities = new ArrayList<Vulnerability>(this.vulnerabilities);
        sortedVulnerabilities.sort(Comparator.comparing(AmbDataClass::getId));
        return sortedVulnerabilities;
    }

    public Set<AdvisoryEntry> getShallowCopySecurityAdvisories() {
        return new LinkedHashSet<AdvisoryEntry>(this.securityAdvisories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateEffectiveCvssVectorsForVulnerabilities(CentralSecurityPolicyConfiguration securityPolicy) {
        Set<Vulnerability> set = this.vulnerabilities;
        synchronized (set) {
            for (Vulnerability vulnerability : this.vulnerabilities) {
                vulnerability.selectEffectiveCvssVectors(securityPolicy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyEffectiveVulnerabilityStatus(CentralSecurityPolicyConfiguration securityPolicy) {
        Set<Vulnerability> set = this.vulnerabilities;
        synchronized (set) {
            for (Vulnerability vulnerability : this.vulnerabilities) {
                boolean isInsignificant = this.isVulnerabilityInsignificant(securityPolicy, vulnerability);
                VulnerabilityStatus vulnerabilityStatus = vulnerability.getOrCreateNewVulnerabilityStatus();
                vulnerabilityStatus.getStatusHistorySet().removeIf(e -> e.equalsTemplate(VulnerabilityStatusHistoryEntry.IN_REVIEW));
                vulnerabilityStatus.getStatusHistorySet().removeIf(e -> e.equalsTemplate(VulnerabilityStatusHistoryEntry.INSIGNIFICANT));
                vulnerabilityStatus.reorderChronologically(vulnerability, isInsignificant, securityPolicy.getInsignificantThreshold());
                if (!vulnerabilityStatus.getStatusHistory().stream().noneMatch(VulnerabilityStatusHistoryEntry::isActive)) continue;
                vulnerabilityStatus.addHistoryEntry(VulnerabilityStatusHistoryEntry.IN_REVIEW);
            }
        }
    }

    public boolean isVulnerabilityInsignificant(CentralSecurityPolicyConfiguration securityPolicy, Vulnerability vulnerability) {
        double insignificantThreshold = securityPolicy.getInsignificantThreshold();
        if (insignificantThreshold == -1.0) {
            return true;
        }
        CvssVector vector = vulnerability.getCvssSelectionResult().getSelectedContextIfAvailableOtherwiseInitial();
        if (vector == null) {
            return false;
        }
        return vector.getOverallScore() < insignificantThreshold;
    }

    public boolean isVulnerabilityIncludedRegardingAdvisoryProviders(CentralSecurityPolicyConfiguration securityPolicy, Vulnerability vulnerability) {
        if (CentralSecurityPolicyConfiguration.containsAny((JSONArray)securityPolicy.getIncludeVulnerabilitiesWithAdvisoryProviders())) {
            return true;
        }
        List<AdvisoryTypeIdentifier<?>> filter = AdvisoryTypeStore.get().fromJsonNamesAndImplementations(securityPolicy.getIncludeVulnerabilitiesWithAdvisoryProviders());
        return VulnerabilityContextInventory.isVulnerabilityIncludedRegardingAdvisoryProviders(vulnerability, filter);
    }

    public static boolean isVulnerabilityIncludedRegardingAdvisoryProviders(Vulnerability vulnerability, Collection<AdvisoryTypeIdentifier<?>> filter) {
        return vulnerability.getSecurityAdvisories().stream().anyMatch(a -> filter.contains(a.getSourceIdentifier()));
    }

    public boolean isVulnerabilityAboveIncludeScoreThreshold(CentralSecurityPolicyConfiguration securityPolicy, Vulnerability vulnerability) {
        if (securityPolicy.getIncludeScoreThreshold() == -1.0 || securityPolicy.getIncludeScoreThreshold() == Double.MIN_VALUE) {
            return true;
        }
        CvssVector vector = vulnerability.getCvssSelectionResult().getSelectedByCustomMetric(CvssVector::getOverallScore, CvssSelectionResult.CUSTOM_VECTOR_SCORE_SELECTOR_MAX);
        double score = vector == null ? 0.0 : vector.getOverallScore();
        return score >= securityPolicy.getIncludeScoreThreshold();
    }

    public boolean isVulnerabilityIncludedRegardingAdvisoryReviewStatus(CentralSecurityPolicyConfiguration securityPolicy, Vulnerability vulnerability) {
        List includeVulnerabilitiesWithAdvisoryReviewStatus = securityPolicy.getIncludeVulnerabilitiesWithAdvisoryReviewStatus();
        if (CentralSecurityPolicyConfiguration.containsAny((Collection)includeVulnerabilitiesWithAdvisoryReviewStatus)) {
            return true;
        }
        return vulnerability.getSecurityAdvisories().stream().map(a -> a.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS)).filter(Objects::nonNull).anyMatch(includeVulnerabilitiesWithAdvisoryReviewStatus::contains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Vulnerability vulnerability) {
        Set<Vulnerability> set = this.vulnerabilities;
        synchronized (set) {
            this.vulnerabilities.add(vulnerability);
        }
        this.reAssociateVulnerability(vulnerability);
        this.updateVulnerabilityByName(vulnerability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(VulnerabilityMetaData vmd) {
        Vulnerability vulnerability = Vulnerability.fromVulnerabilityMetaData(vmd);
        Set<Vulnerability> set = this.vulnerabilities;
        synchronized (set) {
            this.vulnerabilities.add(vulnerability);
        }
        this.reAssociateVulnerability(vulnerability);
        this.updateVulnerabilityByName(vulnerability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllVulnerabilities(List<Vulnerability> vulnerabilities) {
        Set<Vulnerability> set = this.vulnerabilities;
        synchronized (set) {
            this.vulnerabilities.addAll(vulnerabilities);
        }
        this.reAssociateVulnerabilities();
        for (Vulnerability vulnerability : vulnerabilities) {
            this.updateVulnerabilityByName(vulnerability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AdvisoryEntry securityAdvisory) {
        Set<AdvisoryEntry> set = this.securityAdvisories;
        synchronized (set) {
            this.securityAdvisories.add(securityAdvisory);
        }
        this.reAssociateAdvisory(securityAdvisory);
        this.updateSecurityAdvisoryByName(securityAdvisory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AdvisoryMetaData amd) {
        AdvisoryEntry securityAdvisory = AdvisoryEntry.fromAdvisoryMetaData(amd);
        Set<AdvisoryEntry> set = this.securityAdvisories;
        synchronized (set) {
            this.securityAdvisories.add(securityAdvisory);
        }
        this.reAssociateAdvisory(securityAdvisory);
        this.updateSecurityAdvisoryByName(securityAdvisory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllAdvisories(Collection<AdvisoryEntry> securityAdvisories) {
        Set<AdvisoryEntry> set = this.securityAdvisories;
        synchronized (set) {
            this.securityAdvisories.addAll(securityAdvisories);
        }
        this.reAssociateAdvisories();
        for (AdvisoryEntry securityAdvisory : securityAdvisories) {
            this.updateSecurityAdvisoryByName(securityAdvisory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Vulnerability vulnerability) {
        Object object = this.vulnerabilities;
        synchronized (object) {
            this.vulnerabilities.remove(vulnerability);
        }
        object = this.vulnerabilityByName;
        synchronized (object) {
            this.vulnerabilityByName.remove(vulnerability.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(VulnerabilityMetaData vulnerability) {
        Vulnerability removed;
        Object object = this.vulnerabilityByName;
        synchronized (object) {
            removed = this.vulnerabilityByName.remove(vulnerability.get(VulnerabilityMetaData.Attribute.NAME));
        }
        object = this.vulnerabilities;
        synchronized (object) {
            this.vulnerabilities.remove(removed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AdvisoryEntry securityAdvisory) {
        Set<Vulnerability> set = this.securityAdvisories;
        synchronized (set) {
            this.securityAdvisories.remove(securityAdvisory);
        }
        set = this.advisoryByName;
        synchronized (set) {
            this.advisoryByName.remove(securityAdvisory.getId());
        }
        set = this.vulnerabilities;
        synchronized (set) {
            this.vulnerabilities.forEach(v -> v.removeSecurityAdvisory(securityAdvisory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIgnoreVulnerabilities(AdvisoryEntry securityAdvisory) {
        Object object = this.securityAdvisories;
        synchronized (object) {
            this.securityAdvisories.remove(securityAdvisory);
        }
        object = this.advisoryByName;
        synchronized (object) {
            this.advisoryByName.remove(securityAdvisory.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AdvisoryMetaData securityAdvisory) {
        AdvisoryEntry removed;
        Object object = this.advisoryByName;
        synchronized (object) {
            removed = this.advisoryByName.remove(securityAdvisory.get(AdvisoryMetaData.Attribute.NAME));
        }
        object = this.securityAdvisories;
        synchronized (object) {
            this.securityAdvisories.remove(removed);
        }
    }

    public boolean contains(Vulnerability vulnerability) {
        return this.vulnerabilities.contains(vulnerability);
    }

    public boolean contains(AdvisoryEntry securityAdvisory) {
        return this.securityAdvisories.contains(securityAdvisory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVulnerabilityByName(Vulnerability vulnerability) {
        if (vulnerability == null) {
            return;
        }
        Map<String, Vulnerability> map = this.vulnerabilityByName;
        synchronized (map) {
            this.vulnerabilityByName.put(vulnerability.getId(), vulnerability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSecurityAdvisoryByName(AdvisoryEntry advisoryEntry) {
        if (advisoryEntry == null) {
            return;
        }
        Map<String, AdvisoryEntry> map = this.advisoryByName;
        synchronized (map) {
            this.advisoryByName.put(advisoryEntry.getId(), advisoryEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Vulnerability> findVulnerabilityByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        Vulnerability vulnerability = this.vulnerabilityByName.get(name);
        if (vulnerability == null) {
            return Optional.empty();
        }
        if (!this.vulnerabilities.contains(vulnerability)) {
            Set<Vulnerability> set = this.vulnerabilities;
            synchronized (set) {
                this.vulnerabilities.remove(vulnerability);
            }
            return Optional.empty();
        }
        return Optional.of(vulnerability);
    }

    public Vulnerability findOrCreateVulnerabilityByName(String name) {
        return this.findVulnerabilityByName(name).orElseGet(() -> {
            Vulnerability vulnerability = new Vulnerability(name);
            this.add(vulnerability);
            return vulnerability;
        });
    }

    public Vulnerability findOrAppendVulnerabilityByVulnerability(Vulnerability searchVulnerability) {
        if (searchVulnerability == null) {
            throw new IllegalArgumentException("Query vulnerability must not be null when searching/creating vulnerabilities");
        }
        if (searchVulnerability.getId() == null) {
            throw new IllegalArgumentException("Query vulnerability must have an id when searching/creating vulnerabilities, but got: " + searchVulnerability.toJson());
        }
        return this.findVulnerabilityByName(searchVulnerability.getId()).orElseGet(() -> {
            this.add(searchVulnerability);
            return searchVulnerability;
        });
    }

    public Vulnerability findOrCreateWithoutAddingVulnerabilityByName(String name) {
        return this.findVulnerabilityByName(name).orElseGet(() -> new Vulnerability(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Vulnerability> findVulnerabilitiesWithSecurityAdvisory(AdvisoryEntry securityAdvisory) {
        ArrayList<Vulnerability> vulnerabilitiesWithSecurityAdvisory = new ArrayList<Vulnerability>();
        Set<Vulnerability> set = this.vulnerabilities;
        synchronized (set) {
            for (Vulnerability vulnerability : this.vulnerabilities) {
                if (!vulnerability.getSecurityAdvisories().contains(securityAdvisory)) continue;
                vulnerabilitiesWithSecurityAdvisory.add(vulnerability);
            }
        }
        return vulnerabilitiesWithSecurityAdvisory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<AdvisoryEntry> findAdvisoryEntryByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        AdvisoryEntry advisoryEntry = this.advisoryByName.get(name);
        if (advisoryEntry == null) {
            return Optional.empty();
        }
        if (!this.securityAdvisories.contains(advisoryEntry)) {
            Object object = this.advisoryByName;
            synchronized (object) {
                this.advisoryByName.remove(name);
            }
            object = this.vulnerabilities;
            synchronized (object) {
                this.vulnerabilities.forEach(v -> v.removeSecurityAdvisory(advisoryEntry));
            }
            return Optional.empty();
        }
        return Optional.of(advisoryEntry);
    }

    public AdvisoryEntry findOrCreateAdvisoryEntryByName(String name, Function<String, AdvisoryEntry> constructor) {
        return this.findAdvisoryEntryByName(name).orElseGet(() -> {
            AdvisoryEntry advisoryEntry = (AdvisoryEntry)constructor.apply(name);
            this.add(advisoryEntry);
            return advisoryEntry;
        });
    }

    public AdvisoryEntry findOrAppendAdvisoryEntryByAdvisoryEntry(AdvisoryEntry searchAdvisoryEntry) {
        if (searchAdvisoryEntry == null) {
            throw new IllegalArgumentException("Query advisory entry must not be null when searching/creating advisory entries");
        }
        if (searchAdvisoryEntry.getId() == null) {
            throw new IllegalArgumentException("Query advisory entry must have an id when searching/creating advisory entries, but got: " + searchAdvisoryEntry.toJson());
        }
        return this.findAdvisoryEntryByName(searchAdvisoryEntry.getId()).orElseGet(() -> {
            this.add(searchAdvisoryEntry);
            return searchAdvisoryEntry;
        });
    }

    public String toString() {
        return "VulnerabilityContextInventory@" + Integer.toHexString(this.hashCode()) + "[" + this.inventory.getArtifacts().size() + ", " + this.vulnerabilities.size() + ", " + this.securityAdvisories.size() + ']';
    }

    public void writeBack() {
        this.writeBack(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void writeBack(boolean retainUnreferencedVulnerabilities) {
        long startTime = System.currentTimeMillis();
        this.reAssociateAdvisories();
        HashMap<String, Map<Artifact, Set<String>>> affectsArtifacts = new HashMap<String, Map<Artifact, Set<String>>>();
        Set<MatchableDetailsAmbDataClass> set = this.vulnerabilities;
        synchronized (set) {
            for (Vulnerability vulnerability : this.vulnerabilities) {
                this.extractMatchingArtifacts(vulnerability, affectsArtifacts);
            }
        }
        set = this.securityAdvisories;
        synchronized (set) {
            for (AdvisoryEntry advisoryEntry : this.securityAdvisories) {
                this.extractMatchingArtifacts(advisoryEntry, affectsArtifacts);
            }
        }
        for (Object artifact : this.inventory.getArtifacts()) {
            void var7_12;
            int n;
            Set vulnList;
            if (artifact.get(Artifact.Attribute.VULNERABILITY) != null) {
                affectsArtifacts.computeIfAbsent(Artifact.Attribute.VULNERABILITY.getKey(), k -> new HashMap()).computeIfAbsent(artifact, k -> new LinkedHashSet()).addAll(Arrays.asList(artifact.get(Artifact.Attribute.VULNERABILITY).split(", ")));
            }
            if (artifact.get((AbstractModelBase.Attribute)InventoryAttribute.ADDON_CVES) != null) {
                List<String> list = Arrays.asList(artifact.get((AbstractModelBase.Attribute)InventoryAttribute.ADDON_CVES).split(", "));
                affectsArtifacts.computeIfAbsent(Artifact.Attribute.VULNERABILITY.getKey(), k -> new HashMap()).computeIfAbsent(artifact, k -> new LinkedHashSet()).addAll(list);
                Set<Vulnerability> set2 = this.vulnerabilities;
                synchronized (set2) {
                    for (String addonCve : list) {
                        Vulnerability vulnerability = this.findOrCreateVulnerabilityByName(addonCve);
                        boolean exactArtifactAndAddonCvesReasonAlreadyExists = vulnerability.getMatchingSources().stream().filter(source -> source.getDataSource() == VulnerabilityTypeStore.CVE).filter(source -> source.getMatchReason() instanceof DataSourceIndicator.AnyArtifactOverwriteSourceReason).map(source -> (DataSourceIndicator.AnyArtifactOverwriteSourceReason)source.getMatchReason()).anyMatch(arg_0 -> VulnerabilityContextInventory.lambda$writeBack$18((Artifact)artifact, arg_0));
                        if (exactArtifactAndAddonCvesReasonAlreadyExists) continue;
                        vulnerability.addMatchingSource(DataSourceIndicator.sourcedArtifact((Artifact)artifact, InventoryAttribute.ADDON_CVES.getKey()));
                    }
                }
            }
            int n2 = 0;
            if (artifact.get((AbstractModelBase.Attribute)InventoryAttribute.INAPPLICABLE_CVE) != null) {
                vulnList = affectsArtifacts.computeIfAbsent(Artifact.Attribute.VULNERABILITY.getKey(), k -> new HashMap()).computeIfAbsent(artifact, k -> new LinkedHashSet());
                int sizeBefore = vulnList.size();
                Arrays.asList(artifact.get((AbstractModelBase.Attribute)InventoryAttribute.INAPPLICABLE_CVE).split(", ")).forEach(vulnList::remove);
                n = n2 + (sizeBefore - vulnList.size());
            }
            if (artifact.get((AbstractModelBase.Attribute)InventoryAttribute.VULNERABILITIES_FIXED_BY_KB) != null) {
                vulnList = affectsArtifacts.computeIfAbsent(Artifact.Attribute.VULNERABILITY.getKey(), k -> new HashMap()).computeIfAbsent(artifact, k -> new LinkedHashSet());
                int sizeBefore = vulnList.size();
                Arrays.asList(artifact.get((AbstractModelBase.Attribute)InventoryAttribute.VULNERABILITIES_FIXED_BY_KB).split(", ")).forEach(vulnList::remove);
                var7_12 = n + (sizeBefore - vulnList.size());
            }
            if (var7_12 <= 0) continue;
            LOG.warn("Removed [{}] vulnerabilities from artifact [{}:{}:{}] due to inapplicability or fix status", new Object[]{(int)var7_12, artifact.getId(), artifact.getComponent(), artifact.getVersion()});
        }
        set = this.vulnerabilities;
        synchronized (set) {
            for (Vulnerability vulnerability : this.vulnerabilities) {
                if (vulnerability.getVulnerabilityStatus() == null) continue;
                vulnerability.getVulnerabilityStatus().applyToVulnerability(vulnerability);
            }
            List vmds = this.inventory.getVulnerabilityMetaData(this.vulnerabilityContextName);
            vmds.clear();
            for (Vulnerability vulnerability : this.vulnerabilities) {
                vmds.add(vulnerability.toBaseModel());
            }
        }
        set = this.securityAdvisories;
        synchronized (set) {
            List amds = this.inventory.getAdvisoryMetaData();
            amds.clear();
            for (AdvisoryEntry advisoryEntry : this.securityAdvisories) {
                AdvisoryMetaData constructedAmd = (AdvisoryMetaData)advisoryEntry.toBaseModel();
                amds.add(constructedAmd);
            }
        }
        HashSet coveredVulnerabilities = new HashSet();
        for (Map.Entry entry : affectsArtifacts.entrySet()) {
            String artifactKey = (String)entry.getKey();
            Map artifactVulnerabilitiesMap = (Map)entry.getValue();
            for (Map.Entry artifactsVulnerabilities : artifactVulnerabilitiesMap.entrySet()) {
                Artifact artifact = (Artifact)artifactsVulnerabilities.getKey();
                Set vulnerabilities = (Set)artifactsVulnerabilities.getValue();
                artifact.set(artifactKey, String.join((CharSequence)", ", vulnerabilities));
                coveredVulnerabilities.addAll(vulnerabilities);
            }
        }
        if (!retainUnreferencedVulnerabilities) {
            HashSet<String> unreferencedVulnerabilities = new HashSet<String>();
            for (Vulnerability vulnerability : this.vulnerabilities) {
                boolean containsVoidStatus;
                if (coveredVulnerabilities.contains(vulnerability.getId()) || vulnerability.getVulnerabilityStatus() != null && (containsVoidStatus = vulnerability.getVulnerabilityStatus().getStatusHistory().stream().anyMatch(e -> "void".equals(e.getStatus())))) continue;
                unreferencedVulnerabilities.add(vulnerability.getId());
            }
            if (!unreferencedVulnerabilities.isEmpty()) {
                LOG.warn("Removed [{}] vulnerabilities from inventory that are not applicable on any artifact: [{}]", (Object)unreferencedVulnerabilities.size(), (Object)String.join((CharSequence)", ", unreferencedVulnerabilities));
                this.vulnerabilities.removeIf(v -> unreferencedVulnerabilities.contains(v.getId()));
                this.inventory.getVulnerabilityMetaData().removeIf(v -> unreferencedVulnerabilities.contains(v.get(VulnerabilityMetaData.Attribute.NAME)));
            }
        }
        this.inventory.getVulnerabilityMetaData().sort(Comparator.comparing(o -> o.get(VulnerabilityMetaData.Attribute.NAME) == null ? "" : o.get(VulnerabilityMetaData.Attribute.NAME)).reversed());
        LOG.debug("Wrote back [{}] vulnerabilities and [{}] security advisories in [{}] ms", new Object[]{this.vulnerabilities.size(), this.securityAdvisories.size(), System.currentTimeMillis() - startTime});
    }

    public void writeAdditionalInformationBack(CentralSecurityPolicyConfiguration securityPolicy) {
        if (securityPolicy == null) {
            LOG.error("Security Policy is null. Cannot write additional information back to inventory without a security policy");
            return;
        }
        for (String context : this.inventory.getVulnerabilityMetaDataContexts()) {
            for (VulnerabilityMetaData vmd : this.inventory.getVulnerabilityMetaData(context)) {
                String severity;
                double score;
                if (vmd.get(VulnerabilityMetaData.Attribute.SCORE_INITIAL_OVERALL) != null) {
                    try {
                        score = Double.parseDouble(vmd.get(VulnerabilityMetaData.Attribute.SCORE_INITIAL_OVERALL));
                        severity = securityPolicy.getCvssSeverityRanges().getRange(score).getName();
                        vmd.set(VulnerabilityMetaData.Attribute.SCORE_INITIAL_OVERALL_SEVERITY, severity);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Could not parse CVSS Initial Overall score for vulnerability [{}]: [{}]", (Object)vmd.get(VulnerabilityMetaData.Attribute.NAME), (Object)vmd.get(VulnerabilityMetaData.Attribute.SCORE_INITIAL_OVERALL));
                    }
                }
                if (vmd.get(VulnerabilityMetaData.Attribute.SCORE_CONTEXT_OVERALL) == null) continue;
                try {
                    score = Double.parseDouble(vmd.get(VulnerabilityMetaData.Attribute.SCORE_CONTEXT_OVERALL));
                    severity = securityPolicy.getCvssSeverityRanges().getRange(score).getName();
                    vmd.set(VulnerabilityMetaData.Attribute.SCORE_CONTEXT_OVERALL_SEVERITY, severity);
                }
                catch (NumberFormatException e) {
                    LOG.error("Could not parse CVSS Context Overall score for vulnerability [{}]: [{}]", (Object)vmd.get(VulnerabilityMetaData.Attribute.NAME), (Object)vmd.get(VulnerabilityMetaData.Attribute.SCORE_CONTEXT_OVERALL));
                }
            }
        }
    }

    public void writeToFile(File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        new InventoryWriter().writeInventory(this.inventory, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractMatchingArtifacts(MatchableDetailsAmbDataClass<?, ?> dc, Map<String, Map<Artifact, Set<String>>> affectsArtifacts) {
        Map<String, Set<Artifact>> affectedArtifactsForDataClass;
        Map<String, Set<Artifact>> map = affectedArtifactsForDataClass = dc.getAffectedArtifacts();
        synchronized (map) {
            for (Map.Entry<String, Set<Artifact>> keyToArtifacts : affectedArtifactsForDataClass.entrySet()) {
                String key = keyToArtifacts.getKey();
                Set<Artifact> artifacts = keyToArtifacts.getValue();
                for (Artifact artifact : artifacts) {
                    affectsArtifacts.computeIfAbsent(key, k -> new HashMap()).computeIfAbsent(artifact, k -> new LinkedHashSet()).add(dc.getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reAssociateVulnerabilities() {
        if (!this.reAssociateVulnerabilities) {
            LOG.debug("Skipping re-association of vulnerabilities due to configuration");
        }
        Set<Vulnerability> set = this.vulnerabilities;
        synchronized (set) {
            for (Vulnerability vulnerability : this.vulnerabilities) {
                this.reAssociateVulnerability(vulnerability);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reAssociateVulnerability(Vulnerability vulnerability) {
        if (!this.reAssociateVulnerabilities) {
            LOG.debug("Skipping re-association of vulnerability [{}] due to configuration", (Object)vulnerability.getId());
            return;
        }
        vulnerability.getSecurityAdvisories().clear();
        Map<AdvisoryTypeIdentifier<?>, Set<String>> map = vulnerability.getReferencedSecurityAdvisories();
        synchronized (map) {
            for (Map.Entry<AdvisoryTypeIdentifier<?>, Set<String>> refEntry : vulnerability.getReferencedSecurityAdvisories().entrySet()) {
                AdvisoryTypeIdentifier<?> source = refEntry.getKey();
                Set<String> ids = refEntry.getValue();
                ids.stream().map(this::findAdvisoryEntryByName).filter(Optional::isPresent).map(Optional::get).forEach(securityAdvisory -> {
                    if (securityAdvisory.getSourceIdentifier() != source) {
                        LOG.warn("Overwriting source for advisory [{}] from [{}] to [{}] due to more detailed information on vulnerability [{}]", new Object[]{securityAdvisory.getId(), securityAdvisory.getSourceIdentifier(), source, vulnerability.getId()});
                        securityAdvisory.setSourceIdentifier(source);
                    }
                    vulnerability.addSecurityAdvisory((AdvisoryEntry)securityAdvisory);
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reAssociateAdvisories() {
        if (!this.reAssociateAdvisories) {
            LOG.debug("Skipping re-association of advisories due to configuration");
            return;
        }
        HashSet<AdvisoryEntry> unknownAdvisories = new HashSet<AdvisoryEntry>();
        Set<MatchableDetailsAmbDataClass> set = this.vulnerabilities;
        synchronized (set) {
            Set<AdvisoryEntry> set2 = this.securityAdvisories;
            synchronized (set2) {
                for (Vulnerability vulnerability : this.vulnerabilities) {
                    for (AdvisoryEntry securityAdvisory : vulnerability.getSecurityAdvisories()) {
                        if (this.securityAdvisories.contains(securityAdvisory)) continue;
                        unknownAdvisories.add(securityAdvisory);
                    }
                }
            }
        }
        if (!unknownAdvisories.isEmpty()) {
            this.addAllAdvisories(unknownAdvisories);
        }
        set = this.securityAdvisories;
        synchronized (set) {
            for (AdvisoryEntry advisoryEntry : this.securityAdvisories) {
                this.reAssociateAdvisory(advisoryEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reAssociateAdvisory(AdvisoryEntry advisoryEntry) {
        if (!this.reAssociateAdvisories) {
            LOG.debug("Skipping re-association of advisory [{}] due to configuration", (Object)advisoryEntry.getId());
            return;
        }
        Set<Vulnerability> set = this.vulnerabilities;
        synchronized (set) {
            for (Vulnerability vulnerability : this.vulnerabilities) {
                boolean hasMatchingAdvisories;
                if (vulnerability.getReferencedSecurityAdvisories().isEmpty() || !(hasMatchingAdvisories = vulnerability.deepCopyReferencedSecurityAdvisories().values().stream().flatMap(Collection::stream).anyMatch(e -> StringUtils.equals(advisoryEntry.getId(), e)))) continue;
                vulnerability.addSecurityAdvisory(advisoryEntry);
            }
        }
    }

    public void parse() {
        this.parse(this.inventory.getArtifacts(), this.inventory.getVulnerabilityMetaData(this.vulnerabilityContextName), this.inventory.getAdvisoryMetaData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(List<Artifact> artifacts, List<VulnerabilityMetaData> vmds, List<AdvisoryMetaData> amds) {
        List artifactsForVulnerability;
        String key;
        Map artifactMap;
        Set<MatchableDetailsAmbDataClass> set = this.vulnerabilities;
        synchronized (set) {
            this.vulnerabilities.clear();
            this.vulnerabilityByName.clear();
        }
        set = this.securityAdvisories;
        synchronized (set) {
            this.securityAdvisories.clear();
            this.advisoryByName.clear();
        }
        long startTime = System.currentTimeMillis();
        HashMap<String, Map<String, List<Artifact>>> affectsArtifacts = new HashMap<String, Map<String, List<Artifact>>>();
        for (Artifact artifact : artifacts) {
            VulnerabilityContextInventory.extractAffectsArtifactsForKey(artifact, affectsArtifacts, (AbstractModelBase.Attribute)Artifact.Attribute.VULNERABILITY);
            VulnerabilityContextInventory.extractAffectsArtifactsForKey(artifact, affectsArtifacts, InventoryAttribute.VULNERABILITIES_FIXED_BY_KB);
            VulnerabilityContextInventory.extractAffectsArtifactsForKey(artifact, affectsArtifacts, InventoryAttribute.INAPPLICABLE_CVE);
            VulnerabilityContextInventory.extractAffectsArtifactsForKey(artifact, affectsArtifacts, InventoryAttribute.ADDON_CVES);
        }
        Set<AdvisoryEntry> set2 = this.vulnerabilities;
        synchronized (set2) {
            for (VulnerabilityMetaData vmd : vmds) {
                Vulnerability vulnerability = Vulnerability.fromVulnerabilityMetaData(vmd);
                this.vulnerabilities.add(vulnerability);
                this.vulnerabilityByName.put(vulnerability.getId(), vulnerability);
                artifactMap = (Map)affectsArtifacts.get(vulnerability.getId());
                if (artifactMap == null) continue;
                for (Map.Entry artifactEntry : artifactMap.entrySet()) {
                    key = (String)artifactEntry.getKey();
                    artifactsForVulnerability = (List)artifactEntry.getValue();
                    for (Artifact artifact : artifactsForVulnerability) {
                        vulnerability.manuallyAffectsArtifact(key, artifact);
                    }
                }
            }
        }
        set2 = this.securityAdvisories;
        synchronized (set2) {
            for (AdvisoryMetaData amd : amds) {
                AdvisoryEntry advisoryEntry = AdvisoryEntry.fromAdvisoryMetaData(amd);
                this.securityAdvisories.add(advisoryEntry);
                this.advisoryByName.put(advisoryEntry.getId(), advisoryEntry);
                artifactMap = (Map)affectsArtifacts.get(advisoryEntry.getId());
                if (artifactMap == null) continue;
                for (Map.Entry artifactEntry : artifactMap.entrySet()) {
                    key = (String)artifactEntry.getKey();
                    artifactsForVulnerability = (List)artifactEntry.getValue();
                    for (Artifact artifact : artifactsForVulnerability) {
                        advisoryEntry.manuallyAffectsArtifact(key, artifact);
                    }
                }
            }
        }
        this.reAssociateVulnerabilities();
        LOG.debug("Parsed [{}] vulnerabilities and [{}] security advisories in [{}] ms", new Object[]{this.vulnerabilities.size(), this.securityAdvisories.size(), System.currentTimeMillis() - startTime});
    }

    private static void extractAffectsArtifactsForKey(Artifact artifact, Map<String, Map<String, List<Artifact>>> affectsArtifacts, AbstractModelBase.Attribute attribute) {
        String vulnerabilityString = artifact.get(attribute);
        if (StringUtils.hasText(vulnerabilityString)) {
            HashSet<String> vulnerabilityNames = new HashSet<String>(Arrays.asList(vulnerabilityString.split(", ")));
            for (String name : vulnerabilityNames) {
                affectsArtifacts.computeIfAbsent(name, k -> new HashMap()).computeIfAbsent(attribute.getKey(), k -> new ArrayList()).add(artifact);
            }
        }
    }

    public static VulnerabilityContextInventory fromFile(File file) throws IOException {
        return VulnerabilityContextInventory.fromInventory(new InventoryReader().readInventory(file));
    }

    public static VulnerabilityContextInventory fromInventory(Inventory inventory) {
        VulnerabilityContextInventory vInventory = new VulnerabilityContextInventory(inventory);
        vInventory.parse();
        return vInventory;
    }

    public static VulnerabilityContextInventory fromInventory(Inventory inventory, String vulnerabilityContextName) {
        VulnerabilityContextInventory vInventory = new VulnerabilityContextInventory(inventory, vulnerabilityContextName);
        vInventory.parse();
        return vInventory;
    }

    public static Map<String, VulnerabilityContextInventory> fromInventories(Map<String, Inventory> inventories) {
        HashMap<String, VulnerabilityContextInventory> vInventories = new HashMap<String, VulnerabilityContextInventory>();
        for (Map.Entry<String, Inventory> entry : inventories.entrySet()) {
            String vulnerabilityContextName = entry.getKey();
            Inventory inventory = entry.getValue();
            VulnerabilityContextInventory vInventory = new VulnerabilityContextInventory(inventory);
            vInventory.parse();
            vInventories.put(vulnerabilityContextName, vInventory);
        }
        return vInventories;
    }

    public static VulnerabilityContextInventory empty() {
        return new VulnerabilityContextInventory(new Inventory());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Set<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public Set<AdvisoryEntry> getSecurityAdvisories() {
        return this.securityAdvisories;
    }

    public void setReAssociateAdvisories(boolean reAssociateAdvisories) {
        this.reAssociateAdvisories = reAssociateAdvisories;
    }

    public void setReAssociateVulnerabilities(boolean reAssociateVulnerabilities) {
        this.reAssociateVulnerabilities = reAssociateVulnerabilities;
    }

    private static /* synthetic */ boolean lambda$writeBack$18(Artifact artifact, DataSourceIndicator.AnyArtifactOverwriteSourceReason reason) {
        return reason.isArtifact(artifact) && Objects.equals(reason.getSource(), InventoryAttribute.ADDON_CVES.getKey());
    }
}

