/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.eol;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.VersionComparator;
import com.metaeffekt.mirror.contents.eol.EolStringFormatter;
import com.metaeffekt.mirror.contents.eol.StateMapping;
import com.metaeffekt.mirror.contents.eol.state.DiscontinuedState;
import com.metaeffekt.mirror.contents.eol.state.EolState;
import com.metaeffekt.mirror.contents.eol.state.LtsState;
import com.metaeffekt.mirror.contents.eol.state.SupportState;
import com.metaeffekt.mirror.contents.eol.state.TechnicalGuidanceState;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONObject;

public class EolCycle
implements Comparable<EolCycle> {
    private String product;
    private final String cycle;
    private final String releaseDate;
    private final String latest;
    private final String latestReleaseDate;
    private final String link;
    private final String eol;
    private final String lts;
    private final String discontinued;
    private final String support;
    private final String extendedSupport;
    private final String technicalGuidance;
    private final String supportedPhpVersions;
    private final String latestJdkVersion;
    private final String upgradeVersion;
    private final String releaseLabel;
    private final String supportedKubernetesVersions;
    private final String supportedJavaVersions;
    private final String minRubyVersion;
    private final String codename;
    private final String minJavaVersion;
    private static final Comparator<EolCycle> DEFAULT_COMPARATOR = Comparator.comparing(EolCycle::getProduct, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing((o1, o2) -> {
        if (o1.getCycle() == null || o2.getCycle() == null) {
            return 0;
        }
        return VersionComparator.INSTANCE.compare(o1.getCycle(), o2.getCycle());
    }).thenComparing(EolCycle::getReleaseDate, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(EolCycle::getEol, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing((o1, o2) -> {
        if (o1.getLatest() == null || o2.getLatest() == null) {
            return 0;
        }
        return VersionComparator.INSTANCE.compare(o1.getLatest(), o2.getLatest());
    }).thenComparing(EolCycle::getLink, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(EolCycle::getLts, Comparator.nullsLast(Comparator.naturalOrder()));

    public EolCycle(String product, String cycle, String releaseDate, String eol, String latest, String link, String lts, String support, String discontinued, String latestReleaseDate, String supportedPhpVersions, String latestJdkVersion, String extendedSupport, String upgradeVersion, String releaseLabel, String supportedKubernetesVersions, String minRubyVersion, String codename, String technicalGuidance, String supportedJavaVersions, String minJavaVersion) {
        this.product = product;
        this.cycle = cycle;
        this.releaseDate = releaseDate;
        this.eol = eol;
        this.latest = latest;
        this.lts = lts;
        this.support = support;
        this.discontinued = discontinued;
        this.latestReleaseDate = latestReleaseDate;
        this.supportedPhpVersions = supportedPhpVersions;
        this.latestJdkVersion = latestJdkVersion;
        this.extendedSupport = extendedSupport;
        this.upgradeVersion = upgradeVersion;
        this.supportedKubernetesVersions = supportedKubernetesVersions;
        this.minRubyVersion = minRubyVersion;
        this.codename = codename;
        this.technicalGuidance = technicalGuidance;
        this.supportedJavaVersions = supportedJavaVersions;
        this.minJavaVersion = minJavaVersion;
        this.link = EolStringFormatter.format(link, this);
        this.releaseLabel = EolStringFormatter.format(releaseLabel, this);
    }

    public EolCycle(String product, String cycle) {
        this(product, cycle, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public LtsState getLtsState() {
        return new StateMapping<LtsState>(LtsState.NOT_LTS, LtsState.LTS, LtsState.LTS_DATE_REACHED, LtsState.UPCOMING_LTS_DATE, false, "lts").getState(this.lts, 0L);
    }

    public DiscontinuedState getDiscontinuedState() {
        return new StateMapping<DiscontinuedState>(DiscontinuedState.NOT_DISCONTINUED, DiscontinuedState.DISCONTINUED, DiscontinuedState.DISCONTINUED_DATE_REACHED, DiscontinuedState.UPCOMING_DISCONTINUED_DATE, false, "discontinued").getState(this.discontinued, 0L);
    }

    public EolState getEolState() {
        return this.getEolState(0L);
    }

    public EolState getEolState(long millisUntilEolWarning) {
        return new StateMapping<EolState>(EolState.NOT_EOL, EolState.EOL, EolState.EOL_DATE_REACHED, EolState.DISTANT_EOL_DATE, EolState.UPCOMING_EOL_DATE, false, "eol").getState(this.eol, millisUntilEolWarning);
    }

    public SupportState getSupportState() {
        return this.getSupportState(0L);
    }

    public SupportState getSupportState(long millisUntilSupportEndWarning) {
        if (StringUtils.isEmpty(this.support)) {
            return SupportState.fromEolState(this.getEolState(millisUntilSupportEndWarning));
        }
        return new StateMapping<SupportState>(SupportState.NO_SUPPORT, SupportState.SUPPORT, SupportState.SUPPORT_END_DATE_REACHED, SupportState.DISTANT_SUPPORT_END_DATE, SupportState.UPCOMING_SUPPORT_END_DATE, false, "support").getState(this.support, millisUntilSupportEndWarning);
    }

    public SupportState getExtendedSupportState() {
        return this.getExtendedSupportState(0L);
    }

    public SupportState getExtendedSupportState(long millisUntilExtendedSupportEndWarning) {
        if (StringUtils.isEmpty(this.extendedSupport) || this.extendedSupport.equals("false")) {
            EolState eolState = this.getEolState(millisUntilExtendedSupportEndWarning);
            if (eolState == EolState.UPCOMING_EOL_DATE || eolState == EolState.EOL_DATE_REACHED || eolState == EolState.DISTANT_EOL_DATE) {
                if ("false".equals(this.support)) {
                    return SupportState.fromEolState(eolState);
                }
                Date eolDate = TimeUtils.tryParse(this.eol);
                Date supportDate = TimeUtils.tryParse(this.support);
                if (eolDate != null && supportDate != null) {
                    if (eolDate.after(supportDate)) {
                        return SupportState.fromEolState(eolState);
                    }
                    return SupportState.NO_SUPPORT;
                }
            } else if (eolState == EolState.NOT_EOL) {
                return SupportState.SUPPORT;
            }
        }
        return new StateMapping<SupportState>(SupportState.NO_SUPPORT, SupportState.SUPPORT, SupportState.SUPPORT_END_DATE_REACHED, SupportState.DISTANT_SUPPORT_END_DATE, SupportState.UPCOMING_SUPPORT_END_DATE, false, "support").getState(this.extendedSupport, millisUntilExtendedSupportEndWarning);
    }

    public TechnicalGuidanceState getTechnicalGuidanceState() {
        return new StateMapping<TechnicalGuidanceState>(TechnicalGuidanceState.NO_TECHNICAL_GUIDANCE, TechnicalGuidanceState.TECHNICAL_GUIDANCE, TechnicalGuidanceState.END_OF_TECHNICAL_GUIDANCE_DATE_REACHED, TechnicalGuidanceState.UPCOMING_END_OF_TECHNICAL_GUIDANCE_DATE, false, "technicalGuidance").getState(this.technicalGuidance, 0L);
    }

    public String getSupport() {
        if (StringUtils.isEmpty(this.support)) {
            EolState eolState = this.getEolState();
            switch (eolState) {
                case EOL: {
                    return "false";
                }
                case NOT_EOL: {
                    return "true";
                }
            }
            return this.eol;
        }
        return this.support;
    }

    public String getExtendedSupport() {
        if (StringUtils.isEmpty(this.extendedSupport)) {
            if (Objects.equals(this.support, this.eol)) {
                return this.extendedSupport;
            }
            EolState eolState = this.getEolState();
            if (eolState == EolState.UPCOMING_EOL_DATE || eolState == EolState.EOL_DATE_REACHED || eolState == EolState.DISTANT_EOL_DATE) {
                if ("false".equals(this.support)) {
                    return this.eol;
                }
                Date eolDate = TimeUtils.tryParse(this.eol);
                Date supportDate = TimeUtils.tryParse(this.support);
                if (eolDate != null && supportDate != null) {
                    if (eolDate.after(supportDate)) {
                        return this.eol;
                    }
                    return "false";
                }
            }
        }
        return this.extendedSupport;
    }

    public boolean isExtendedSupportGenerallyAvailable() {
        return !StringUtils.isEmpty(this.getExtendedSupport());
    }

    public long getTimeUntilSupportEnd() {
        return this.getTimeUntil(this.getSupport(), true);
    }

    public static String formatTimeUntilOrAgo(long timeUntil) {
        return TimeUtils.formatTimeUntilOrAgo(timeUntil, "", "in", "ago", "", " and ", "no date provided");
    }

    public long getTimeUntilExtendedSupportEnd() {
        return this.getTimeUntil(this.getExtendedSupport(), true);
    }

    public long getTimeUntilTechnicalGuidanceEnd() {
        return this.getTimeUntil(this.technicalGuidance, true);
    }

    public long getTimeUntilEol() {
        return this.getTimeUntil(this.eol, false);
    }

    public long getTimeUntilDiscontinued() {
        return this.getTimeUntil(this.discontinued, true);
    }

    public long getTimeUntilLtsStart() {
        return this.getTimeUntil(this.lts, false);
    }

    private long getTimeUntil(String dateString, boolean trueIsMax) {
        if (StringUtils.isEmpty(dateString)) {
            return Long.MAX_VALUE;
        }
        if ("true".equals(dateString)) {
            return trueIsMax ? Long.MAX_VALUE : 0L;
        }
        if ("false".equals(dateString)) {
            return trueIsMax ? 0L : Long.MAX_VALUE;
        }
        Date date = TimeUtils.tryParse(dateString);
        if (date == null) {
            return 0L;
        }
        return date.getTime() - StateMapping.getNOW().getTime();
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        this.putIfNotNull(json, "product", this.product);
        this.putIfNotNull(json, "cycle", this.cycle);
        this.putIfNotNull(json, "releaseDate", this.releaseDate);
        this.putIfNotNull(json, "eol", this.eol);
        this.putIfNotNull(json, "latest", this.latest);
        this.putIfNotNull(json, "link", this.link);
        this.putIfNotNull(json, "lts", this.lts);
        this.putIfNotNull(json, "support", this.support);
        this.putIfNotNull(json, "discontinued", this.discontinued);
        this.putIfNotNull(json, "latestReleaseDate", this.latestReleaseDate);
        this.putIfNotNull(json, "supportedPhpVersions", this.supportedPhpVersions);
        this.putIfNotNull(json, "latestJdkVersion", this.latestJdkVersion);
        this.putIfNotNull(json, "extendedSupport", this.extendedSupport);
        this.putIfNotNull(json, "upgradeVersion", this.upgradeVersion);
        this.putIfNotNull(json, "releaseLabel", this.releaseLabel);
        this.putIfNotNull(json, "supportedKubernetesVersions", this.supportedKubernetesVersions);
        this.putIfNotNull(json, "minRubyVersion", this.minRubyVersion);
        this.putIfNotNull(json, "supportedPHPVersions", this.supportedPhpVersions);
        this.putIfNotNull(json, "codename", this.codename);
        this.putIfNotNull(json, "technicalGuidance", this.technicalGuidance);
        this.putIfNotNull(json, "supportedJavaVersions", this.supportedJavaVersions);
        this.putIfNotNull(json, "minJavaVersion", this.minJavaVersion);
        return json;
    }

    public Document toDocument() {
        Document document = new Document();
        this.addFieldToDocument(document, "product", this.product);
        this.addFieldToDocument(document, "cycle", this.cycle);
        this.addFieldToDocument(document, "releaseDate", this.releaseDate);
        this.addFieldToDocument(document, "eol", this.eol);
        this.addFieldToDocument(document, "latest", this.latest);
        this.addFieldToDocument(document, "link", this.link);
        this.addFieldToDocument(document, "lts", this.lts);
        this.addFieldToDocument(document, "support", this.support);
        this.addFieldToDocument(document, "discontinued", this.discontinued);
        this.addFieldToDocument(document, "latestReleaseDate", this.latestReleaseDate);
        this.addFieldToDocument(document, "supportedPhpVersions", this.supportedPhpVersions);
        this.addFieldToDocument(document, "latestJdkVersion", this.latestJdkVersion);
        this.addFieldToDocument(document, "extendedSupport", this.extendedSupport);
        this.addFieldToDocument(document, "upgradeVersion", this.upgradeVersion);
        this.addFieldToDocument(document, "releaseLabel", this.releaseLabel);
        this.addFieldToDocument(document, "supportedKubernetesVersions", this.supportedKubernetesVersions);
        this.addFieldToDocument(document, "minRubyVersion", this.minRubyVersion);
        this.addFieldToDocument(document, "supportedPHPVersions", this.supportedPhpVersions);
        this.addFieldToDocument(document, "codename", this.codename);
        this.addFieldToDocument(document, "technicalGuidance", this.technicalGuidance);
        this.addFieldToDocument(document, "supportedJavaVersions", this.supportedJavaVersions);
        this.addFieldToDocument(document, "minJavaVersion", this.minJavaVersion);
        return document;
    }

    public static EolCycle fromJson(JSONObject json) {
        return new EolCycle(EolCycle.parseJson(json, "product"), EolCycle.parseJson(json, "cycle"), EolCycle.parseJson(json, "releaseDate"), EolCycle.parseJson(json, "eol"), EolCycle.parseJson(json, "latest"), EolCycle.parseJson(json, "link"), EolCycle.parseJson(json, "lts"), EolCycle.parseJson(json, "support"), EolCycle.parseJson(json, "discontinued"), EolCycle.parseJson(json, "latestReleaseDate"), (String)ObjectUtils.firstNonNull((Object[])new String[]{EolCycle.parseJson(json, "supportedPhpVersions"), EolCycle.parseJson(json, "supportedPHPVersions")}), EolCycle.parseJson(json, "latestJdkVersion"), EolCycle.parseJson(json, "extendedSupport"), EolCycle.parseJson(json, "upgradeVersion"), EolCycle.parseJson(json, "releaseLabel"), EolCycle.parseJson(json, "supportedKubernetesVersions"), EolCycle.parseJson(json, "minRubyVersion"), EolCycle.parseJson(json, "codename"), EolCycle.parseJson(json, "technicalGuidance"), EolCycle.parseJson(json, "supportedJavaVersions"), EolCycle.parseJson(json, "minJavaVersion"));
    }

    public static EolCycle fromDocument(Document e) {
        return new EolCycle(e.get("product"), e.get("cycle"), e.get("releaseDate"), e.get("eol"), e.get("latest"), e.get("link"), e.get("lts"), e.get("support"), e.get("discontinued"), e.get("latestReleaseDate"), (String)ObjectUtils.firstNonNull((Object[])new String[]{e.get("supportedPhpVersions"), e.get("supportedPHPVersions")}), e.get("latestJdkVersion"), e.get("extendedSupport"), e.get("upgradeVersion"), e.get("releaseLabel"), e.get("supportedKubernetesVersions"), e.get("minRubyVersion"), e.get("codename"), e.get("technicalGuidance"), e.get("supportedJavaVersions"), e.get("minJavaVersion"));
    }

    @Override
    public int compareTo(EolCycle o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }

    private static String parseJson(JSONObject json, String key) {
        Object obj = json.opt(key);
        if (obj instanceof Boolean) {
            return Boolean.toString((Boolean)obj);
        }
        if (obj != null && !obj.toString().equals("null")) {
            return obj.toString();
        }
        return null;
    }

    private void putIfNotNull(JSONObject json, String key, String value) {
        if (value != null && !value.equals("null")) {
            json.put(key, (Object)value);
        }
    }

    private void addFieldToDocument(Document document, String fieldName, String fieldValue) {
        if (fieldValue != null && !fieldValue.equals("null")) {
            document.add((IndexableField)new TextField(fieldName, fieldValue, Field.Store.YES));
        }
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getProduct() {
        return this.product;
    }

    public String getCycle() {
        return this.cycle;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getEol() {
        return this.eol;
    }

    public String getLatest() {
        return this.latest;
    }

    public String getLink() {
        return this.link;
    }

    public String getLts() {
        return this.lts;
    }

    public String getDiscontinued() {
        return this.discontinued;
    }

    public String getLatestReleaseDate() {
        return this.latestReleaseDate;
    }

    public String getSupportedPhpVersions() {
        return this.supportedPhpVersions;
    }

    public String getLatestJdkVersion() {
        return this.latestJdkVersion;
    }

    public String getUpgradeVersion() {
        return this.upgradeVersion;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public String getSupportedKubernetesVersions() {
        return this.supportedKubernetesVersions;
    }

    public String getMinRubyVersion() {
        return this.minRubyVersion;
    }

    public String getCodename() {
        return this.codename;
    }

    public String getTechnicalGuidance() {
        return this.technicalGuidance;
    }

    public String getSupportedJavaVersions() {
        return this.supportedJavaVersions;
    }

    public String getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public int matchVersion(String checkVersion) {
        Version releaseLabelVersionInstance;
        Version cycleVersionInstance;
        boolean releaseLabelDefined;
        if (checkVersion == null) {
            return -1;
        }
        if (checkVersion.equals(this.latest)) {
            return Integer.MAX_VALUE;
        }
        String normalizedVersion = this.normalizeVersionForComparison(checkVersion);
        String normalizedCycle = this.normalizeVersionForComparison(this.cycle);
        String normalizedReleaseLabel = this.normalizeVersionForComparison(this.releaseLabel);
        boolean cycleDefined = normalizedCycle != null;
        boolean bl = releaseLabelDefined = normalizedReleaseLabel != null;
        if (cycleDefined && normalizedVersion.startsWith(normalizedCycle)) {
            return normalizedCycle.length();
        }
        if (releaseLabelDefined && normalizedVersion.startsWith(normalizedReleaseLabel)) {
            return normalizedReleaseLabel.length();
        }
        if (cycleDefined && normalizedCycle.startsWith(normalizedVersion)) {
            return normalizedVersion.length();
        }
        if (releaseLabelDefined && normalizedReleaseLabel.startsWith(normalizedVersion)) {
            return normalizedVersion.length();
        }
        Version checkVersionInstance = Version.of(checkVersion);
        if (cycleDefined ? (cycleVersionInstance = Version.of(this.cycle)).matchesVersionOf(checkVersionInstance) : releaseLabelDefined && (releaseLabelVersionInstance = Version.of(this.releaseLabel)).matchesVersionOf(checkVersionInstance)) {
            return Integer.MAX_VALUE;
        }
        return -1;
    }

    private String normalizeVersionForComparison(String version) {
        if (version == null) {
            return null;
        }
        if (version.startsWith("v")) {
            version = version.substring(1);
        }
        version = version.toLowerCase();
        version = version.replaceAll("[^a-z0-9.]", "");
        return version;
    }

    public boolean containsPhpVersion(String version) {
        return this.containsSupportedVersion(version, this.supportedPhpVersions);
    }

    public boolean containsKubernetesVersion(String version) {
        return this.containsSupportedVersion(version, this.supportedKubernetesVersions);
    }

    public boolean containsJavaVersion(String version) {
        return this.containsSupportedVersion(version, this.supportedJavaVersions);
    }

    private boolean containsSupportedVersion(String version, String supportedVersions) {
        String[] versions;
        if (version == null) {
            return false;
        }
        if (supportedVersions == null) {
            return false;
        }
        for (String ver : versions = supportedVersions.split(", ?")) {
            if (!this.checkIfSingleVersionIsContained(ver, version)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfSingleVersionIsContained(String part, String version) {
        if (part.contains(" - ")) {
            String[] range = part.split(" - ");
            if (range.length != 2) {
                return false;
            }
            return VersionComparator.INSTANCE.compare(range[0], version) <= 0 && VersionComparator.INSTANCE.compare(range[1], version) >= 0;
        }
        return version.startsWith(part);
    }
}

