/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.eol;

import com.metaeffekt.mirror.contents.eol.EolCycle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class EolStringFormatter {
    private static final Map<String, Function<EolCycle, String>> VARIABLE_MAPPERS = new LinkedHashMap<String, Function<EolCycle, String>>(){
        {
            this.put("__LATEST__", EolCycle::getLatest);
            this.put("__VERSION__", EolCycle::getLatest);
            this.put("__RELEASE_CYCLE__", EolCycle::getCycle);
            this.put("__CODENAME__", EolCycle::getCodename);
        }
    };

    public static String format(String baseString, EolCycle cycle) {
        if (baseString == null) {
            return null;
        }
        return baseString.contains("__") || baseString.contains("{{") ? EolStringFormatter.replaceExpressions(EolStringFormatter.replaceVariables(baseString, cycle), cycle) : baseString;
    }

    private static String replaceVariables(String baseString, EolCycle cycle) {
        if (baseString == null) {
            return null;
        }
        String result = baseString;
        for (Map.Entry<String, Function<EolCycle, String>> entry : VARIABLE_MAPPERS.entrySet()) {
            String applied = entry.getValue().apply(cycle);
            String escaped = applied == null ? "" : applied.replace("\\", "\\\\").replace("'", "\\'");
            result = result.replace(entry.getKey(), escaped);
        }
        return result;
    }

    private static String replaceExpressions(String baseString, EolCycle cycle) {
        String expression;
        String result = baseString;
        for (int i = 0; i < 100 && (expression = EolStringFormatter.extractNextExpression(result)) != null; ++i) {
            String replacement = EolStringFormatter.evaluateExpression(expression, cycle);
            result = result.replace(expression, replacement);
        }
        return result;
    }

    private static String extractNextExpression(String result) {
        if (result == null) {
            return null;
        }
        int start = result.lastIndexOf("{{");
        if (start < 0) {
            return null;
        }
        int end = result.indexOf("}}", start);
        if (end < 0) {
            return null;
        }
        return result.substring(start, end + 2);
    }

    private static String evaluateExpression(String expression, EolCycle cycle) {
        String innerExpression = expression.substring(2, expression.length() - 2);
        List<String> tokens = EolStringFormatter.tokenizeString(innerExpression);
        if (tokens.size() >= 3) {
            String object = tokens.get(0);
            String functionName = tokens.get(1);
            String[] arguments = tokens.subList(2, tokens.size()).toArray(new String[0]);
            return EolStringFormatter.evaluateFunction(object, functionName, arguments, cycle);
        }
        throw new IllegalArgumentException("Invalid expression: " + innerExpression);
    }

    private static String evaluateFunction(String object, String functionName, String[] arguments, EolCycle cycle) {
        switch (functionName) {
            case "replace": {
                return object.replace(arguments[0], arguments[1]);
            }
            case "trim": {
                return object.trim();
            }
            case "toLowerCase": 
            case "lowerCase": 
            case "lower": {
                return object.toLowerCase();
            }
            case "toUpperCase": 
            case "upperCase": 
            case "upper": {
                return object.toUpperCase();
            }
            case "substring": {
                if (arguments.length == 1) {
                    return object.substring(Integer.parseInt(arguments[0]));
                }
                if (arguments.length == 2) {
                    return object.substring(Integer.parseInt(arguments[0]), Integer.parseInt(arguments[1]));
                }
                throw new IllegalArgumentException("Invalid number of arguments for substring: " + arguments.length);
            }
        }
        throw new IllegalArgumentException("Unknown function: " + functionName);
    }

    private static List<String> tokenizeString(String innerExpression) {
        StringBuilder tokenBuilder = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        boolean inString = false;
        boolean wasInStringBeforeExiting = false;
        for (int i = 0; i < innerExpression.length(); ++i) {
            char c = innerExpression.charAt(i);
            if (c == '\\') {
                tokenBuilder.append(innerExpression.charAt(++i));
                continue;
            }
            if (c == '\'') {
                inString = !inString;
                wasInStringBeforeExiting = true;
                continue;
            }
            if (!(c != ':' && c != '|' && c != ',' || inString)) {
                tokens.add(tokenBuilder.toString());
                tokenBuilder.setLength(0);
                wasInStringBeforeExiting = false;
                continue;
            }
            tokenBuilder.append(c);
        }
        if (tokenBuilder.length() > 0 || wasInStringBeforeExiting) {
            tokens.add(tokenBuilder.toString());
        }
        return tokens;
    }
}

