/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.eol.export;

import com.metaeffekt.mirror.contents.eol.EolCycle;
import com.metaeffekt.mirror.contents.eol.export.CycleScenarioRating;
import org.json.JSONObject;

public enum CycleStateExtendedSupportInformationPresent {
    SUPPORT_VALID("supportValid", CycleScenarioRating.RATING_1),
    SUPPORT_ENDING_SOON("supportEndingSoon", CycleScenarioRating.RATING_2),
    EXTENDED_SUPPORT_VALID("extendedSupportValid", CycleScenarioRating.RATING_3),
    EXTENDED_SUPPORT_ENDING_SOON("extendedSupportEnding", CycleScenarioRating.RATING_4),
    EXTENDED_SUPPORT_EXPIRED("extendedSupportExpired", CycleScenarioRating.RATING_5);

    private final String key;
    private final CycleScenarioRating rating;

    private CycleStateExtendedSupportInformationPresent(String key, CycleScenarioRating rating) {
        this.key = key;
        this.rating = rating;
    }

    public JSONObject toJson() {
        return new JSONObject().put("key", (Object)this.key).put("rating", this.getRating().getRating());
    }

    public static CycleStateExtendedSupportInformationPresent from(EolCycle cycle, long millisUntilEol, long millisUntilExtendedSupportEndWarning) {
        long timeUntilSupportEnd = cycle.getTimeUntilSupportEnd();
        long timeUntilEol = cycle.getTimeUntilEol();
        long timeUntilExtendedSupportEnd = cycle.getTimeUntilExtendedSupportEnd();
        long effectiveTimeUntilExtendedSupportEnd = Long.MAX_VALUE == timeUntilExtendedSupportEnd ? timeUntilEol : Math.max(timeUntilEol, timeUntilExtendedSupportEnd);
        if (effectiveTimeUntilExtendedSupportEnd <= 0L) {
            return EXTENDED_SUPPORT_EXPIRED;
        }
        if (timeUntilSupportEnd > 0L) {
            if (timeUntilSupportEnd < millisUntilEol) {
                return SUPPORT_ENDING_SOON;
            }
            return SUPPORT_VALID;
        }
        if (effectiveTimeUntilExtendedSupportEnd < millisUntilExtendedSupportEndWarning) {
            return EXTENDED_SUPPORT_ENDING_SOON;
        }
        return EXTENDED_SUPPORT_VALID;
    }

    public static CycleStateExtendedSupportInformationPresent fromJson(JSONObject jsonObject) {
        String key = jsonObject.getString("key");
        for (CycleStateExtendedSupportInformationPresent value : CycleStateExtendedSupportInformationPresent.values()) {
            if (!value.getKey().equals(key)) continue;
            return value;
        }
        throw new IllegalArgumentException("No enum constant for key: " + key);
    }

    public String getKey() {
        return this.key;
    }

    public CycleScenarioRating getRating() {
        return this.rating;
    }
}

